/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.XMethodParameter;

public abstract class PointerUsageRequiringNonNullValue {
    private static final PointerUsageRequiringNonNullValue instance = new PointerUsageRequiringNonNullValue(){

        public boolean isDirect() {
            return true;
        }

        public String getDescription() {
            return "SOURCE_LINE_DEREF";
        }
    };
    private static final PointerUsageRequiringNonNullValue nonNullReturnInstance = new PointerUsageRequiringNonNullValue(){

        public boolean getReturnFromNonNullMethod() {
            return true;
        }

        public String getDescription() {
            return "SOURCE_LINE_RETURNED";
        }
    };

    public abstract String getDescription();

    public boolean isDirect() {
        return false;
    }

    public boolean getReturnFromNonNullMethod() {
        return false;
    }

    @CheckForNull
    public XMethodParameter getNonNullParameter() {
        return null;
    }

    @CheckForNull
    public XField getNonNullField() {
        return null;
    }

    public static PointerUsageRequiringNonNullValue getPointerDereference() {
        return instance;
    }

    public static PointerUsageRequiringNonNullValue getReturnFromNonNullMethod(XMethod m) {
        return nonNullReturnInstance;
    }

    public static PointerUsageRequiringNonNullValue getPassedAsNonNullParameter(final XMethod m, final int param) {
        return new PointerUsageRequiringNonNullValue(){

            @CheckForNull
            public XMethodParameter getNonNullParameter() {
                return new XMethodParameter(m, param);
            }

            public String getDescription() {
                return "SOURCE_LINE_INVOKED";
            }
        };
    }

    public static PointerUsageRequiringNonNullValue getStoredIntoNonNullField(final XField f) {
        return new PointerUsageRequiringNonNullValue(){

            @CheckForNull
            public XField getNonNullField() {
                return f;
            }

            public String getDescription() {
                return "SOURCE_LINE_STORED";
            }
        };
    }
}

