/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.constant;

import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.Dataflow;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.DataflowTestDriver;
import edu.umd.cs.findbugs.ba.DepthFirstSearch;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.FrameDataflowAnalysis;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.constant.Constant;
import edu.umd.cs.findbugs.ba.constant.ConstantFrame;
import edu.umd.cs.findbugs.ba.constant.ConstantFrameModelingVisitor;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.MethodGen;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantAnalysis
extends FrameDataflowAnalysis<Constant, ConstantFrame> {
    private MethodGen methodGen;
    private ConstantFrameModelingVisitor visitor;
    static /* synthetic */ Class class$edu$umd$cs$findbugs$ba$constant$ConstantAnalysis;

    public ConstantAnalysis(MethodGen methodGen, DepthFirstSearch dfs) {
        super(dfs);
        this.methodGen = methodGen;
        this.visitor = new ConstantFrameModelingVisitor(methodGen.getConstantPool());
    }

    @Override
    public ConstantFrame createFact() {
        return new ConstantFrame(this.methodGen.getMaxLocals());
    }

    @Override
    public void initEntryFact(ConstantFrame frame) {
        frame.setValid();
        frame.clearStack();
        int numSlots = frame.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            frame.setValue(i, new Constant(new StringBuffer().append("parameter").append(i).toString()));
        }
    }

    @Override
    public void transferInstruction(InstructionHandle handle, BasicBlock basicBlock, ConstantFrame frame) throws DataflowAnalysisException {
        this.visitor.setFrameAndLocation(frame, new Location(handle, basicBlock));
        this.visitor.analyzeInstruction(handle.getInstruction());
    }

    @Override
    public void meetInto(ConstantFrame fact, Edge edge, ConstantFrame result) throws DataflowAnalysisException {
        if (fact.isValid()) {
            ConstantFrame tmpFact = null;
            if (edge.isExceptionEdge()) {
                tmpFact = this.modifyFrame(fact, tmpFact);
                tmpFact.clearStack();
                tmpFact.pushValue(Constant.NOT_CONSTANT);
            }
            if (tmpFact != null) {
                fact = tmpFact;
            }
        }
        this.mergeInto(fact, result);
    }

    @Override
    protected void mergeValues(ConstantFrame otherFrame, ConstantFrame resultFrame, int slot) throws DataflowAnalysisException {
        Constant value = Constant.merge((Constant)resultFrame.getValue(slot), (Constant)otherFrame.getValue(slot));
        resultFrame.setValue(slot, value);
    }

    public static void main(String[] argv) throws Exception {
        if (argv.length != 1) {
            System.err.println(new StringBuffer().append("Usage: ").append((class$edu$umd$cs$findbugs$ba$constant$ConstantAnalysis == null ? (class$edu$umd$cs$findbugs$ba$constant$ConstantAnalysis = ConstantAnalysis.class$("edu.umd.cs.findbugs.ba.constant.ConstantAnalysis")) : class$edu$umd$cs$findbugs$ba$constant$ConstantAnalysis).getName()).append(" <class file>").toString());
            System.exit(1);
        }
        DataflowTestDriver<ConstantFrame, ConstantAnalysis> driver = new DataflowTestDriver<ConstantFrame, ConstantAnalysis>(){

            @Override
            public Dataflow<ConstantFrame, ConstantAnalysis> createDataflow(ClassContext classContext, Method method) throws CFGBuilderException, DataflowAnalysisException {
                return classContext.getConstantDataflow(method);
            }
        };
        driver.execute(argv[0]);
    }

    @Override
    protected /* synthetic */ void mergeValues(Frame x0, Frame x1, int x2) throws DataflowAnalysisException {
        this.mergeValues((ConstantFrame)x0, (ConstantFrame)x1, x2);
    }

    @Override
    public /* synthetic */ void transferInstruction(InstructionHandle x0, BasicBlock x1, Object x2) throws DataflowAnalysisException {
        this.transferInstruction(x0, x1, (ConstantFrame)x2);
    }

    @Override
    public /* synthetic */ void meetInto(Object x0, Edge x1, Object x2) throws DataflowAnalysisException {
        this.meetInto((ConstantFrame)x0, x1, (ConstantFrame)x2);
    }

    @Override
    public /* synthetic */ void initEntryFact(Object x0) throws DataflowAnalysisException {
        this.initEntryFact((ConstantFrame)x0);
    }

    @Override
    public /* synthetic */ Object createFact() {
        return this.createFact();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError().initCause(x1);
        }
    }
}

