/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.swingui.ArchitectWizard;
import ca.sqlpower.architect.swingui.WizardPanel;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class WizardDialog
extends JDialog {
    JPanel top;
    JPanel customPanel;
    JButton nextButton;
    JButton backButton;
    JButton cancelButton;
    ArchitectWizard wizard;
    final JProgressBar progressBar = new JProgressBar();
    final JLabel progressLabel;

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    public JLabel getProgressLabel() {
        return this.progressLabel;
    }

    public WizardDialog(Frame frame, ArchitectWizard wizard) {
        super(frame);
        this.progressBar.setStringPainted(true);
        this.progressBar.setPreferredSize(this.progressBar.getPreferredSize());
        this.progressBar.setVisible(false);
        this.progressLabel = new JLabel("Starting...");
        this.progressLabel.setPreferredSize(this.progressBar.getPreferredSize());
        this.progressLabel.setVisible(false);
        this.wizard = wizard;
        wizard.setParentDialog(this);
        this.setupDialog();
    }

    private void setupDialog() {
        this.top = new JPanel(new BorderLayout());
        this.top.setPreferredSize(new Dimension(600, 400));
        this.customPanel = new JPanel(new GridLayout(1, 1));
        this.top.add((Component)this.customPanel, "Center");
        JPanel buttonPanel = new JPanel(new BorderLayout());
        JPanel bpRight = new JPanel(new FlowLayout(2));
        JPanel bpLeft = new JPanel(new FlowLayout(0));
        buttonPanel.add((Component)bpRight, "East");
        buttonPanel.add((Component)bpLeft, "West");
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel wp = WizardDialog.this.getWizard().getCurrent();
                wp.discardChanges();
                WizardDialog.this.setVisible(false);
            }
        });
        bpLeft.add(this.cancelButton);
        this.backButton = new JButton("< Back");
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardDialog.this.setWizardPanel(WizardDialog.this.getWizard().getPrevious());
                WizardDialog.this.refreshButtons();
            }
        });
        bpRight.add(this.backButton);
        this.nextButton = new JButton("Next >");
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                WizardPanel wp = WizardDialog.this.getWizard().getCurrent();
                if (wp.applyChanges()) {
                    if (!WizardDialog.this.getWizard().isOnLastPanel()) {
                        WizardDialog.this.setWizardPanel(WizardDialog.this.getWizard().getNext());
                    }
                    WizardDialog.this.refreshButtons();
                }
            }
        });
        bpRight.add(this.nextButton);
        JPanel progressPanel = new JPanel(new BorderLayout());
        FormLayout layout = new FormLayout("pref,4dlu,fill:pref:grow", "20dlu:grow");
        CellConstraints cc = new CellConstraints();
        PanelBuilder pb = new PanelBuilder(layout, progressPanel);
        pb.add((Component)this.progressLabel, cc.xy(1, 1));
        pb.add((Component)this.progressBar, cc.xy(3, 1));
        JPanel bottomPanel = new JPanel(new GridLayout(2, 1));
        bottomPanel.add(progressPanel);
        bottomPanel.add(buttonPanel);
        this.top.add((Component)bottomPanel, "South");
        this.setContentPane(this.top);
        this.setWizardPanel(this.getWizard().getCurrent());
        this.refreshButtons();
    }

    public void setWizardPanel(WizardPanel panel) {
        this.customPanel.removeAll();
        this.customPanel.add(panel.getPanel());
        this.customPanel.revalidate();
        this.customPanel.repaint();
        this.setTitle(panel.getTitle());
    }

    private void refreshButtons() {
        this.backButton.setVisible(true);
        if (this.getWizard().isOnLastPanel()) {
            this.nextButton.setText("Close");
            this.backButton.setVisible(false);
            this.cancelButton.setVisible(false);
        } else if (this.getWizard().isOnExecutePanel()) {
            this.nextButton.setText("Execute");
        } else {
            this.nextButton.setText("Next >");
        }
        if (this.getWizard().isOnFirstPanel()) {
            this.backButton.setVisible(false);
        }
    }

    public ArchitectWizard getWizard() {
        return this.wizard;
    }

    public JButton getBackButton() {
        return this.backButton;
    }

    public void setBackButton(JButton backButton) {
        this.backButton = backButton;
    }

    public JButton getNextButton() {
        return this.nextButton;
    }

    public void setNextButton(JButton nextButton) {
        this.nextButton = nextButton;
    }
}

