/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.architect.SQLObject;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLExceptionNode
extends SQLObject {
    protected Throwable exception;
    protected String message;
    protected SQLObject parent;

    public SQLExceptionNode(Throwable exception, String message) {
        this.exception = exception;
        this.message = message;
        this.children = Collections.EMPTY_LIST;
    }

    public Throwable getException() {
        return this.exception;
    }

    @Override
    public String getName() {
        return this.message;
    }

    @Override
    public SQLObject getParent() {
        return this.parent;
    }

    @Override
    public void setParent(SQLObject parent) {
        SQLObject oldParent = this.parent;
        this.parent = parent;
        this.fireDbObjectChanged("parent", oldParent, parent);
    }

    @Override
    public void populate() {
    }

    @Override
    protected void addChildImpl(int index, SQLObject child) {
        throw new UnsupportedOperationException("SQLExceptionNodes can't have children");
    }

    @Override
    public boolean isPopulated() {
        return true;
    }

    @Override
    public String getShortDisplayName() {
        return "Error: " + this.message;
    }

    @Override
    public boolean allowsChildren() {
        return false;
    }

    public String toString() {
        return this.getShortDisplayName();
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String v) {
        String oldMessage = this.message;
        this.message = v;
        this.fireDbObjectChanged("message", oldMessage, this.message);
    }

    @Override
    public Class<? extends SQLObject> getChildType() {
        return null;
    }
}

