/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.sql;

import com.darwinsys.sql.ConnectionUtil;
import com.darwinsys.sql.OutputMode;
import com.darwinsys.sql.ResultsDecorator;
import com.darwinsys.sql.ResultsDecoratorHTML;
import com.darwinsys.sql.ResultsDecoratorJTable;
import com.darwinsys.sql.ResultsDecoratorSQL;
import com.darwinsys.sql.ResultsDecoratorText;
import com.darwinsys.sql.ResultsDecoratorXML;
import com.darwinsys.sql.SQLRunnerErrorHandler;
import com.darwinsys.sql.SQLRunnerGUI;
import com.darwinsys.sql.SyntaxException;
import com.darwinsys.util.Verbosity;
import com.sun.rowset.WebRowSetImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.rowset.CachedRowSet;

public class SQLRunner {
    OutputMode outputMode = OutputMode.t;
    private static boolean okToExit = false;
    private Connection conn;
    private DatabaseMetaData dbMeta;
    private Statement statement;
    private PrintWriter out;
    private ResultsDecorator currentDecorator;
    private ResultsDecorator textDecorator;
    private ResultsDecorator sqlDecorator;
    private ResultsDecorator htmlDecorator;
    private ResultsDecorator xmlDecorator;
    private ResultsDecorator jtableDecorator;
    private boolean debug;
    private boolean escape;
    private boolean upperCaseTableNames;
    private SQLRunnerGUI gui;
    private static Verbosity verbosity = Verbosity.QUIET;

    public static void setOkToExit(boolean setting) {
        okToExit = setting;
    }

    public static boolean isOkToExit() {
        return okToExit;
    }

    public static void exit(int exitStatus) {
        if (okToExit) {
            System.exit(exitStatus);
        }
    }

    public SQLRunner(String driver, String dbUrl, String user, String password, String outputFile, String outputMode) throws IOException, ClassNotFoundException, SQLException {
        this.conn = ConnectionUtil.getConnection(driver, dbUrl, user, password);
        this.commonSetup(outputFile, outputMode);
    }

    public SQLRunner(Connection c, String outputFile, String outputModeName) throws IOException, SQLException {
        this.conn = c;
        this.commonSetup(outputFile, outputModeName);
    }

    private void commonSetup(String outputFileName, String outputModeName) throws IOException, SQLException {
        this.dbMeta = this.conn.getMetaData();
        this.upperCaseTableNames = this.dbMeta.getDatabaseProductName().indexOf("DB2") >= 0;
        String dbName = this.dbMeta.getDatabaseProductName();
        System.out.println("SQLRunner: Connected to " + dbName);
        this.statement = this.conn.createStatement(1004, 1007);
        this.out = outputFileName == null ? new PrintWriter(System.out) : new PrintWriter(new FileWriter(outputFileName));
        this.setOutputMode(outputModeName);
    }

    void setOutputMode(String outputModeName) {
        if (outputModeName == null || outputModeName.length() == 0) {
            System.err.println("invalid mode: " + (Object)((Object)this.outputMode) + "; must be t, h or s");
        }
        this.outputMode = OutputMode.valueOf(outputModeName);
        this.setOutputMode(this.outputMode);
    }

    void setOutputMode(OutputMode outputMode) {
        ResultsDecorator newDecorator = null;
        switch (outputMode) {
            case t: {
                if (this.textDecorator == null) {
                    this.textDecorator = new ResultsDecoratorText(this.out, verbosity);
                }
                newDecorator = this.textDecorator;
                break;
            }
            case h: {
                if (this.htmlDecorator == null) {
                    this.htmlDecorator = new ResultsDecoratorHTML(this.out, verbosity);
                }
                newDecorator = this.htmlDecorator;
                break;
            }
            case s: {
                if (this.sqlDecorator == null) {
                    this.sqlDecorator = new ResultsDecoratorSQL(this.out, verbosity);
                }
                newDecorator = this.sqlDecorator;
                break;
            }
            case x: {
                if (this.xmlDecorator == null) {
                    this.xmlDecorator = new ResultsDecoratorXML(this.out, verbosity);
                }
                newDecorator = this.xmlDecorator;
                break;
            }
            case j: {
                if (this.jtableDecorator == null) {
                    if (this.gui == null) {
                        throw new IllegalArgumentException("Can't set mode to JTable before calling setGUI()");
                    }
                    this.jtableDecorator = new ResultsDecoratorJTable(this.gui.getJTable(), this.out, verbosity);
                }
                newDecorator = this.jtableDecorator;
                break;
            }
            default: {
                String values = OutputMode.values().toString();
                System.err.println("invalid mode: " + (Object)((Object)outputMode) + "; must be " + values);
            }
        }
        if (this.currentDecorator != newDecorator) {
            this.currentDecorator = newDecorator;
            if (this.debug) {
                System.out.println("Mode set to  " + (Object)((Object)outputMode));
            }
        }
        this.currentDecorator.setWriter(this.out);
    }

    @Deprecated
    public void runScript(String scriptFile) throws IOException, SQLException, SyntaxException {
        BufferedReader is = new BufferedReader(new FileReader(scriptFile));
        this.runScript(is, scriptFile);
    }

    @Deprecated
    public void runScript(BufferedReader is, String name) throws IOException, SQLException, SyntaxException {
        String stmt;
        while ((stmt = SQLRunner.getStatement(is)) != null) {
            stmt = stmt.trim();
            this.runStatement(stmt);
        }
    }

    private void doEscape(String str) throws IOException, SQLException, SyntaxException {
        String rest = null;
        if (str.length() > 2) {
            rest = str.substring(2);
        }
        if (str.startsWith("\\d")) {
            if (rest == null) {
                throw new SyntaxException("\\d needs display arg");
            }
            this.display(rest);
        } else if (str.startsWith("\\m")) {
            if (rest == null) {
                throw new SyntaxException("\\m needs output mode arg");
            }
            this.setOutputMode(rest);
        } else if (str.startsWith("\\o")) {
            if (rest == null) {
                throw new SyntaxException("\\o needs output file arg");
            }
            this.setOutputFile(rest);
        } else if (str.startsWith("\\q")) {
            SQLRunner.exit(0);
        } else {
            throw new SyntaxException("Unknown escape: " + str);
        }
    }

    private void display(String rest) throws IOException, SQLException, SyntaxException {
        if (rest.equals("t")) {
            DatabaseMetaData md = this.conn.getMetaData();
            ResultSet rs = md.getTables(null, null, "%", new String[]{"TABLE", "VIEW"});
            this.setOutputMode(OutputMode.t);
            this.textDecorator.write(rs);
            this.textDecorator.flush();
        } else if (rest.startsWith("t")) {
            String tableName = rest.substring(1).trim();
            if (this.upperCaseTableNames) {
                tableName = tableName.toUpperCase();
            }
            System.out.println("# Display table " + tableName);
            DatabaseMetaData md = this.conn.getMetaData();
            ResultSet rs = md.getColumns(null, null, tableName, "%");
            this.setOutputMode(OutputMode.t);
            this.textDecorator.write(rs);
            this.textDecorator.flush();
        } else {
            throw new SyntaxException("\\d" + rest + " invalid");
        }
    }

    private static CachedRowSet cacheResultSet(ResultSet rs) throws SQLException {
        WebRowSetImpl rows = new WebRowSetImpl();
        rows.populate(rs);
        return rows;
    }

    public void setOutputFile(String fileName) throws IOException {
        if (fileName == null) {
            this.setOutputFile(new PrintWriter(System.out, true));
        } else {
            File file = new File(fileName);
            this.setOutputFile(new PrintWriter((Writer)new FileWriter(file), true));
            System.out.println("Output set to " + file.getCanonicalPath());
        }
    }

    public void setOutputFile(PrintWriter writer) {
        this.out = writer;
        this.currentDecorator.setWriter(this.out);
    }

    public void runStatement(String rawString) throws IOException, SQLException, SyntaxException {
        String inString = rawString.trim();
        if (verbosity != Verbosity.QUIET) {
            this.out.println("Executing : <<" + inString + ">>");
            this.out.flush();
        }
        this.currentDecorator.println(String.format("-- output from command -- \"%s\"%n", inString));
        this.escape = false;
        if (inString.startsWith("\\")) {
            this.escape = true;
            this.doEscape(inString);
            return;
        }
        boolean hasResultSet = this.statement.execute(inString);
        if (!hasResultSet) {
            this.currentDecorator.printRowCount(this.statement.getUpdateCount());
        } else {
            int n = this.currentDecorator.write(SQLRunner.cacheResultSet(this.statement.getResultSet()));
            if (verbosity == Verbosity.VERBOSE || verbosity == Verbosity.DEBUG) {
                this.currentDecorator.printRowCount(n);
            }
            this.currentDecorator.flush();
        }
    }

    public static String getStatement(BufferedReader is) throws IOException {
        String line;
        StringBuilder sb = new StringBuilder();
        while ((line = is.readLine()) != null) {
            if (verbosity == Verbosity.DEBUG) {
                System.out.println("SQLRunner.getStatement(): LINE " + line);
            }
            if (line == null || line.length() == 0 || (line = line.trim()).startsWith("#") || line.startsWith("--")) continue;
            if (line.startsWith("\\") && sb.length() != 0) {
                throw new IllegalArgumentException("Escape command found inside statement");
            }
            sb.append(line);
            int nb = sb.length();
            if (nb > 0 && sb.charAt(nb - 1) == ';') {
                if (nb == 1) {
                    return null;
                }
                sb.setLength(nb - 1);
                return sb.toString();
            }
            sb.append(' ');
        }
        return null;
    }

    public void close() throws SQLException {
        if (this.statement != null) {
            this.statement.close();
        }
        if (this.conn != null) {
            this.conn.close();
        }
        this.out.flush();
        this.out.close();
    }

    public static Verbosity getVerbosity() {
        return verbosity;
    }

    public static void setVerbosity(Verbosity verbosity) {
        SQLRunner.verbosity = verbosity;
    }

    public void setErrorHandler(SQLRunnerErrorHandler eHandler) {
        this.gui.setErrorHandler(eHandler);
    }

    public void setGUI(SQLRunnerGUI gui) {
        this.gui = gui;
    }

    public String toString() {
        return "sqlrunner";
    }

    public boolean isEscape() {
        return this.escape;
    }
}

