/*
 * Decompiled with CFR 0.152.
 */
package com.darwinsys.lang;

import com.darwinsys.lang.GetOpt;
import com.darwinsys.lang.GetOptDesc;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetOptTestNewPattern
extends TestCase {
    private String goodArgChars = "o:h";
    private String[] goodArgs = new String[]{"-h", "-o", "outfile", "infile"};
    private String[] goodLongArgs = new String[]{"-help", "-output-file", "outfile", "infile"};
    private String badArgChars = "f1o";
    private String[] badArgs = new String[]{"-h", "-o", "outfile", "infile"};
    private GetOptDesc[] newWayLongOptions = new GetOptDesc[]{new GetOptDesc('o', "output-file", true), new GetOptDesc('h', "help", false)};

    protected void setUp() throws Exception {
        System.out.println("GetOptTestNewPattern.setUp()");
        System.setProperty("debug.getopt", "sure");
    }

    public void testGood() {
        this.checkShortArgResults(this.goodArgChars, this.goodArgs, false);
    }

    public void testBadCharsGoodArgs() {
        this.checkShortArgResults(this.badArgChars, this.goodArgs, false);
    }

    public void testBadCharsBadArgs() {
        this.checkShortArgResults(this.badArgChars, this.badArgs, true);
    }

    private void checkShortArgResults(String argChars, String[] args, boolean shouldFail) {
        int errs = 0;
        System.out.println("** START NEW WAY ** " + argChars);
        GetOpt go2 = new GetOpt(argChars);
        Map<String, String> m = go2.parseArguments(args);
        if (m.size() == 0) {
            System.out.println("NO ARGS MATCHED");
        }
        for (Map.Entry<String, String> e : m.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            char c = key.charAt(0);
            System.out.print("Found " + c);
            if (c == '?') {
                ++errs;
            }
            if (val == null || val.equals("")) {
                System.out.print("; (no option)");
            } else {
                System.out.print("; Option " + val);
            }
            System.out.println();
        }
        List<String> filenames = go2.getFilenameList();
        int i = 0;
        while (i < filenames.size()) {
            String fileName = filenames.get(i);
            System.out.println("Filename-like arg " + fileName);
            GetOptTestNewPattern.assertFalse((boolean)fileName.startsWith("-"));
            ++i;
        }
        if (shouldFail) {
            if (errs != 0) {
                System.out.println("Expected error(s) found");
            } else {
                System.out.println("** FAILURE ** Expected errors not found");
            }
        } else if (errs == 0) {
            System.out.println("Expected errs==0 found");
        } else {
            System.out.println("** FAILURE ** Expected errors not found");
        }
    }

    public void testNewWayShort() {
        GetOpt getopt = new GetOpt(this.newWayLongOptions);
        Map<String, String> map = getopt.parseArguments(this.goodArgs);
        this.checkLongArgResults(getopt, map);
    }

    public void testNewWayLong() {
        GetOpt getopt = new GetOpt(this.newWayLongOptions);
        Map<String, String> map = getopt.parseArguments(this.goodLongArgs);
        this.checkLongArgResults(getopt, map);
    }

    protected void checkLongArgResults(GetOpt getopt, Map<String, String> parsedArgsMap) {
        GetOptTestNewPattern.assertFalse((parsedArgsMap.size() == 0 ? 1 : 0) != 0);
        int errs = 0;
        for (Map.Entry<String, String> e : parsedArgsMap.entrySet()) {
            String key = e.getKey();
            String val = e.getValue();
            char c = key.charAt(0);
            System.out.println("checkLongArgResults() - c == " + c);
            switch (c) {
                case '?': {
                    ++errs;
                    break;
                }
                case 'o': {
                    GetOptTestNewPattern.assertEquals((String)val, (String)"outfile");
                    break;
                }
                case '1': 
                case 'f': 
                case 'h': {
                    GetOptTestNewPattern.assertEquals((String)val, null);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected c value " + c);
                }
            }
        }
        GetOptTestNewPattern.assertEquals((int)1, (int)getopt.getFilenameList().size());
        GetOptTestNewPattern.assertEquals((String)"infile", (String)getopt.getFilenameList().get(0));
    }

    public void testRewindLeavesFilenamesLeft() {
        GetOpt getopt = new GetOpt("hn:");
        String[] oneArg = new String[]{"-h", "infile"};
        getopt.parseArguments(oneArg);
        GetOptTestNewPattern.assertEquals((String)"testFilenamesLeft", (String)"infile", (String)oneArg[getopt.getOptInd()]);
        String[] twoArgs = new String[]{"-h", "-n", "100", "infile"};
        getopt.rewind();
        Map<String, String> results = getopt.parseArguments(twoArgs);
        GetOptTestNewPattern.assertNotNull(results);
        GetOptTestNewPattern.assertTrue((results.size() > 0 ? 1 : 0) != 0);
        List<String> nonOptionArgs = getopt.getFilenameList();
        GetOptTestNewPattern.assertEquals((String)"testFilenamesLeft", (String)"infile", (String)nonOptionArgs.get(0));
    }
}

