/* Output of mkheader.awk.  DO NOT EDIT.  */

/*****
*
* Copyright (C) 2004, 2005 PreludeIDS Technologies. All Rights Reserved.
* Author: Yoann Vandoorselaere <yoann.v@prelude-ids.com>
*
* This file is part of the Prelude library.
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2, or (at your option)
* any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; see the file COPYING.  If not, write to
* the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*
*****/

#ifndef _LIBPRELUDE_PRELUDE_ERROR_H
#define _LIBPRELUDE_PRELUDE_ERROR_H

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <errno.h>


#include "prelude-thread.h"
#include "prelude-string.h"

#ifdef __cplusplus
 extern "C" {
#endif

#ifndef __attribute__
/* This feature is available in gcc versions 2.5 and later.  */
# if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 5) || __STRICT_ANSI__
#  define __attribute__(Spec) /* empty */
# endif
/* The __-protected variants of `format' and `printf' attributes
   are accepted by gcc versions 2.6.4 (effectively 2.7) and later.  */
# if __GNUC__ < 2 || (__GNUC__ == 2 && __GNUC_MINOR__ < 7)
#  define __format__ format
#  define __printf__ printf
# endif
#endif


/*
 * This is inspired from the GPG error interface.
 *
 * Bit 1 of prelude_error_t remain set (negative value).
 * Bit 2 to 9 are set to the source of the error.
 * Bit 10 specify whether there is a verbose error available.
 * Bit 11 to 16 are unspecified.
 * Bit 16 to 32 are set to the code of the error.
 */


#define PRELUDE_ERROR_SYSTEM_ERROR    (1 << 15)

typedef enum {
    PRELUDE_ERROR_SOURCE_UNKNOWN = 0,
    PRELUDE_ERROR_SOURCE_IO = 1,
    PRELUDE_ERROR_SOURCE_MESSAGE = 2,
    PRELUDE_ERROR_SOURCE_FAILOVER = 3,
    PRELUDE_ERROR_SOURCE_CLIENT = 4,
    PRELUDE_ERROR_SOURCE_CLIENT_PROFILE = 5,
    PRELUDE_ERROR_SOURCE_EXTRACT = 6,
    PRELUDE_ERROR_SOURCE_CONNECTION = 7,
    PRELUDE_ERROR_SOURCE_CONNECTION_POOL = 8,
    PRELUDE_ERROR_SOURCE_CONFIG_ENGINE = 9,
    PRELUDE_ERROR_SOURCE_STRING = 10,
    PRELUDE_ERROR_SOURCE_IDMEF_TREE_WRAP = 11,
    PRELUDE_ERROR_SOURCE_IDMEF_PATH = 12,
    PRELUDE_ERROR_SOURCE_IDMEF_TYPE = 13,
    PRELUDE_ERROR_SOURCE_IDMEF_MESSAGE_READ = 14,
    PRELUDE_ERROR_SOURCE_IDMEF_CRITERIA = 15,
    PRELUDE_ERROR_SOURCE_IDMEF_VALUE_TYPE = 16,
    PRELUDE_ERROR_SOURCE_PRELUDEDB = 255,

	PRELUDE_ERROR_SOURCE_DIM = 256
} prelude_error_source_t;

typedef enum {
    PRELUDE_ERROR_NO_ERROR = 0,
    PRELUDE_ERROR_GENERIC = 1,
    PRELUDE_ERROR_TLS = 2,
    PRELUDE_ERROR_INVAL_LENGTH = 3,
    PRELUDE_ERROR_INVAL_MESSAGE = 4,
    PRELUDE_ERROR_PROTOCOL_VERSION = 5,
    PRELUDE_ERROR_EOF = 6,
    PRELUDE_ERROR_PROFILE = 8,
    PRELUDE_ERROR_TLS_AUTH_REJECTED = 16,
    PRELUDE_ERROR_INVAL_INT8 = 17,
    PRELUDE_ERROR_INVAL_INT16 = 18,
    PRELUDE_ERROR_INVAL_INT32 = 19,
    PRELUDE_ERROR_INVAL_INT64 = 20,
    PRELUDE_ERROR_INVAL_FLOAT = 21,
    PRELUDE_ERROR_INVAL_CHAR = 22,
    PRELUDE_ERROR_INVAL_IDMEF_TIME = 23,
    PRELUDE_ERROR_CONNECTION_STRING = 24,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_UNKNOWN = 25,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_COPY_UNAVAILABLE = 26,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_CLONE_UNAVAILABLE = 27,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_COMPARE_UNAVAILABLE = 28,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_READ_UNAVAILABLE = 29,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_WRITE_UNAVAILABLE = 30,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_COMPARE_MISMATCH = 31,
    PRELUDE_ERROR_IDMEF_VALUE_TYPE_PARSE = 32,
    PRELUDE_ERROR_IDMEF_CLASS_UNKNOWN = 33,
    PRELUDE_ERROR_IDMEF_CLASS_UNKNOWN_CHILD = 34,
    PRELUDE_ERROR_IDMEF_CLASS_UNKNOWN_NAME = 35,
    PRELUDE_ERROR_IDMEF_PATH_LENGTH = 36,
    PRELUDE_ERROR_IDMEF_PATH_DEPTH = 37,
    PRELUDE_ERROR_IDMEF_PATH_PARENT_ROOT = 38,
    PRELUDE_ERROR_IDMEF_PATH_NTH = 39,
    PRELUDE_ERROR_IDMEF_PATH_MISS_INDEX = 40,
    PRELUDE_ERROR_IDMEF_PATH_INTEGRITY = 41,
    PRELUDE_ERROR_IDMEF_PATH_INDEX_RESERVED = 42,
    PRELUDE_ERROR_IDMEF_PATH_INDEX_FORBIDDEN = 43,
    PRELUDE_ERROR_IDMEF_PATH_INDEX_UNDEFINED = 44,
    PRELUDE_ERROR_IDMEF_TREE_INDEX_UNDEFINED = 45,
    PRELUDE_ERROR_IDMEF_UNKNOWN_ENUM_STRING = 46,
    PRELUDE_ERROR_IDMEF_UNKNOWN_TAG = 47,
    PRELUDE_ERROR_DAEMONIZE_LOCK_HELD = 48,
    PRELUDE_ERROR_PLUGIN_LTDL_INIT = 49,
    PRELUDE_ERROR_STRING_NOT_NULL_TERMINATED = 50,
    PRELUDE_ERROR_CANT_RESOLVE = 51,
    PRELUDE_ERROR_UNKNOWN_PERMISSION_TYPE = 52,
    PRELUDE_ERROR_UNKNOWN_PERMISSION_BIT = 53,
    PRELUDE_ERROR_IDMEF_CRITERIA_PARSE = 55,
    PRELUDE_ERROR_IDMEF_CRITERION_UNSUPPORTED_OPERATOR = 56,
    PRELUDE_ERROR_IDMEF_CRITERION_INVALID_REGEX = 57,
    PRELUDE_ERROR_TLS_WARNING_ALERT = 58,
    PRELUDE_ERROR_TLS_FATAL_ALERT = 59,
    PRELUDE_ERROR_IDMEF_CLASS_CHILD_NOT_CLASS = 60,
    PRELUDE_ERROR_UNKNOWN_ERRNO = 16382,
    PRELUDE_ERROR_E2BIG = PRELUDE_ERROR_SYSTEM_ERROR | 0,
    PRELUDE_ERROR_EACCES = PRELUDE_ERROR_SYSTEM_ERROR | 1,
    PRELUDE_ERROR_EADDRINUSE = PRELUDE_ERROR_SYSTEM_ERROR | 2,
    PRELUDE_ERROR_EADDRNOTAVAIL = PRELUDE_ERROR_SYSTEM_ERROR | 3,
    PRELUDE_ERROR_EADV = PRELUDE_ERROR_SYSTEM_ERROR | 4,
    PRELUDE_ERROR_EAFNOSUPPORT = PRELUDE_ERROR_SYSTEM_ERROR | 5,
    PRELUDE_ERROR_EAGAIN = PRELUDE_ERROR_SYSTEM_ERROR | 6,
    PRELUDE_ERROR_EALREADY = PRELUDE_ERROR_SYSTEM_ERROR | 7,
    PRELUDE_ERROR_EAUTH = PRELUDE_ERROR_SYSTEM_ERROR | 8,
    PRELUDE_ERROR_EBACKGROUND = PRELUDE_ERROR_SYSTEM_ERROR | 9,
    PRELUDE_ERROR_EBADE = PRELUDE_ERROR_SYSTEM_ERROR | 10,
    PRELUDE_ERROR_EBADF = PRELUDE_ERROR_SYSTEM_ERROR | 11,
    PRELUDE_ERROR_EBADFD = PRELUDE_ERROR_SYSTEM_ERROR | 12,
    PRELUDE_ERROR_EBADMSG = PRELUDE_ERROR_SYSTEM_ERROR | 13,
    PRELUDE_ERROR_EBADR = PRELUDE_ERROR_SYSTEM_ERROR | 14,
    PRELUDE_ERROR_EBADRPC = PRELUDE_ERROR_SYSTEM_ERROR | 15,
    PRELUDE_ERROR_EBADRQC = PRELUDE_ERROR_SYSTEM_ERROR | 16,
    PRELUDE_ERROR_EBADSLT = PRELUDE_ERROR_SYSTEM_ERROR | 17,
    PRELUDE_ERROR_EBFONT = PRELUDE_ERROR_SYSTEM_ERROR | 18,
    PRELUDE_ERROR_EBUSY = PRELUDE_ERROR_SYSTEM_ERROR | 19,
    PRELUDE_ERROR_ECANCELED = PRELUDE_ERROR_SYSTEM_ERROR | 20,
    PRELUDE_ERROR_ECHILD = PRELUDE_ERROR_SYSTEM_ERROR | 21,
    PRELUDE_ERROR_ECHRNG = PRELUDE_ERROR_SYSTEM_ERROR | 22,
    PRELUDE_ERROR_ECOMM = PRELUDE_ERROR_SYSTEM_ERROR | 23,
    PRELUDE_ERROR_ECONNABORTED = PRELUDE_ERROR_SYSTEM_ERROR | 24,
    PRELUDE_ERROR_ECONNREFUSED = PRELUDE_ERROR_SYSTEM_ERROR | 25,
    PRELUDE_ERROR_ECONNRESET = PRELUDE_ERROR_SYSTEM_ERROR | 26,
    PRELUDE_ERROR_ED = PRELUDE_ERROR_SYSTEM_ERROR | 27,
    PRELUDE_ERROR_EDEADLK = PRELUDE_ERROR_SYSTEM_ERROR | 28,
    PRELUDE_ERROR_EDEADLOCK = PRELUDE_ERROR_SYSTEM_ERROR | 29,
    PRELUDE_ERROR_EDESTADDRREQ = PRELUDE_ERROR_SYSTEM_ERROR | 30,
    PRELUDE_ERROR_EDIED = PRELUDE_ERROR_SYSTEM_ERROR | 31,
    PRELUDE_ERROR_EDOM = PRELUDE_ERROR_SYSTEM_ERROR | 32,
    PRELUDE_ERROR_EDOTDOT = PRELUDE_ERROR_SYSTEM_ERROR | 33,
    PRELUDE_ERROR_EDQUOT = PRELUDE_ERROR_SYSTEM_ERROR | 34,
    PRELUDE_ERROR_EEXIST = PRELUDE_ERROR_SYSTEM_ERROR | 35,
    PRELUDE_ERROR_EFAULT = PRELUDE_ERROR_SYSTEM_ERROR | 36,
    PRELUDE_ERROR_EFBIG = PRELUDE_ERROR_SYSTEM_ERROR | 37,
    PRELUDE_ERROR_EFTYPE = PRELUDE_ERROR_SYSTEM_ERROR | 38,
    PRELUDE_ERROR_EGRATUITOUS = PRELUDE_ERROR_SYSTEM_ERROR | 39,
    PRELUDE_ERROR_EGREGIOUS = PRELUDE_ERROR_SYSTEM_ERROR | 40,
    PRELUDE_ERROR_EHOSTDOWN = PRELUDE_ERROR_SYSTEM_ERROR | 41,
    PRELUDE_ERROR_EHOSTUNREACH = PRELUDE_ERROR_SYSTEM_ERROR | 42,
    PRELUDE_ERROR_EIDRM = PRELUDE_ERROR_SYSTEM_ERROR | 43,
    PRELUDE_ERROR_EIEIO = PRELUDE_ERROR_SYSTEM_ERROR | 44,
    PRELUDE_ERROR_EILSEQ = PRELUDE_ERROR_SYSTEM_ERROR | 45,
    PRELUDE_ERROR_EINPROGRESS = PRELUDE_ERROR_SYSTEM_ERROR | 46,
    PRELUDE_ERROR_EINTR = PRELUDE_ERROR_SYSTEM_ERROR | 47,
    PRELUDE_ERROR_EINVAL = PRELUDE_ERROR_SYSTEM_ERROR | 48,
    PRELUDE_ERROR_EIO = PRELUDE_ERROR_SYSTEM_ERROR | 49,
    PRELUDE_ERROR_EISCONN = PRELUDE_ERROR_SYSTEM_ERROR | 50,
    PRELUDE_ERROR_EISDIR = PRELUDE_ERROR_SYSTEM_ERROR | 51,
    PRELUDE_ERROR_EISNAM = PRELUDE_ERROR_SYSTEM_ERROR | 52,
    PRELUDE_ERROR_EL2HLT = PRELUDE_ERROR_SYSTEM_ERROR | 53,
    PRELUDE_ERROR_EL2NSYNC = PRELUDE_ERROR_SYSTEM_ERROR | 54,
    PRELUDE_ERROR_EL3HLT = PRELUDE_ERROR_SYSTEM_ERROR | 55,
    PRELUDE_ERROR_EL3RST = PRELUDE_ERROR_SYSTEM_ERROR | 56,
    PRELUDE_ERROR_ELIBACC = PRELUDE_ERROR_SYSTEM_ERROR | 57,
    PRELUDE_ERROR_ELIBBAD = PRELUDE_ERROR_SYSTEM_ERROR | 58,
    PRELUDE_ERROR_ELIBEXEC = PRELUDE_ERROR_SYSTEM_ERROR | 59,
    PRELUDE_ERROR_ELIBMAX = PRELUDE_ERROR_SYSTEM_ERROR | 60,
    PRELUDE_ERROR_ELIBSCN = PRELUDE_ERROR_SYSTEM_ERROR | 61,
    PRELUDE_ERROR_ELNRNG = PRELUDE_ERROR_SYSTEM_ERROR | 62,
    PRELUDE_ERROR_ELOOP = PRELUDE_ERROR_SYSTEM_ERROR | 63,
    PRELUDE_ERROR_EMEDIUMTYPE = PRELUDE_ERROR_SYSTEM_ERROR | 64,
    PRELUDE_ERROR_EMFILE = PRELUDE_ERROR_SYSTEM_ERROR | 65,
    PRELUDE_ERROR_EMLINK = PRELUDE_ERROR_SYSTEM_ERROR | 66,
    PRELUDE_ERROR_EMSGSIZE = PRELUDE_ERROR_SYSTEM_ERROR | 67,
    PRELUDE_ERROR_EMULTIHOP = PRELUDE_ERROR_SYSTEM_ERROR | 68,
    PRELUDE_ERROR_ENAMETOOLONG = PRELUDE_ERROR_SYSTEM_ERROR | 69,
    PRELUDE_ERROR_ENAVAIL = PRELUDE_ERROR_SYSTEM_ERROR | 70,
    PRELUDE_ERROR_ENEEDAUTH = PRELUDE_ERROR_SYSTEM_ERROR | 71,
    PRELUDE_ERROR_ENETDOWN = PRELUDE_ERROR_SYSTEM_ERROR | 72,
    PRELUDE_ERROR_ENETRESET = PRELUDE_ERROR_SYSTEM_ERROR | 73,
    PRELUDE_ERROR_ENETUNREACH = PRELUDE_ERROR_SYSTEM_ERROR | 74,
    PRELUDE_ERROR_ENFILE = PRELUDE_ERROR_SYSTEM_ERROR | 75,
    PRELUDE_ERROR_ENOANO = PRELUDE_ERROR_SYSTEM_ERROR | 76,
    PRELUDE_ERROR_ENOBUFS = PRELUDE_ERROR_SYSTEM_ERROR | 77,
    PRELUDE_ERROR_ENOCSI = PRELUDE_ERROR_SYSTEM_ERROR | 78,
    PRELUDE_ERROR_ENODATA = PRELUDE_ERROR_SYSTEM_ERROR | 79,
    PRELUDE_ERROR_ENODEV = PRELUDE_ERROR_SYSTEM_ERROR | 80,
    PRELUDE_ERROR_ENOENT = PRELUDE_ERROR_SYSTEM_ERROR | 81,
    PRELUDE_ERROR_ENOEXEC = PRELUDE_ERROR_SYSTEM_ERROR | 82,
    PRELUDE_ERROR_ENOLCK = PRELUDE_ERROR_SYSTEM_ERROR | 83,
    PRELUDE_ERROR_ENOLINK = PRELUDE_ERROR_SYSTEM_ERROR | 84,
    PRELUDE_ERROR_ENOMEDIUM = PRELUDE_ERROR_SYSTEM_ERROR | 85,
    PRELUDE_ERROR_ENOMEM = PRELUDE_ERROR_SYSTEM_ERROR | 86,
    PRELUDE_ERROR_ENOMSG = PRELUDE_ERROR_SYSTEM_ERROR | 87,
    PRELUDE_ERROR_ENONET = PRELUDE_ERROR_SYSTEM_ERROR | 88,
    PRELUDE_ERROR_ENOPKG = PRELUDE_ERROR_SYSTEM_ERROR | 89,
    PRELUDE_ERROR_ENOPROTOOPT = PRELUDE_ERROR_SYSTEM_ERROR | 90,
    PRELUDE_ERROR_ENOSPC = PRELUDE_ERROR_SYSTEM_ERROR | 91,
    PRELUDE_ERROR_ENOSR = PRELUDE_ERROR_SYSTEM_ERROR | 92,
    PRELUDE_ERROR_ENOSTR = PRELUDE_ERROR_SYSTEM_ERROR | 93,
    PRELUDE_ERROR_ENOSYS = PRELUDE_ERROR_SYSTEM_ERROR | 94,
    PRELUDE_ERROR_ENOTBLK = PRELUDE_ERROR_SYSTEM_ERROR | 95,
    PRELUDE_ERROR_ENOTCONN = PRELUDE_ERROR_SYSTEM_ERROR | 96,
    PRELUDE_ERROR_ENOTDIR = PRELUDE_ERROR_SYSTEM_ERROR | 97,
    PRELUDE_ERROR_ENOTEMPTY = PRELUDE_ERROR_SYSTEM_ERROR | 98,
    PRELUDE_ERROR_ENOTNAM = PRELUDE_ERROR_SYSTEM_ERROR | 99,
    PRELUDE_ERROR_ENOTSOCK = PRELUDE_ERROR_SYSTEM_ERROR | 100,
    PRELUDE_ERROR_ENOTSUP = PRELUDE_ERROR_SYSTEM_ERROR | 101,
    PRELUDE_ERROR_ENOTTY = PRELUDE_ERROR_SYSTEM_ERROR | 102,
    PRELUDE_ERROR_ENOTUNIQ = PRELUDE_ERROR_SYSTEM_ERROR | 103,
    PRELUDE_ERROR_ENXIO = PRELUDE_ERROR_SYSTEM_ERROR | 104,
    PRELUDE_ERROR_EOPNOTSUPP = PRELUDE_ERROR_SYSTEM_ERROR | 105,
    PRELUDE_ERROR_EOVERFLOW = PRELUDE_ERROR_SYSTEM_ERROR | 106,
    PRELUDE_ERROR_EPERM = PRELUDE_ERROR_SYSTEM_ERROR | 107,
    PRELUDE_ERROR_EPFNOSUPPORT = PRELUDE_ERROR_SYSTEM_ERROR | 108,
    PRELUDE_ERROR_EPIPE = PRELUDE_ERROR_SYSTEM_ERROR | 109,
    PRELUDE_ERROR_EPROCLIM = PRELUDE_ERROR_SYSTEM_ERROR | 110,
    PRELUDE_ERROR_EPROCUNAVAIL = PRELUDE_ERROR_SYSTEM_ERROR | 111,
    PRELUDE_ERROR_EPROGMISMATCH = PRELUDE_ERROR_SYSTEM_ERROR | 112,
    PRELUDE_ERROR_EPROGUNAVAIL = PRELUDE_ERROR_SYSTEM_ERROR | 113,
    PRELUDE_ERROR_EPROTO = PRELUDE_ERROR_SYSTEM_ERROR | 114,
    PRELUDE_ERROR_EPROTONOSUPPORT = PRELUDE_ERROR_SYSTEM_ERROR | 115,
    PRELUDE_ERROR_EPROTOTYPE = PRELUDE_ERROR_SYSTEM_ERROR | 116,
    PRELUDE_ERROR_ERANGE = PRELUDE_ERROR_SYSTEM_ERROR | 117,
    PRELUDE_ERROR_EREMCHG = PRELUDE_ERROR_SYSTEM_ERROR | 118,
    PRELUDE_ERROR_EREMOTE = PRELUDE_ERROR_SYSTEM_ERROR | 119,
    PRELUDE_ERROR_EREMOTEIO = PRELUDE_ERROR_SYSTEM_ERROR | 120,
    PRELUDE_ERROR_ERESTART = PRELUDE_ERROR_SYSTEM_ERROR | 121,
    PRELUDE_ERROR_EROFS = PRELUDE_ERROR_SYSTEM_ERROR | 122,
    PRELUDE_ERROR_ERPCMISMATCH = PRELUDE_ERROR_SYSTEM_ERROR | 123,
    PRELUDE_ERROR_ESHUTDOWN = PRELUDE_ERROR_SYSTEM_ERROR | 124,
    PRELUDE_ERROR_ESOCKTNOSUPPORT = PRELUDE_ERROR_SYSTEM_ERROR | 125,
    PRELUDE_ERROR_ESPIPE = PRELUDE_ERROR_SYSTEM_ERROR | 126,
    PRELUDE_ERROR_ESRCH = PRELUDE_ERROR_SYSTEM_ERROR | 127,
    PRELUDE_ERROR_ESRMNT = PRELUDE_ERROR_SYSTEM_ERROR | 128,
    PRELUDE_ERROR_ESTALE = PRELUDE_ERROR_SYSTEM_ERROR | 129,
    PRELUDE_ERROR_ESTRPIPE = PRELUDE_ERROR_SYSTEM_ERROR | 130,
    PRELUDE_ERROR_ETIME = PRELUDE_ERROR_SYSTEM_ERROR | 131,
    PRELUDE_ERROR_ETIMEDOUT = PRELUDE_ERROR_SYSTEM_ERROR | 132,
    PRELUDE_ERROR_ETOOMANYREFS = PRELUDE_ERROR_SYSTEM_ERROR | 133,
    PRELUDE_ERROR_ETXTBSY = PRELUDE_ERROR_SYSTEM_ERROR | 134,
    PRELUDE_ERROR_EUCLEAN = PRELUDE_ERROR_SYSTEM_ERROR | 135,
    PRELUDE_ERROR_EUNATCH = PRELUDE_ERROR_SYSTEM_ERROR | 136,
    PRELUDE_ERROR_EUSERS = PRELUDE_ERROR_SYSTEM_ERROR | 137,
    PRELUDE_ERROR_EWOULDBLOCK = PRELUDE_ERROR_SYSTEM_ERROR | 138,
    PRELUDE_ERROR_EXDEV = PRELUDE_ERROR_SYSTEM_ERROR | 139,
    PRELUDE_ERROR_EXFULL = PRELUDE_ERROR_SYSTEM_ERROR | 140,

	PRELUDE_ERROR_CODE_DIM = 65536
} prelude_error_code_t;


#ifndef PRELUDE_ERROR_SOURCE_DEFAULT
 #define PRELUDE_ERROR_SOURCE_DEFAULT  PRELUDE_ERROR_SOURCE_UNKNOWN
#endif

#define PRELUDE_ERROR_CODE_MASK       (PRELUDE_ERROR_CODE_DIM - 1)
#define PRELUDE_ERROR_SOURCE_MASK     (PRELUDE_ERROR_SOURCE_DIM - 1)
#define PRELUDE_ERROR_SOURCE_SHIFT    23

#define PRELUDE_ERROR_VERBOSE_SHIFT  22
#define PRELUDE_ERROR_VERBOSE_MASK   (1)

typedef signed int prelude_error_t;


prelude_error_code_t prelude_error_code_from_errno(int err);


static inline prelude_error_t prelude_error_make(prelude_error_source_t source, prelude_error_code_t code)
{
	return (code == PRELUDE_ERROR_NO_ERROR) ? PRELUDE_ERROR_GENERIC : -((source << PRELUDE_ERROR_SOURCE_SHIFT) | code);
}


static inline prelude_error_t prelude_error_make_from_errno(prelude_error_source_t source, int err)
{
	prelude_error_code_t code = prelude_error_code_from_errno(err);
	return (code == PRELUDE_ERROR_NO_ERROR) ? PRELUDE_ERROR_GENERIC : -((source << PRELUDE_ERROR_SOURCE_SHIFT) | code);
}


static inline prelude_error_t prelude_error(prelude_error_code_t code)
{
        return prelude_error_make(PRELUDE_ERROR_SOURCE_DEFAULT, code);
}



static prelude_error_t prelude_error_verbose_make_v(prelude_error_source_t source, 
						    prelude_error_code_t code, const char *fmt, va_list ap)
                                                    __attribute__ ((__format__ (__printf__, 3, 0)));

static prelude_error_t prelude_error_verbose_make_v(prelude_error_source_t source, 
						    prelude_error_code_t code, const char *fmt, va_list ap)
{
	int ret;
	prelude_string_t *str;

	ret = prelude_string_new(&str);
	if ( ret < 0 )
		return ret;

	ret = prelude_string_vprintf(str, fmt, ap);
	if ( ret < 0 ) {
		prelude_string_destroy(str);
		return ret;
	}

	ret = _prelude_thread_set_error(prelude_string_get_string(str));
	prelude_string_destroy(str);
	
	if ( ret < 0 )
		return ret;

	return -(-prelude_error_make(source, code) | (1 << PRELUDE_ERROR_VERBOSE_SHIFT));
}

	

static inline prelude_error_t prelude_error_verbose_make(prelude_error_source_t source,
						         prelude_error_code_t code, const char *fmt, ...)
						         __attribute__ ((__format__ (__printf__, 3, 4)));
 
static inline prelude_error_t prelude_error_verbose_make(prelude_error_source_t source,
						         prelude_error_code_t code, const char *fmt, ...)
{
	int ret;
	va_list ap;

	va_start(ap, fmt);
	ret = prelude_error_verbose_make_v(source, code, fmt, ap);
	va_end(ap);

	return ret;
}


static inline prelude_error_t prelude_error_verbose(prelude_error_code_t code, const char *fmt, ...) 
                                                    __attribute__ ((__format__ (__printf__, 2, 3)));
                                                    
static inline prelude_error_t prelude_error_verbose(prelude_error_code_t code, const char *fmt, ...)
{
	int ret;
	va_list ap;

	va_start(ap, fmt);
	ret = prelude_error_verbose_make_v(PRELUDE_ERROR_SOURCE_DEFAULT, code, fmt, ap);
	va_end(ap);

	return ret;
}



static inline prelude_error_code_t prelude_error_get_code(prelude_error_t error)
{
        return (prelude_error_code_t) ((-error) & PRELUDE_ERROR_CODE_MASK);
}


static inline prelude_error_source_t prelude_error_get_source(prelude_error_t error)
{
        return (prelude_error_source_t) (((-error) >> PRELUDE_ERROR_SOURCE_SHIFT) & PRELUDE_ERROR_SOURCE_MASK);
}


static inline prelude_error_t prelude_error_from_errno(int err)
{
        return prelude_error_make(PRELUDE_ERROR_SOURCE_DEFAULT, prelude_error_code_from_errno(err));
}


static inline prelude_bool_t prelude_error_is_verbose(prelude_error_t err)
{
	return (((-err) >> PRELUDE_ERROR_VERBOSE_SHIFT) & PRELUDE_ERROR_VERBOSE_MASK) ? PRELUDE_BOOL_TRUE : PRELUDE_BOOL_FALSE;
}


void prelude_perror(prelude_error_t err, const char *fmt, ...) __attribute__ ((__format__ (__printf__, 2, 3)));

const char *prelude_strerror(prelude_error_t err);

const char *prelude_strsource(prelude_error_t err);

int prelude_error_code_to_errno(prelude_error_code_t code);

#ifdef __cplusplus
 }
#endif


#endif
