/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.logger;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import org.apache.catalina.Container;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Logger;

public abstract class LoggerBase
implements Logger {
    protected Container container = null;
    protected int debug = 0;
    protected static final String info = "org.apache.catalina.logger.LoggerBase/1.0";
    protected PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected int verbosity = 1;

    public Container getContainer() {
        return this.container;
    }

    public void setContainer(Container container) {
        Container oldContainer = this.container;
        this.container = container;
        this.support.firePropertyChange("container", oldContainer, this.container);
    }

    public int getDebug() {
        return this.debug;
    }

    public void setDebug(int debug) {
        this.debug = debug;
    }

    public String getInfo() {
        return info;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public void setVerbosity(int verbosity) {
        this.verbosity = verbosity;
    }

    public void setVerbosityLevel(String verbosity) {
        if ("FATAL".equalsIgnoreCase(verbosity)) {
            this.verbosity = Integer.MIN_VALUE;
        } else if ("ERROR".equalsIgnoreCase(verbosity)) {
            this.verbosity = 1;
        } else if ("WARNING".equalsIgnoreCase(verbosity)) {
            this.verbosity = 2;
        } else if ("INFORMATION".equalsIgnoreCase(verbosity)) {
            this.verbosity = 3;
        } else if ("DEBUG".equalsIgnoreCase(verbosity)) {
            this.verbosity = 4;
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public abstract void log(String var1);

    public void log(Exception exception, String msg) {
        this.log(msg, exception);
    }

    public void log(String msg, Throwable throwable) {
        CharArrayWriter buf = new CharArrayWriter();
        PrintWriter writer = new PrintWriter(buf);
        writer.println(msg);
        throwable.printStackTrace(writer);
        Throwable rootCause = null;
        if (throwable instanceof LifecycleException) {
            rootCause = ((LifecycleException)throwable).getThrowable();
        } else if (throwable instanceof ServletException) {
            rootCause = ((ServletException)throwable).getRootCause();
        }
        if (rootCause != null) {
            writer.println("----- Root Cause -----");
            rootCause.printStackTrace(writer);
        }
        this.log(buf.toString());
    }

    public void log(String message, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message);
        }
    }

    public void log(String message, Throwable throwable, int verbosity) {
        if (this.verbosity >= verbosity) {
            this.log(message, throwable);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }
}

