/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.tomcat4;

import java.io.IOException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.catalina.Logger;
import org.apache.catalina.util.StringManager;
import org.apache.coyote.ActionCode;
import org.apache.coyote.Adapter;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.tomcat4.CoyoteConnector;
import org.apache.coyote.tomcat4.CoyotePrincipal;
import org.apache.coyote.tomcat4.CoyoteRequest;
import org.apache.coyote.tomcat4.CoyoteResponse;
import org.apache.tomcat.util.buf.B2CConverter;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.buf.CharChunk;
import org.apache.tomcat.util.buf.MessageBytes;
import org.apache.tomcat.util.http.Cookies;
import org.apache.tomcat.util.http.ServerCookie;

final class CoyoteAdapter
implements Adapter {
    protected static final boolean ALLOW_BACKSLASH = Boolean.valueOf(System.getProperty("org.apache.coyote.tomcat4.CoyoteAdapter.ALLOW_BACKSLASH", "false"));
    public static final int ADAPTER_NOTES = 1;
    private CoyoteConnector connector = null;
    private int debug = 0;
    private static final String match = ";jsessionid=";
    private static final char[] SESSION_ID = ";jsessionid=".toCharArray();
    protected StringManager sm = StringManager.getManager((String)"org.apache.coyote.tomcat4");

    public CoyoteAdapter(CoyoteConnector connector) {
        this.connector = connector;
        this.debug = connector.getDebug();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) throws Exception {
        CoyoteRequest request = (CoyoteRequest)req.getNote(1);
        CoyoteResponse response = (CoyoteResponse)res.getNote(1);
        if (request == null) {
            request = (CoyoteRequest)this.connector.createRequest();
            request.setCoyoteRequest(req);
            response = (CoyoteResponse)this.connector.createResponse();
            response.setCoyoteResponse(res);
            request.setResponse((org.apache.catalina.Response)response);
            response.setRequest((org.apache.catalina.Request)request);
            req.setNote(1, (Object)request);
            res.setNote(1, (Object)response);
            req.getParameters().setQueryStringEncoding(this.connector.getURIEncoding());
        }
        try {
            this.postParseRequest(req, request, res, response);
            this.connector.getContainer().invoke((org.apache.catalina.Request)request, (org.apache.catalina.Response)response);
            response.finishResponse();
            req.action(ActionCode.ACTION_POST_REQUEST, null);
        }
        catch (IOException e) {
        }
        catch (Throwable t) {
            this.log(this.sm.getString("coyoteAdapter.service"), t);
        }
        finally {
            request.recycle();
            response.recycle();
        }
    }

    protected void postParseRequest(Request req, CoyoteRequest request, Response res, CoyoteResponse response) throws Exception {
        String authtype;
        String principal;
        if (!req.scheme().isNull()) {
            request.setSecure(req.scheme().equals("https"));
        } else {
            req.scheme().setString(this.connector.getScheme());
            request.setSecure(this.connector.getSecure());
        }
        if (!this.connector.getAllowTrace() && req.method().equalsIgnoreCase("TRACE")) {
            res.setStatus(403);
            res.setMessage("TRACE method is not allowed");
            throw new IOException("TRACE method is not allowed");
        }
        request.setAuthorization(req.getHeader("authorization"));
        String proxyName = this.connector.getProxyName();
        int proxyPort = this.connector.getProxyPort();
        if (proxyPort != 0) {
            request.setServerPort(proxyPort);
            req.setServerPort(proxyPort);
        } else {
            request.setServerPort(req.getServerPort());
        }
        if (proxyName != null) {
            request.setServerName(proxyName);
            req.serverName().setString(proxyName);
        } else {
            request.setServerName(req.serverName().toString());
        }
        req.decodedURI().duplicate(req.requestURI());
        try {
            req.getURLDecoder().convert(req.decodedURI(), false);
        }
        catch (IOException ioe) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            throw ioe;
        }
        if (!CoyoteAdapter.normalize(req.decodedURI())) {
            res.setStatus(400);
            res.setMessage("Invalid URI");
            throw new IOException("Invalid URI");
        }
        this.convertURI(req.decodedURI(), request);
        this.parseSessionId(req, request);
        if (this.connector.getUseURIValidationHack()) {
            String uri = CoyoteAdapter.validate(request.getRequestURI());
            if (uri == null) {
                res.setStatus(400);
                res.setMessage("Invalid URI");
                throw new IOException("Invalid URI");
            }
            req.requestURI().setString(uri);
            req.decodedURI().duplicate(req.requestURI());
            req.getURLDecoder().convert(req.decodedURI(), true);
            this.convertURI(req.decodedURI(), request);
        }
        this.parseCookies(req, request);
        if (request.isSecure()) {
            res.action(ActionCode.ACTION_REQ_SSL_ATTRIBUTE, (Object)request.getCoyoteRequest());
            request.getAttribute("javax.servlet.request.X509Certificate");
            request.getAttribute("javax.servlet.request.cipher_suite");
            request.getAttribute("javax.servlet.request.key_size");
        }
        if ((principal = req.getRemoteUser().toString()) != null) {
            request.setUserPrincipal(new CoyotePrincipal(principal));
        }
        if ((authtype = req.getAuthType().toString()) != null) {
            request.setAuthType(authtype);
        }
    }

    protected void parseSessionId(Request req, CoyoteRequest request) {
        req.decodedURI().toChars();
        CharChunk uriCC = req.decodedURI().getCharChunk();
        int semicolon = uriCC.indexOf(match, 0, match.length(), 0);
        if (semicolon > 0) {
            int start = uriCC.getStart();
            int end = uriCC.getEnd();
            int sessionIdStart = start + semicolon + match.length();
            int semicolon2 = uriCC.indexOf(';', sessionIdStart);
            if (semicolon2 >= 0) {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, semicolon2 - semicolon - match.length()));
                req.decodedURI().setString(new String(uriCC.getBuffer(), start, semicolon) + new String(uriCC.getBuffer(), semicolon2, end - semicolon2));
            } else {
                request.setRequestedSessionId(new String(uriCC.getBuffer(), sessionIdStart, end - sessionIdStart));
                req.decodedURI().setString(new String(uriCC.getBuffer(), start, semicolon));
            }
            request.setRequestedSessionURL(true);
            String uri = req.requestURI().toString();
            semicolon = uri.indexOf(match);
            if (semicolon > 0) {
                String rest = uri.substring(semicolon + match.length());
                semicolon2 = rest.indexOf(59);
                rest = semicolon2 >= 0 ? rest.substring(semicolon2) : "";
                req.requestURI().setString(uri.substring(0, semicolon) + rest);
            }
        } else {
            request.setRequestedSessionId(null);
            request.setRequestedSessionURL(false);
        }
    }

    protected void parseCookies(Request req, CoyoteRequest request) {
        Cookies serverCookies = req.getCookies();
        int count = serverCookies.getCookieCount();
        if (count <= 0) {
            return;
        }
        Cookie[] cookies = new Cookie[count];
        int idx = 0;
        for (int i = 0; i < count; ++i) {
            ServerCookie scookie = serverCookies.getCookie(i);
            if (scookie.getName().equals("JSESSIONID") && !request.isRequestedSessionIdFromCookie()) {
                request.setRequestedSessionId(scookie.getValue().toString());
                request.setRequestedSessionCookie(true);
                request.setRequestedSessionURL(false);
                if (this.debug >= 1) {
                    this.log(" Requested cookie session id is " + ((HttpServletRequest)request.getRequest()).getRequestedSessionId());
                }
            }
            try {
                Cookie cookie = new Cookie(scookie.getName().toString(), scookie.getValue().toString());
                cookie.setPath(scookie.getPath().toString());
                cookie.setVersion(scookie.getVersion());
                String domain = scookie.getDomain().toString();
                if (domain != null) {
                    cookie.setDomain(scookie.getDomain().toString());
                }
                cookies[idx++] = cookie;
                continue;
            }
            catch (Exception ex) {
                this.log("Bad Cookie Name: " + scookie.getName() + " /Value: " + scookie.getValue(), ex);
            }
        }
        if (idx < count) {
            Cookie[] ncookies = new Cookie[idx];
            System.arraycopy(cookies, 0, ncookies, 0, idx);
            cookies = ncookies;
        }
        request.setCookies(cookies);
    }

    protected static String validate(String path) {
        int index;
        if (path == null) {
            return null;
        }
        String normalized = path;
        if (normalized.startsWith("/%7E") || normalized.startsWith("/%7e")) {
            normalized = "/~" + normalized.substring(4);
        }
        if (normalized.indexOf("%25") >= 0 || normalized.indexOf("%2F") >= 0 || normalized.indexOf("%2E") >= 0 || normalized.indexOf("%5C") >= 0 || normalized.indexOf("%2f") >= 0 || normalized.indexOf("%2e") >= 0 || normalized.indexOf("%5c") >= 0) {
            return null;
        }
        if (normalized.equals("/.")) {
            return "/";
        }
        if (normalized.indexOf(92) >= 0) {
            if (ALLOW_BACKSLASH) {
                normalized = normalized.replace('\\', '/');
            } else {
                return null;
            }
        }
        if (!normalized.startsWith("/")) {
            normalized = "/" + normalized;
        }
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        if (normalized.indexOf("/...") >= 0) {
            return null;
        }
        return normalized;
    }

    protected void convertURI(MessageBytes uri, CoyoteRequest request) throws Exception {
        ByteChunk bc = uri.getByteChunk();
        CharChunk cc = uri.getCharChunk();
        cc.allocate(bc.getLength(), -1);
        String enc = this.connector.getURIEncoding();
        if (enc != null) {
            B2CConverter conv = request.getURIConverter();
            try {
                if (conv == null) {
                    conv = new B2CConverter(enc);
                    request.setURIConverter(conv);
                } else {
                    conv.recycle();
                }
            }
            catch (IOException e) {
                this.log("Invalid URI encoding; using HTTP default", e);
                this.connector.setURIEncoding(null);
            }
            if (conv != null) {
                try {
                    conv.convert(bc, cc);
                    uri.setChars(cc.getBuffer(), cc.getStart(), cc.getLength());
                    return;
                }
                catch (IOException e) {
                    if (this.debug >= 1) {
                        this.log("Invalid URI character encoding; trying ascii", e);
                    }
                    cc.recycle();
                }
            }
        }
        byte[] bbuf = bc.getBuffer();
        char[] cbuf = cc.getBuffer();
        int start = bc.getStart();
        for (int i = 0; i < bc.getLength(); ++i) {
            cbuf[i] = (char)(bbuf[i + start] & 0xFF);
        }
        uri.setChars(cbuf, 0, bc.getLength());
    }

    public static boolean normalize(MessageBytes uriMB) {
        ByteChunk uriBC = uriMB.getByteChunk();
        byte[] b = uriBC.getBytes();
        int start = uriBC.getStart();
        int end = uriBC.getEnd();
        if (end - start == 1 && b[start] == 42) {
            return true;
        }
        int pos = 0;
        int index = 0;
        for (pos = start; pos < end; ++pos) {
            if (b[pos] == 92) {
                if (ALLOW_BACKSLASH) {
                    b[pos] = 47;
                } else {
                    return false;
                }
            }
            if (b[pos] != 0) continue;
            return false;
        }
        if (b[start] != 47) {
            return false;
        }
        for (pos = start; pos < end - 1; ++pos) {
            if (b[pos] != 47) continue;
            while (pos + 1 < end && b[pos + 1] == 47) {
                CoyoteAdapter.copyBytes(b, pos, pos + 1, end - pos - 1);
                --end;
            }
        }
        if (end - start > 2 && b[end - 1] == 46 && (b[end - 2] == 47 || b[end - 2] == 46 && b[end - 3] == 47)) {
            b[end] = 47;
            ++end;
        }
        uriBC.setEnd(end);
        index = 0;
        while ((index = uriBC.indexOf("/./", 0, 3, index)) >= 0) {
            CoyoteAdapter.copyBytes(b, start + index, start + index + 2, end - start - index - 2);
            uriBC.setEnd(end -= 2);
        }
        index = 0;
        while ((index = uriBC.indexOf("/../", 0, 4, index)) >= 0) {
            if (index == 0) {
                return false;
            }
            int index2 = -1;
            for (pos = start + index - 1; pos >= 0 && index2 < 0; --pos) {
                if (b[pos] != 47) continue;
                index2 = pos;
            }
            CoyoteAdapter.copyBytes(b, start + index2, start + index + 3, end - start - index - 3);
            end = end + index2 - index - 3;
            uriBC.setEnd(end);
            index = index2;
        }
        uriBC.setBytes(b, start, end);
        return true;
    }

    protected static void copyBytes(byte[] b, int dest, int src, int len) {
        for (int pos = 0; pos < len; ++pos) {
            b[pos + dest] = b[pos + src];
        }
    }

    protected void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log("CoyoteAdapter " + message);
        }
    }

    protected void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log("CoyoteAdapter " + message, throwable);
        }
    }
}

