/*
 * Decompiled with CFR 0.152.
 */
package de.tu_darmstadt.sp.paul;

import de.tu_darmstadt.sp.paul.PDFDictionary;
import de.tu_darmstadt.sp.paul.PDFInteger;
import de.tu_darmstadt.sp.paul.PDFName;
import de.tu_darmstadt.sp.paul.PDFObject;
import de.tu_darmstadt.sp.paul.PDFReference;
import de.tu_darmstadt.sp.util.VerbatimOutputStreamWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;

public class PDFWriter {
    DataOutputStream outStream;
    Writer out;
    PDFDictionary trailer;
    Map refmap;
    SortedMap xref;
    Set visited;
    int nextId;
    static final String PDF_HEADER = "%PDF-1.3\n";
    static final String NEWLINE = "\n";
    static final String XREF = "xref\n";
    static final String TRAILER = "trailer\n";
    static final String STARTXREF = "\nstartxref\n";
    static final String PDF_FOOTER = "\n%%EOF\n";
    static final DecimalFormat formpos = new DecimalFormat("0000000000");
    static final DecimalFormat formgen = new DecimalFormat("00000");

    public PDFWriter(OutputStream output, PDFDictionary trailer) {
        this.outStream = new DataOutputStream(output);
        this.out = new VerbatimOutputStreamWriter(this.outStream);
        this.trailer = trailer;
        this.refmap = new HashMap();
        this.xref = new TreeMap();
        this.visited = new HashSet(2309);
        this.nextId = 1;
    }

    public void doWrite() throws IOException {
        this.trailer.getReferenced(this);
        this.visited.clear();
        this.out.write(PDF_HEADER);
        Iterator<Object> iter = new TreeSet(this.refmap.values()).iterator();
        while (iter.hasNext()) {
            PDFReference ref = (PDFReference)iter.next();
            int id = ref.getObjNumber();
            this.out.flush();
            this.xref.put(new Integer(id), new Integer(this.outStream.size()));
            ref.writeContent(this.out);
        }
        iter = null;
        this.out.flush();
        int startxref = this.outStream.size();
        this.out.write(XREF);
        this.out.write("0 ");
        this.out.write(Integer.toString(this.xref.size() + 1));
        this.out.write(NEWLINE);
        this.writeXrefLine(this.out, 0, 65535, false);
        iter = this.xref.keySet().iterator();
        while (iter.hasNext()) {
            Integer filepos = (Integer)this.xref.get(iter.next());
            this.writeXrefLine(this.out, filepos, 0, true);
        }
        iter = null;
        this.trailer.put(PDFName.SIZE, (PDFObject)PDFInteger.forInt(this.xref.size() + 1));
        this.out.write(TRAILER);
        this.trailer.write(this.out);
        this.out.write(STARTXREF);
        this.out.write(Integer.toString(startxref));
        this.out.write(PDF_FOOTER);
        this.out.flush();
        this.trailer.removeReferences(this);
        this.visited.clear();
    }

    PDFReference getPDFRefFor(PDFObject obj) {
        if (obj == null) {
            return null;
        }
        PDFReference res = (PDFReference)this.refmap.get(obj);
        if (res == null) {
            res = new PDFReference(this.nextId, 0, obj);
            ++this.nextId;
            this.refmap.put(obj, res);
        }
        return res;
    }

    boolean isVisited(PDFObject obj) {
        return this.visited.contains(obj);
    }

    void markVisited(PDFObject obj) {
        this.visited.add(obj);
    }

    private void writeXrefLine(Writer out, int filepos, int generation, boolean active) throws IOException {
        out.write(formpos.format(filepos));
        out.write(32);
        out.write(formgen.format(generation));
        out.write(32);
        out.write(active ? 110 : 102);
        out.write(32);
        out.write(10);
    }
}

