"""Exception classes, generated from the Telepathy spec

Copyright (C) 2005, 2006, 2007 Collabora Limited
Copyright (C) 2005, 2006, 2007 Nokia Corporation


This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
  
"""

from dbus import DBusException

__all__ = (
"NetworkError",
"NotImplemented",
"InvalidArgument",
"NotAvailable",
"PermissionDenied",
"Disconnected",
"InvalidHandle",
"ChannelBanned",
"ChannelFull",
"ChannelInviteOnly",
)


class NetworkError(DBusException):
    """\
    Raised when there is an error reading from or writing to the network.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NetworkError'
  
class NotImplemented(DBusException):
    """\
    Raised when the requested method, channel, etc is not available on this connection.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotImplemented'
  
class InvalidArgument(DBusException):
    """\
    Raised when one of the provided arguments is invalid.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.InvalidArgument'
  
class NotAvailable(DBusException):
    """\
    Raised when the requested functionality is temporarily unavailable.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.NotAvailable'
  
class PermissionDenied(DBusException):
    """\
    The user is not permitted to perform the requested operation.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.PermissionDenied'
  
class Disconnected(DBusException):
    """\
    The connection is not currently connected and cannot be used.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Disconnected'
  
class InvalidHandle(DBusException):
    """\
    The contact name specified is unknown on this channel or connection.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.InvalidHandle'
  
class ChannelBanned(DBusException):
    """\
    You are banned from the channel.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.Banned'
  
class ChannelFull(DBusException):
    """\
    The channel is full.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.Full'
  
class ChannelInviteOnly(DBusException):
    """\
    The requested channel is invite-only.
    
    """
    _dbus_error_name = 'org.freedesktop.Telepathy.Error.Channel.InviteOnly'
  