/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.NoSupportException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.PropertySet;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ScriptEntry;
import com.sun.star.script.framework.container.ScriptMetaData;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptProvider;
import com.sun.star.script.provider.XScriptContext;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.HashMap;

public class ScriptBrowseNode
extends PropertySet
implements XBrowseNode,
XInvocation {
    private ScriptProvider provider;
    private Parcel parent;
    private String name;
    public String uri;
    public String description;
    public boolean editable = false;
    public boolean deletable = false;
    public boolean renamable = false;

    public ScriptBrowseNode(ScriptProvider scriptProvider, Parcel parcel, String string) {
        this.provider = scriptProvider;
        this.name = string;
        this.parent = parcel;
        ScriptMetaData scriptMetaData = null;
        XSimpleFileAccess xSimpleFileAccess = null;
        XComponentContext xComponentContext = scriptProvider.getScriptingContext().getComponentContext();
        XMultiComponentFactory xMultiComponentFactory = xComponentContext.getServiceManager();
        try {
            scriptMetaData = (ScriptMetaData)parcel.getByName(string);
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface((Class)XSimpleFileAccess.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xComponentContext));
        }
        catch (Exception exception) {
            LogUtils.DEBUG("** caught exception getting script data for " + string + " ->" + exception.toString());
        }
        this.uri = scriptMetaData.getShortFormScriptURL();
        this.description = scriptMetaData.getDescription();
        if (scriptProvider.hasScriptEditor()) {
            this.editable = true;
            try {
                if (!parcel.isUnoPkg() && !xSimpleFileAccess.isReadOnly(parcel.getPathToParcel())) {
                    this.deletable = true;
                    this.renamable = true;
                }
            }
            catch (Exception exception) {
                LogUtils.DEBUG("Caught exception in creation of ScriptBrowseNode");
                LogUtils.DEBUG(LogUtils.getTrace(exception));
            }
        }
        this.registerProperty("Deletable", new Type(Boolean.TYPE), (short)0, "deletable");
        this.registerProperty("Editable", new Type(Boolean.TYPE), (short)0, "editable");
        this.registerProperty("Renamable", new Type(Boolean.TYPE), (short)0, "renamable");
        this.registerProperty("URI", new Type(String.class), (short)0, "uri");
        this.registerProperty("Description", new Type(String.class), (short)0, "description");
    }

    public String getName() {
        return this.name;
    }

    public XBrowseNode[] getChildNodes() {
        return new XBrowseNode[0];
    }

    public boolean hasChildNodes() {
        return false;
    }

    public short getType() {
        return 0;
    }

    public String toString() {
        return this.getName();
    }

    public void updateURI(Parcel parcel) {
        this.parent = parcel;
        ScriptMetaData scriptMetaData = null;
        try {
            scriptMetaData = (ScriptMetaData)this.parent.getByName(this.name);
        }
        catch (Exception exception) {
            LogUtils.DEBUG("** caught exception getting script data for " + this.name + " ->" + exception.toString());
        }
        this.uri = scriptMetaData.getShortFormScriptURL();
    }

    public XIntrospectionAccess getIntrospection() {
        return null;
    }

    public Object invoke(String string, Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        sArray[0] = new short[0];
        objectArray2[0] = new Object[0];
        Any any = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
        if (string.equals("Editable")) {
            if (!this.editable) {
                NoSupportException noSupportException = new NoSupportException(string + " is not editable ");
                throw new InvocationTargetException("Scripting framework error editing script", null, (Object)noSupportException);
            }
            XScriptContext xScriptContext = this.provider.getScriptingContext();
            ScriptMetaData scriptMetaData = null;
            try {
                scriptMetaData = (ScriptMetaData)this.parent.getByName(this.name);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(this.name + " does not exist or can't be found ");
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new InvocationTargetException("Scripting framework editing script ", null, wrappedTargetException.TargetException);
            }
            this.provider.getScriptEditor().edit(xScriptContext, scriptMetaData);
        } else if (string.equals("Deletable")) {
            if (!this.deletable) {
                NoSupportException noSupportException = new NoSupportException(string + " is not supported for this node");
                throw new InvocationTargetException("Scripting framework error deleting script", null, (Object)noSupportException);
            }
            try {
                this.parent.removeByName(this.name);
                any = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(this.name + " does not exist or can't be found ");
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new InvocationTargetException("Scripting framework deleting script ", null, wrappedTargetException.TargetException);
            }
        } else if (string.equals("Renamable")) {
            any = new Any(new Type(XBrowseNode.class), (Object)new XBrowseNode[0]);
            if (!this.renamable) {
                NoSupportException noSupportException = new NoSupportException(string + " is not supported for this node");
                throw new InvocationTargetException("Scripting framework error renaming script", null, (Object)noSupportException);
            }
            try {
                String string2 = AnyConverter.toString((Object)objectArray[0]);
                ScriptMetaData scriptMetaData = (ScriptMetaData)this.parent.getByName(this.name);
                scriptMetaData.loadSource();
                String string3 = scriptMetaData.getSource();
                LogUtils.DEBUG("Create renamed script");
                String string4 = string2 + "." + this.provider.getScriptEditor().getExtension();
                String string5 = this.provider.getName();
                ScriptEntry scriptEntry = new ScriptEntry(string5, string4, string4, "", new HashMap());
                ScriptMetaData scriptMetaData2 = new ScriptMetaData(this.parent, scriptEntry, string3);
                this.parent.insertByName(string4, scriptMetaData2);
                LogUtils.DEBUG("Now remove old script");
                this.parent.removeByName(this.name);
                this.uri = scriptMetaData2.getShortFormScriptURL();
                this.name = string4;
                any = new Any(new Type(XBrowseNode.class), (Object)this);
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException(this.name + " does not exist or can't be found ");
            }
            catch (ElementExistException elementExistException) {
                throw new InvocationTargetException("Scripting framework error renaming script ", null, (Object)elementExistException);
            }
            catch (WrappedTargetException wrappedTargetException) {
                throw new InvocationTargetException("Scripting framework rename script ", null, wrappedTargetException.TargetException);
            }
        } else {
            throw new IllegalArgumentException("Function " + string + " not supported.");
        }
        return any;
    }

    public void setValue(String string, Object object) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
    }

    public Object getValue(String string) throws UnknownPropertyException {
        return null;
    }

    public boolean hasMethod(String string) {
        return false;
    }

    public boolean hasProperty(String string) {
        return false;
    }
}

