/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.script.framework.browse;

import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XIntrospectionAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lib.uno.helper.PropertySet;
import com.sun.star.reflection.InvocationTargetException;
import com.sun.star.script.CannotConvertException;
import com.sun.star.script.XInvocation;
import com.sun.star.script.browse.XBrowseNode;
import com.sun.star.script.framework.browse.DialogFactory;
import com.sun.star.script.framework.browse.ParcelBrowseNode;
import com.sun.star.script.framework.browse.PkgProviderBrowseNode;
import com.sun.star.script.framework.container.Parcel;
import com.sun.star.script.framework.container.ParcelContainer;
import com.sun.star.script.framework.log.LogUtils;
import com.sun.star.script.framework.provider.ScriptProvider;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JOptionPane;

public class ProviderBrowseNode
extends PropertySet
implements XBrowseNode,
XInvocation {
    protected ScriptProvider provider;
    protected Collection browsenodes;
    protected String name;
    protected ParcelContainer container;
    protected Parcel parcel;
    protected XComponentContext m_xCtx;
    public boolean deletable = true;
    public boolean creatable = true;
    public boolean editable = false;

    public ProviderBrowseNode(ScriptProvider scriptProvider, ParcelContainer parcelContainer, XComponentContext xComponentContext) {
        LogUtils.DEBUG("*** ProviderBrowseNode ctor");
        this.container = parcelContainer;
        this.name = this.container.getLanguage();
        this.provider = scriptProvider;
        this.m_xCtx = xComponentContext;
        this.registerProperty("Deletable", new Type(Boolean.TYPE), (short)0, "deletable");
        this.registerProperty("Creatable", new Type(Boolean.TYPE), (short)0, "creatable");
        this.registerProperty("Editable", new Type(Boolean.TYPE), (short)0, "editable");
        XSimpleFileAccess xSimpleFileAccess = null;
        XMultiComponentFactory xMultiComponentFactory = this.m_xCtx.getServiceManager();
        try {
            xSimpleFileAccess = (XSimpleFileAccess)UnoRuntime.queryInterface((Class)XSimpleFileAccess.class, (Object)xMultiComponentFactory.createInstanceWithContext("com.sun.star.ucb.SimpleFileAccess", xComponentContext));
            if (parcelContainer.isUnoPkg() || xSimpleFileAccess.isReadOnly(parcelContainer.getParcelContainerDir())) {
                this.deletable = false;
                this.creatable = false;
            }
        }
        catch (com.sun.star.uno.Exception exception) {
            LogUtils.DEBUG("Caught exception in creation of ProviderBrowseNode ");
            LogUtils.DEBUG(LogUtils.getTrace((Exception)((Object)exception)));
        }
    }

    public String getName() {
        return this.name;
    }

    public XBrowseNode[] getChildNodes() {
        LogUtils.DEBUG("***** ProviderBrowseNode.getChildNodes()");
        if (this.hasChildNodes()) {
            LogUtils.DEBUG("** ProviderBrowseNode.getChildNodes(), container is " + this.container);
            String[] stringArray = this.container.getElementNames();
            this.browsenodes = new ArrayList(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    ParcelBrowseNode parcelBrowseNode = new ParcelBrowseNode(this.provider, this.container, stringArray[i]);
                    this.browsenodes.add(parcelBrowseNode);
                    continue;
                }
                catch (Exception exception) {
                    LogUtils.DEBUG("*** Failed to create parcel node for " + stringArray[i]);
                    LogUtils.DEBUG(exception.toString());
                }
            }
            ParcelContainer[] parcelContainerArray = this.container.getChildContainers();
            LogUtils.DEBUG("**** For container named " + this.container.getName() + " with root path " + this.container.getParcelContainerDir() + " has " + parcelContainerArray.length + " child containers ");
            for (int i = 0; i < parcelContainerArray.length; ++i) {
                PkgProviderBrowseNode pkgProviderBrowseNode = new PkgProviderBrowseNode(this.provider, parcelContainerArray[i], this.m_xCtx);
                this.browsenodes.add(pkgProviderBrowseNode);
            }
        } else {
            LogUtils.DEBUG("*** No container available");
            return new XBrowseNode[0];
        }
        return this.browsenodes.toArray(new XBrowseNode[0]);
    }

    public boolean hasChildNodes() {
        boolean bl = true;
        if (this.container == null || !this.container.hasElements() && this.container.getChildContainers().length == 0) {
            bl = false;
        }
        LogUtils.DEBUG("***** ProviderBrowseNode.hasChildNodes(): name=" + this.name + ", path=" + this.container.getParcelContainerDir() + ", result=" + bl);
        return bl;
    }

    public short getType() {
        return 1;
    }

    public String toString() {
        return this.getName();
    }

    public XIntrospectionAccess getIntrospection() {
        return null;
    }

    public Object invoke(String string, Object[] objectArray, short[][] sArray, Object[][] objectArray2) throws IllegalArgumentException, CannotConvertException, InvocationTargetException {
        Any any;
        block11: {
            sArray[0] = new short[0];
            objectArray2[0] = new Object[0];
            any = new Any(new Type(Boolean.class), (Object)Boolean.TRUE);
            if (string.equals("Creatable")) {
                try {
                    String string2;
                    Object object;
                    String string3;
                    if (objectArray == null || objectArray.length < 1 || !AnyConverter.isString((Object)objectArray[0])) {
                        string3 = "Enter name for new Parcel";
                        object = "Create Parcel";
                        try {
                            DialogFactory dialogFactory = DialogFactory.getDialogFactory();
                            string2 = dialogFactory.showInputDialog((String)object, string3);
                        }
                        catch (Exception exception) {
                            string2 = JOptionPane.showInputDialog(null, string3, object, 3);
                        }
                    } else {
                        string2 = AnyConverter.toString((Object)objectArray[0]);
                    }
                    if (string2 == null || string2.equals("")) {
                        any = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                        break block11;
                    }
                    string3 = this.container.createParcel(string2);
                    LogUtils.DEBUG("Parcel created " + string2 + " " + string3);
                    if (string3 == null) {
                        any = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                        break block11;
                    }
                    object = new ParcelBrowseNode(this.provider, this.container, string2);
                    LogUtils.DEBUG("created parcel node ");
                    if (this.browsenodes == null) {
                        this.browsenodes = new ArrayList(5);
                    }
                    this.browsenodes.add(object);
                    any = new Any(new Type(XBrowseNode.class), object);
                }
                catch (Exception exception) {
                    LogUtils.DEBUG("ProviderBrowseNode[create] failed with: " + exception);
                    LogUtils.DEBUG(LogUtils.getTrace(exception));
                    any = new Any(new Type(Boolean.class), (Object)Boolean.FALSE);
                }
            } else {
                throw new IllegalArgumentException("Function " + string + " not supported.");
            }
        }
        return any;
    }

    public void setValue(String string, Object object) throws UnknownPropertyException, CannotConvertException, InvocationTargetException {
    }

    public Object getValue(String string) throws UnknownPropertyException {
        return null;
    }

    public boolean hasMethod(String string) {
        return false;
    }

    public boolean hasProperty(String string) {
        return false;
    }
}

