/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.util.Hashtable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.IRFactory;
import org.mozilla.javascript.Node;
import org.mozilla.javascript.NodeTransformer;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.TokenStream;
import org.mozilla.javascript.VariableTable;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptLocalVariable;

class OptTransformer
extends NodeTransformer {
    private Hashtable theFnClassNameList;

    OptTransformer(Hashtable hashtable) {
        this.theFnClassNameList = hashtable;
    }

    public NodeTransformer newInstance() {
        return new OptTransformer((Hashtable)this.theFnClassNameList.clone());
    }

    public IRFactory createIRFactory(TokenStream tokenStream, Scriptable scriptable) {
        return new IRFactory(tokenStream, scriptable);
    }

    public Node transform(Node node, Node node2, TokenStream tokenStream, Scriptable scriptable) {
        this.collectContainedFunctions(node.getFirstChild());
        return super.transform(node, node2, tokenStream, scriptable);
    }

    private int detectDirectCall(Node node, Node node2) {
        Context context = Context.getCurrentContext();
        int n = context.getOptimizationLevel();
        Node node3 = node.getFirstChild();
        int n2 = 0;
        Node node4 = node3.getNext();
        while (node4 != null) {
            node4 = node4.getNext();
            ++n2;
        }
        if (node2.getType() == 110 && n > 0) {
            if (node3.getType() == 44) {
                this.markDirectCall(node2, node, n2, node3.getString());
            } else if (node3.getType() == 39) {
                Node node5 = node3.getFirstChild().getNext();
                this.markDirectCall(node2, node, n2, node5.getString());
            }
        }
        return n2;
    }

    protected Object createVariableObject(String string, boolean bl) {
        return new OptLocalVariable(string, bl);
    }

    protected void visitNew(Node node, Node node2) {
        this.detectDirectCall(node, node2);
        super.visitNew(node, node2);
    }

    protected void visitCall(Node node, Node node2) {
        int n = this.detectDirectCall(node, node2);
        if (this.inFunction && n == 0) {
            ((OptFunctionNode)node2).setContainsCalls(n);
        }
        super.visitCall(node, node2);
    }

    void markDirectCall(Node node, Node node2, int n, String string) {
        OptFunctionNode optFunctionNode = (OptFunctionNode)this.theFnClassNameList.get(string);
        if (optFunctionNode != null) {
            VariableTable variableTable = optFunctionNode.getVariableTable();
            if (variableTable.getParameterCount() > 32) {
                return;
            }
            if (n == variableTable.getParameterCount()) {
                node2.putProp(27, optFunctionNode);
                ((OptFunctionNode)node).addDirectCallTarget(optFunctionNode);
                optFunctionNode.setIsTargetOfDirectCall();
            }
        }
    }

    void collectContainedFunctions(Node node) {
        for (Node node2 = node; node2 != null; node2 = node2.getNext()) {
            if (node2.getType() != 110) continue;
            FunctionNode functionNode = (FunctionNode)node2.getProp(5);
            if (functionNode.getFunctionName().length() != 0) {
                String string = functionNode.getFunctionName();
                Object v = this.theFnClassNameList.get(string);
                if (v == functionNode) {
                    return;
                }
                this.theFnClassNameList.put(string, functionNode);
            }
            this.addParameters(functionNode);
        }
    }
}

