/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

class DataFlowBitSet {
    private int[] itsBits;
    int itsSize;

    DataFlowBitSet(int n) {
        this.itsSize = n;
        this.itsBits = new int[(n >> 5) + 1];
    }

    int size() {
        return this.itsSize;
    }

    void set(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] | 1 << (n & 0x1F);
    }

    boolean test(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        return (this.itsBits[n >> 5] & 1 << (n & 0x1F)) != 0;
    }

    void not() {
        int n = this.itsBits.length;
        for (int i = 0; i < n; ++i) {
            this.itsBits[i] = ~this.itsBits[i];
        }
    }

    void clear(int n) {
        if (n < 0 || n >= this.itsSize) {
            throw new RuntimeException("DataFlowBitSet bad index " + n);
        }
        int n2 = n >> 5;
        this.itsBits[n2] = this.itsBits[n2] & ~(1 << (n & 0x1F));
    }

    void clear() {
        int n = this.itsBits.length;
        for (int i = 0; i < n; ++i) {
            this.itsBits[i] = 0;
        }
    }

    void or(DataFlowBitSet dataFlowBitSet) {
        int n = this.itsBits.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            this.itsBits[n2] = this.itsBits[n2] | dataFlowBitSet.itsBits[i];
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataFlowBitSet, size = " + this.itsSize + "\n");
        for (int i = 0; i < this.itsBits.length; ++i) {
            stringBuffer.append(Integer.toHexString(this.itsBits[i]) + " ");
        }
        return stringBuffer.toString();
    }

    boolean df(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = this.itsBits[i];
            this.itsBits[i] = (dataFlowBitSet.itsBits[i] | dataFlowBitSet2.itsBits[i]) & dataFlowBitSet3.itsBits[i];
            bl |= n2 != this.itsBits[i];
        }
        return bl;
    }

    boolean df2(DataFlowBitSet dataFlowBitSet, DataFlowBitSet dataFlowBitSet2, DataFlowBitSet dataFlowBitSet3) {
        int n = this.itsBits.length;
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            int n2 = this.itsBits[i];
            this.itsBits[i] = dataFlowBitSet.itsBits[i] & dataFlowBitSet3.itsBits[i] | dataFlowBitSet2.itsBits[i];
            bl |= n2 != this.itsBits[i];
        }
        return bl;
    }
}

