/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunction;
import org.mozilla.javascript.IdScriptable;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

final class NativeMath
extends IdScriptable {
    private static final int Id_abs = 1;
    private static final int Id_acos = 2;
    private static final int Id_asin = 3;
    private static final int Id_atan = 4;
    private static final int Id_atan2 = 5;
    private static final int Id_ceil = 6;
    private static final int Id_cos = 7;
    private static final int Id_exp = 8;
    private static final int Id_floor = 9;
    private static final int Id_log = 10;
    private static final int Id_max = 11;
    private static final int Id_min = 12;
    private static final int Id_pow = 13;
    private static final int Id_random = 14;
    private static final int Id_round = 15;
    private static final int Id_sin = 16;
    private static final int Id_sqrt = 17;
    private static final int Id_tan = 18;
    private static final int LAST_METHOD_ID = 18;
    private static final int Id_E = 19;
    private static final int Id_PI = 20;
    private static final int Id_LN10 = 21;
    private static final int Id_LN2 = 22;
    private static final int Id_LOG2E = 23;
    private static final int Id_LOG10E = 24;
    private static final int Id_SQRT1_2 = 25;
    private static final int Id_SQRT2 = 26;
    private static final int MAX_INSTANCE_ID = 26;
    private static final double E = Math.E;
    private static final double PI = Math.PI;
    private static final double LN10 = 2.302585092994046;
    private static final double LN2 = 0.6931471805599453;
    private static final double LOG2E = 1.4426950408889634;
    private static final double LOG10E = 0.4342944819032518;
    private static final double SQRT1_2 = 0.7071067811865476;
    private static final double SQRT2 = 1.4142135623730951;

    NativeMath() {
        this.setMaxId(26);
    }

    static void init(Context context, Scriptable scriptable, boolean bl) {
        NativeMath nativeMath = new NativeMath();
        nativeMath.setSealFunctionsFlag(bl);
        nativeMath.setFunctionParametrs(context);
        nativeMath.setPrototype(NativeMath.getObjectPrototype(scriptable));
        nativeMath.setParentScope(scriptable);
        if (bl) {
            nativeMath.sealObject();
        }
        ScriptableObject.defineProperty(scriptable, "Math", nativeMath, 2);
    }

    public String getClassName() {
        return "Math";
    }

    protected int getIdDefaultAttributes(int n) {
        if (n > 18) {
            return 7;
        }
        return super.getIdDefaultAttributes(n);
    }

    protected Object getIdValue(int n) {
        if (n > 18) {
            return this.cacheIdValue(n, this.wrap_double(this.getField(n)));
        }
        return super.getIdValue(n);
    }

    private double getField(int n) {
        switch (n) {
            case 19: {
                return Math.E;
            }
            case 20: {
                return Math.PI;
            }
            case 21: {
                return 2.302585092994046;
            }
            case 22: {
                return 0.6931471805599453;
            }
            case 23: {
                return 1.4426950408889634;
            }
            case 24: {
                return 0.4342944819032518;
            }
            case 25: {
                return 0.7071067811865476;
            }
            case 26: {
                return 1.4142135623730951;
            }
        }
        return 0.0;
    }

    public int methodArity(int n) {
        switch (n) {
            case 1: {
                return 1;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 1;
            }
            case 7: {
                return 1;
            }
            case 8: {
                return 1;
            }
            case 9: {
                return 1;
            }
            case 10: {
                return 1;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
            case 13: {
                return 2;
            }
            case 14: {
                return 0;
            }
            case 15: {
                return 1;
            }
            case 16: {
                return 1;
            }
            case 17: {
                return 1;
            }
            case 18: {
                return 1;
            }
        }
        return super.methodArity(n);
    }

    public Object execMethod(int n, IdFunction idFunction, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) throws JavaScriptException {
        switch (n) {
            case 1: {
                return this.wrap_double(this.js_abs(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 2: {
                return this.wrap_double(this.js_acos(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 3: {
                return this.wrap_double(this.js_asin(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 4: {
                return this.wrap_double(this.js_atan(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 5: {
                return this.wrap_double(this.js_atan2(ScriptRuntime.toNumber(objectArray, 0), ScriptRuntime.toNumber(objectArray, 1)));
            }
            case 6: {
                return this.wrap_double(this.js_ceil(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 7: {
                return this.wrap_double(this.js_cos(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 8: {
                return this.wrap_double(this.js_exp(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 9: {
                return this.wrap_double(this.js_floor(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 10: {
                return this.wrap_double(this.js_log(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 11: {
                return this.wrap_double(this.js_max(objectArray));
            }
            case 12: {
                return this.wrap_double(this.js_min(objectArray));
            }
            case 13: {
                return this.wrap_double(this.js_pow(ScriptRuntime.toNumber(objectArray, 0), ScriptRuntime.toNumber(objectArray, 1)));
            }
            case 14: {
                return this.wrap_double(this.js_random());
            }
            case 15: {
                return this.wrap_double(this.js_round(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 16: {
                return this.wrap_double(this.js_sin(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 17: {
                return this.wrap_double(this.js_sqrt(ScriptRuntime.toNumber(objectArray, 0)));
            }
            case 18: {
                return this.wrap_double(this.js_tan(ScriptRuntime.toNumber(objectArray, 0)));
            }
        }
        return super.execMethod(n, idFunction, context, scriptable, scriptable2, objectArray);
    }

    private double js_abs(double d) {
        return d == 0.0 ? 0.0 : (d < 0.0 ? -d : d);
    }

    private double js_acos(double d) {
        return d == d && -1.0 <= d && d <= 1.0 ? Math.acos(d) : Double.NaN;
    }

    private double js_asin(double d) {
        return d == d && -1.0 <= d && d <= 1.0 ? Math.asin(d) : Double.NaN;
    }

    private double js_atan(double d) {
        return Math.atan(d);
    }

    private double js_atan2(double d, double d2) {
        return Math.atan2(d, d2);
    }

    private double js_ceil(double d) {
        return Math.ceil(d);
    }

    private double js_cos(double d) {
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        return Math.cos(d);
    }

    private double js_exp(double d) {
        return d == Double.POSITIVE_INFINITY ? d : (d == Double.NEGATIVE_INFINITY ? 0.0 : Math.exp(d));
    }

    private double js_floor(double d) {
        return Math.floor(d);
    }

    private double js_log(double d) {
        return d < 0.0 ? Double.NaN : Math.log(d);
    }

    private double js_max(Object[] objectArray) {
        double d = Double.NEGATIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            double d2 = ScriptRuntime.toNumber(objectArray[i]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.max(d, d2);
        }
        return d;
    }

    private double js_min(Object[] objectArray) {
        double d = Double.POSITIVE_INFINITY;
        if (objectArray.length == 0) {
            return d;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            double d2 = ScriptRuntime.toNumber(objectArray[i]);
            if (d2 != d2) {
                return d2;
            }
            d = Math.min(d, d2);
        }
        return d;
    }

    private double js_pow(double d, double d2) {
        double d3;
        if (d2 != d2) {
            d3 = d2;
        } else if (d2 == 0.0) {
            d3 = 1.0;
        } else if (d == 0.0) {
            long l;
            d3 = 1.0 / d > 0.0 ? (d2 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY) : ((double)(l = (long)d2) == d2 && (l & 1L) != 0L ? (d2 > 0.0 ? -0.0 : Double.NEGATIVE_INFINITY) : (d2 > 0.0 ? 0.0 : Double.POSITIVE_INFINITY));
        } else {
            d3 = Math.pow(d, d2);
            if (d3 != d3) {
                if (d2 == Double.POSITIVE_INFINITY) {
                    if (d < -1.0 || 1.0 < d) {
                        d3 = Double.POSITIVE_INFINITY;
                    } else if (-1.0 < d && d < 1.0) {
                        d3 = 0.0;
                    }
                } else if (d2 == Double.NEGATIVE_INFINITY) {
                    if (d < -1.0 || 1.0 < d) {
                        d3 = 0.0;
                    } else if (-1.0 < d && d < 1.0) {
                        d3 = Double.POSITIVE_INFINITY;
                    }
                } else if (d == Double.POSITIVE_INFINITY) {
                    d3 = d2 > 0.0 ? Double.POSITIVE_INFINITY : 0.0;
                } else if (d == Double.NEGATIVE_INFINITY) {
                    long l = (long)d2;
                    d3 = (double)l == d2 && (l & 1L) != 0L ? (d2 > 0.0 ? Double.NEGATIVE_INFINITY : -0.0) : (d2 > 0.0 ? Double.POSITIVE_INFINITY : 0.0);
                }
            }
        }
        return d3;
    }

    private double js_random() {
        return Math.random();
    }

    private double js_round(double d) {
        if (d != d) {
            return d;
        }
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return d;
        }
        long l = Math.round(d);
        if (l == 0L) {
            if (d < 0.0) {
                return ScriptRuntime.negativeZero;
            }
            return d == 0.0 ? d : 0.0;
        }
        return l;
    }

    private double js_sin(double d) {
        if (d == Double.POSITIVE_INFINITY || d == Double.NEGATIVE_INFINITY) {
            return Double.NaN;
        }
        return Math.sin(d);
    }

    private double js_sqrt(double d) {
        return Math.sqrt(d);
    }

    private double js_tan(double d) {
        return Math.tan(d);
    }

    protected String getIdName(int n) {
        switch (n) {
            case 1: {
                return "abs";
            }
            case 2: {
                return "acos";
            }
            case 3: {
                return "asin";
            }
            case 4: {
                return "atan";
            }
            case 5: {
                return "atan2";
            }
            case 6: {
                return "ceil";
            }
            case 7: {
                return "cos";
            }
            case 8: {
                return "exp";
            }
            case 9: {
                return "floor";
            }
            case 10: {
                return "log";
            }
            case 11: {
                return "max";
            }
            case 12: {
                return "min";
            }
            case 13: {
                return "pow";
            }
            case 14: {
                return "random";
            }
            case 15: {
                return "round";
            }
            case 16: {
                return "sin";
            }
            case 17: {
                return "sqrt";
            }
            case 18: {
                return "tan";
            }
            case 19: {
                return "E";
            }
            case 20: {
                return "PI";
            }
            case 21: {
                return "LN10";
            }
            case 22: {
                return "LN2";
            }
            case 23: {
                return "LOG2E";
            }
            case 24: {
                return "LOG10E";
            }
            case 25: {
                return "SQRT1_2";
            }
            case 26: {
                return "SQRT2";
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int mapNameToId(String string) {
        int n = 0;
        String string2 = null;
        block0 : switch (string.length()) {
            case 1: {
                if (string.charAt(0) != 'E') break;
                return 19;
            }
            case 2: {
                if (string.charAt(0) != 'P' || string.charAt(1) != 'I') break;
                return 20;
            }
            case 3: {
                switch (string.charAt(0)) {
                    case 'L': {
                        if (string.charAt(2) != '2' || string.charAt(1) != 'N') break;
                        return 22;
                    }
                    case 'a': {
                        if (string.charAt(2) != 's' || string.charAt(1) != 'b') break;
                        return 1;
                    }
                    case 'c': {
                        if (string.charAt(2) != 's' || string.charAt(1) != 'o') break;
                        return 7;
                    }
                    case 'e': {
                        if (string.charAt(2) != 'p' || string.charAt(1) != 'x') break;
                        return 8;
                    }
                    case 'l': {
                        if (string.charAt(2) != 'g' || string.charAt(1) != 'o') break;
                        return 10;
                    }
                    case 'm': {
                        char c = string.charAt(2);
                        if (c == 'n') {
                            if (string.charAt(1) != 'i') break;
                            return 12;
                        }
                        if (c != 'x' || string.charAt(1) != 'a') break;
                        return 11;
                    }
                    case 'p': {
                        if (string.charAt(2) != 'w' || string.charAt(1) != 'o') break;
                        return 13;
                    }
                    case 's': {
                        if (string.charAt(2) != 'n' || string.charAt(1) != 'i') break;
                        return 16;
                    }
                    case 't': {
                        if (string.charAt(2) != 'n' || string.charAt(1) != 'a') break;
                        return 18;
                    }
                }
                break;
            }
            case 4: {
                switch (string.charAt(1)) {
                    case 'N': {
                        string2 = "LN10";
                        n = 21;
                        break block0;
                    }
                    case 'c': {
                        string2 = "acos";
                        n = 2;
                        break block0;
                    }
                    case 'e': {
                        string2 = "ceil";
                        n = 6;
                        break block0;
                    }
                    case 'q': {
                        string2 = "sqrt";
                        n = 17;
                        break block0;
                    }
                    case 's': {
                        string2 = "asin";
                        n = 3;
                        break block0;
                    }
                    case 't': {
                        string2 = "atan";
                        n = 4;
                        break block0;
                    }
                }
                break;
            }
            case 5: {
                switch (string.charAt(0)) {
                    case 'L': {
                        string2 = "LOG2E";
                        n = 23;
                        break block0;
                    }
                    case 'S': {
                        string2 = "SQRT2";
                        n = 26;
                        break block0;
                    }
                    case 'a': {
                        string2 = "atan2";
                        n = 5;
                        break block0;
                    }
                    case 'f': {
                        string2 = "floor";
                        n = 9;
                        break block0;
                    }
                    case 'r': {
                        string2 = "round";
                        n = 15;
                        break block0;
                    }
                }
                break;
            }
            case 6: {
                char c = string.charAt(0);
                if (c == 'L') {
                    string2 = "LOG10E";
                    n = 24;
                    break;
                }
                if (c != 'r') break;
                string2 = "random";
                n = 14;
                break;
            }
            case 7: {
                string2 = "SQRT1_2";
                n = 25;
            }
        }
        if (string2 == null) return n;
        if (string2 == string) return n;
        if (string2.equals(string)) return n;
        return 0;
    }
}

