/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.project.ui.OpenProjectListSettings;
import org.netbeans.modules.project.ui.TemplatesPanelGUI;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.AsyncGUIJob;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class TemplatesPanel
implements WizardDescriptor.Panel {
    private ArrayList listeners;
    private TemplatesPanelGUI panel;
    private WarmupJob warmUp;
    private boolean warmUpActive;
    private boolean needsReselect = false;

    public void readSettings(Object settings) {
        TemplateWizard wd = (TemplateWizard)settings;
        wd.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(0));
        wd.putProperty("WizardPanel_contentData", (Object)new String[]{NbBundle.getBundle((Class)TemplatesPanel.class).getString("LBL_TemplatesPanel_Name"), NbBundle.getBundle((Class)TemplatesPanel.class).getString("LBL_TemplatesPanel_Dots")});
        FileObject templatesFolder = (FileObject)wd.getProperty("templatesFolder");
        String preselectedCategory = (String)wd.getProperty("PRESELECT_CATEGORY");
        if (templatesFolder != null && templatesFolder.isFolder() && (wd.getTemplate() == null || preselectedCategory != null || this.needsReselect)) {
            String preselectedTemplate = (String)wd.getProperty("PRESELECT_TEMPLATE");
            String selectedCategory = OpenProjectListSettings.getInstance().getLastSelectedProjectCategory();
            String selectedTemplate = OpenProjectListSettings.getInstance().getLastSelectedProjectType();
            String template = preselectedTemplate == null ? (preselectedCategory != null ? null : selectedTemplate) : (preselectedCategory != null ? preselectedTemplate : selectedTemplate);
            TemplatesPanelGUI p = (TemplatesPanelGUI)this.getComponent();
            if (this.isWarmUpActive()) {
                WarmupJob wup = this.getWarmUp();
                wup.setTemplatesFolder(templatesFolder);
                wup.setSelectedCategory(preselectedCategory != null ? preselectedCategory : selectedCategory);
                wup.setSelectedTemplate(template);
            } else {
                p.setTemplatesFolder(templatesFolder);
                p.setSelectedCategoryByName(preselectedCategory != null ? preselectedCategory : selectedCategory);
                p.setSelectedTemplateByName(template);
            }
        }
        ((WizardDescriptor)settings).putProperty("NewProjectWizard_Title", null);
    }

    public void storeSettings(Object settings) {
        TemplateWizard wd = (TemplateWizard)settings;
        String preselectedCategory = (String)wd.getProperty("PRESELECT_CATEGORY");
        TemplatesPanelGUI gui = (TemplatesPanelGUI)this.getComponent();
        FileObject fo = gui.getSelectedTemplate();
        if (fo != null) {
            try {
                wd.setTemplate(DataObject.find((FileObject)fo));
            }
            catch (DataObjectNotFoundException e) {
                ErrorManager.getDefault().notify((Throwable)e);
            }
        }
        if (preselectedCategory == null) {
            String path = gui.getSelectedCategoryName();
            if (path != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectCategory(path);
            }
            if ((path = gui.getSelectedTemplateName()) != null) {
                OpenProjectListSettings.getInstance().setLastSelectedProjectType(path);
            }
            this.needsReselect = false;
        } else {
            this.needsReselect = true;
        }
    }

    public synchronized void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(l);
    }

    public boolean isValid() {
        return ((TemplatesPanelGUI)this.getComponent()).getSelectedTemplate() != null;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(TemplatesPanel.class);
    }

    public synchronized Component getComponent() {
        if (this.panel == null) {
            Builder firer = new Builder();
            this.panel = new TemplatesPanelGUI(firer);
            Utilities.attachInitJob((Component)this.panel, (AsyncGUIJob)this.getWarmUp());
            this.warmUpActive = true;
            this.panel.setName(NbBundle.getBundle((Class)TemplatesPanel.class).getString("LBL_TemplatesPanel_Name"));
        }
        return this.panel;
    }

    private synchronized WarmupJob getWarmUp() {
        if (this.warmUp == null) {
            this.warmUp = new WarmupJob();
        }
        return this.warmUp;
    }

    private synchronized boolean isWarmUpActive() {
        return this.warmUpActive;
    }

    private class Builder
    implements TemplatesPanelGUI.Builder {
        static final /* synthetic */ boolean $assertionsDisabled;

        private Builder() {
        }

        public Children createCategoriesChildren(DataFolder folder) {
            if (!$assertionsDisabled && folder == null) {
                throw new AssertionError((Object)"Folder cannot be null.");
            }
            return new CategoriesChildren(folder);
        }

        public Children createTemplatesChildren(DataFolder folder) {
            return new TemplateChildren(folder);
        }

        public char getCategoriesMnemonic() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplatesPanel == null ? (class$org$netbeans$modules$project$ui$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.project.ui.TemplatesPanel")) : class$org$netbeans$modules$project$ui$TemplatesPanel), (String)"MNE_Categories").charAt(0);
        }

        public String getCategoriesName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplatesPanel == null ? (class$org$netbeans$modules$project$ui$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.project.ui.TemplatesPanel")) : class$org$netbeans$modules$project$ui$TemplatesPanel), (String)"CTL_Categories");
        }

        public char getTemplatesMnemonic() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplatesPanel == null ? (class$org$netbeans$modules$project$ui$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.project.ui.TemplatesPanel")) : class$org$netbeans$modules$project$ui$TemplatesPanel), (String)"MNE_Projects").charAt(0);
        }

        public String getTemplatesName() {
            return NbBundle.getMessage((Class)(class$org$netbeans$modules$project$ui$TemplatesPanel == null ? (class$org$netbeans$modules$project$ui$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.project.ui.TemplatesPanel")) : class$org$netbeans$modules$project$ui$TemplatesPanel), (String)"CTL_Projects");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fireChange() {
            Iterator it = null;
            Builder builder = this;
            synchronized (builder) {
                if (TemplatesPanel.this.listeners == null) {
                    return;
                }
                it = ((ArrayList)TemplatesPanel.this.listeners.clone()).iterator();
            }
            ChangeEvent event = new ChangeEvent(this);
            while (it.hasNext()) {
                ((ChangeListener)it.next()).stateChanged(event);
            }
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$modules$project$ui$TemplatesPanel == null ? (class$org$netbeans$modules$project$ui$TemplatesPanel = TemplatesPanel.class$("org.netbeans.modules.project.ui.TemplatesPanel")) : class$org$netbeans$modules$project$ui$TemplatesPanel).desiredAssertionStatus();
        }
    }

    private class WarmupJob
    implements AsyncGUIJob {
        private FileObject templatesFolder;
        private String category;
        private String template;

        private WarmupJob() {
        }

        public void construct() {
            TemplatesPanel.this.panel.warmUp(this.templatesFolder);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finished() {
            Cursor cursor = null;
            try {
                cursor = TemplatesPanel.this.panel.getCursor();
                TemplatesPanel.this.panel.setCursor(Cursor.getPredefinedCursor(3));
                TemplatesPanel.this.panel.doFinished(this.templatesFolder, this.category, this.template);
            }
            finally {
                if (cursor != null) {
                    TemplatesPanel.this.panel.setCursor(cursor);
                }
                TemplatesPanel templatesPanel = TemplatesPanel.this;
                synchronized (templatesPanel) {
                    TemplatesPanel.this.warmUpActive = false;
                }
            }
        }

        void setTemplatesFolder(FileObject fo) {
            this.templatesFolder = fo;
        }

        void setSelectedCategory(String s) {
            this.category = s;
        }

        void setSelectedTemplate(String s) {
            this.template = s;
        }
    }

    private static class TemplateChildren
    extends Children.Keys {
        private DataFolder folder;

        public TemplateChildren(DataFolder folder) {
            this.folder = folder;
        }

        protected void addNotify() {
            this.setKeys(this.folder.getChildren());
        }

        protected void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            DataObject dobj;
            if (key instanceof DataObject && (dobj = (DataObject)key).isTemplate()) {
                return new Node[]{new FilterNode(dobj.getNodeDelegate(), Children.LEAF)};
            }
            return new Node[0];
        }
    }

    private static class CategoriesChildren
    extends Children.Keys {
        private DataFolder root;

        public CategoriesChildren(DataFolder folder) {
            this.root = folder;
        }

        protected void addNotify() {
            Object[] children = this.root.getChildren();
            this.setKeys(children);
        }

        protected void removeNotify() {
            this.setKeys(new Object[0]);
        }

        protected Node[] createNodes(Object key) {
            DataObject dobj;
            if (key instanceof DataObject && (dobj = (DataObject)key) instanceof DataFolder) {
                DataFolder folder = (DataFolder)dobj;
                DataObject[] children = folder.getChildren();
                int type = children.length == 0 ? 0 : 1;
                for (int i = 0; i < children.length; ++i) {
                    if (!children[i].getPrimaryFile().isFolder()) continue;
                    type = 2;
                    break;
                }
                if (type == 1) {
                    return new Node[]{new FilterNode(dobj.getNodeDelegate(), Children.LEAF)};
                }
                if (type == 2) {
                    return new Node[]{new FilterNode(dobj.getNodeDelegate(), (Children)new CategoriesChildren((DataFolder)dobj))};
                }
            }
            return new Node[0];
        }
    }
}

