/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.uiapi;

import java.awt.Container;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.project.uiapi.DefaultProjectDeletePanel;
import org.netbeans.modules.project.uiapi.DefaultProjectRenamePanel;
import org.netbeans.modules.project.uiapi.ProjectCopyPanel;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.netbeans.spi.project.support.ProjectOperations;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public final class DefaultProjectOperationsImplementation {
    private static final ErrorManager ERR;
    private static final double NOTIFY_WORK = 0.1;
    private static final double FIND_PROJECT_WORK = 0.1;
    private static final int MAX_WORK = 100;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$spi$project$MoveOperationImplementation;

    private DefaultProjectOperationsImplementation() {
    }

    private static String getDisplayName(Project project) {
        return ProjectUtils.getInformation((Project)project).getDisplayName();
    }

    private static boolean performDelete(Project project, List toDelete, ProgressHandle handle) throws Exception {
        try {
            handle.start(toDelete.size() + 1);
            int done = 0;
            handle.progress(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Progress_Cleaning_Project"));
            ProjectOperations.notifyDeleting((Project)project);
            handle.progress(++done);
            Iterator i = toDelete.iterator();
            while (i.hasNext()) {
                FileObject f = (FileObject)i.next();
                handle.progress(NbBundle.getMessage((Class)(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation") : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation), (String)"LBL_Progress_Deleting_File", (Object[])new Object[]{FileUtil.getFileDisplayName((FileObject)f)}));
                if (f != null) {
                    f.delete();
                }
                handle.progress(++done);
            }
            FileObject projectFolder = project.getProjectDirectory();
            if (projectFolder.getChildren().length == 0) {
                projectFolder.delete();
            }
            handle.finish();
            ProjectOperations.notifyDeleted((Project)project);
            return true;
        }
        catch (Exception e) {
            String displayName = DefaultProjectOperationsImplementation.getDisplayName(project);
            String message = NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Project_cannot_be_deleted.", (Object[])new Object[]{displayName});
            ErrorManager.getDefault().annotate((Throwable)e, message);
            return false;
        }
    }

    public static void deleteProject(Project project) {
        DefaultProjectOperationsImplementation.deleteProject(project, new GUIUserInputHandler());
    }

    static void deleteProject(final Project project, UserInputHandler handler) {
        String displayName = DefaultProjectOperationsImplementation.getDisplayName(project);
        FileObject projectFolder = project.getProjectDirectory();
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete started: " + displayName);
        }
        final List metadataFiles = ProjectOperations.getMetadataFiles((Project)project);
        List dataFiles = ProjectOperations.getDataFiles((Project)project);
        final ArrayList allFiles = new ArrayList();
        allFiles.addAll(metadataFiles);
        allFiles.addAll(dataFiles);
        Iterator i = allFiles.iterator();
        while (i.hasNext()) {
            FileObject f = (FileObject)i.next();
            if (FileUtil.isParentOf((FileObject)projectFolder, (FileObject)f)) continue;
            i.remove();
        }
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption"));
        final DefaultProjectDeletePanel deletePanel = new DefaultProjectDeletePanel(handle, displayName, FileUtil.getFileDisplayName((FileObject)projectFolder), !dataFiles.isEmpty());
        String caption = NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Delete_Project_Caption");
        handler.showConfirmationDialog(deletePanel, project, caption, "Yes_Button", "No_Button", true, new Executor(){

            public void execute() throws Exception {
                DefaultProjectOperationsImplementation.close(project);
                if (deletePanel.isDeleteSources()) {
                    DefaultProjectOperationsImplementation.performDelete(project, allFiles, handle);
                } else {
                    DefaultProjectOperationsImplementation.performDelete(project, metadataFiles, handle);
                }
            }
        });
        if (ERR.isLoggable(1)) {
            ERR.log(1, "delete done: " + displayName);
        }
    }

    public static void copyProject(final Project project) {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Handle"));
        final ProjectCopyPanel panel = new ProjectCopyPanel(handle, project, false);
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Copy_Project_Caption"), "Copy_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String nueName = panel.getNewName();
                File newTarget = panel.getNewDirectory();
                FileObject newTargetFO = FileUtil.toFileObject((File)newTarget);
                DefaultProjectOperationsImplementation.doCopyProject(handle, project, nueName, newTargetFO);
            }
        });
    }

    static void doCopyProject(ProgressHandle handle, Project project, String nueName, FileObject newTarget) throws Exception {
        try {
            int totalWork = 100;
            handle.start(totalWork);
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            ProjectOperations.notifyCopying((Project)project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject target = newTarget.createFolder(nueName);
            FileObject projectDirectory = project.getProjectDirectory();
            List<FileObject> toCopyList = Arrays.asList(projectDirectory.getChildren());
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001 / (double)toCopyList.size();
            Iterator<FileObject> i = toCopyList.iterator();
            while (i.hasNext()) {
                FileObject toCopy = i.next();
                File toCopyFile = FileUtil.toFile((FileObject)toCopy);
                DefaultProjectOperationsImplementation.doCopy(project, toCopy, target);
                int lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            if (!$assertionsDisabled && nue == null) {
                throw new AssertionError();
            }
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectOperations.notifyCopied((Project)project, (Project)nue, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)nueName);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            DefaultProjectOperationsImplementation.open(nue, false);
            handle.progress(totalWork);
            handle.finish();
        }
        catch (Exception e) {
            ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Cannot_Move", (Object[])new Object[]{e.getLocalizedMessage()}));
            throw e;
        }
    }

    public static void moveProject(final Project project) {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Handle"));
        final ProjectCopyPanel panel = new ProjectCopyPanel(handle, project, true);
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Move_Project_Caption"), "Move_Button", null, false, new Executor(){

            public void execute() throws Exception {
                String nueName = panel.getNewName();
                File newTarget = panel.getNewDirectory();
                FileObject newTargetFO = FileUtil.toFileObject((File)newTarget);
                DefaultProjectOperationsImplementation.doMoveProject(handle, project, nueName, newTargetFO, "ERR_Cannot_Move");
            }
        });
    }

    public static void renameProject(Project project) {
        DefaultProjectOperationsImplementation.renameProject(project, null);
    }

    public static void renameProject(final Project project, String nueName) {
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Handle"));
        final DefaultProjectRenamePanel panel = new DefaultProjectRenamePanel(handle, project, nueName);
        DefaultProjectOperationsImplementation.showConfirmationDialog(panel, project, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Rename_Project_Caption"), "Rename_Button", null, false, new Executor(){
            static final /* synthetic */ boolean $assertionsDisabled;

            public void execute() throws Exception {
                String nueName = panel.getNewName();
                if (panel.getRenameProjectFolder()) {
                    DefaultProjectOperationsImplementation.doMoveProject(handle, project, nueName, project.getProjectDirectory().getParent(), "ERR_Cannot_Rename");
                } else {
                    boolean originalOK = true;
                    Project main = OpenProjects.getDefault().getMainProject();
                    boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
                    Project nue = null;
                    try {
                        handle.start(5);
                        int currentWorkDone = 0;
                        FileObject projectDirectory = project.getProjectDirectory();
                        File projectDirectoryFile = FileUtil.toFile((FileObject)project.getProjectDirectory());
                        Collection operations = project.getLookup().lookup(new Lookup.Template(class$org$netbeans$spi$project$MoveOperationImplementation == null ? (class$org$netbeans$spi$project$MoveOperationImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.spi.project.MoveOperationImplementation")) : class$org$netbeans$spi$project$MoveOperationImplementation)).allInstances();
                        DefaultProjectOperationsImplementation.close(project);
                        handle.progress(++currentWorkDone);
                        Iterator i = operations.iterator();
                        while (i.hasNext()) {
                            ((MoveOperationImplementation)i.next()).notifyMoving();
                        }
                        handle.progress(++currentWorkDone);
                        i = operations.iterator();
                        while (i.hasNext()) {
                            ((MoveOperationImplementation)i.next()).notifyMoved(null, projectDirectoryFile, nueName);
                        }
                        handle.progress(++currentWorkDone);
                        ProjectManager.getDefault().clearNonProjectCache();
                        nue = ProjectManager.getDefault().findProject(projectDirectory);
                        if (!$assertionsDisabled && nue == null) {
                            throw new AssertionError();
                        }
                        originalOK = false;
                        handle.progress(++currentWorkDone);
                        Collection nueOperations = nue.getLookup().lookup(new Lookup.Template(class$org$netbeans$spi$project$MoveOperationImplementation == null ? (class$org$netbeans$spi$project$MoveOperationImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.spi.project.MoveOperationImplementation")) : class$org$netbeans$spi$project$MoveOperationImplementation)).allInstances();
                        Iterator i2 = nueOperations.iterator();
                        while (i2.hasNext()) {
                            ((MoveOperationImplementation)i2.next()).notifyMoved(project, projectDirectoryFile, nueName);
                        }
                        ProjectManager.getDefault().saveProject(nue);
                        DefaultProjectOperationsImplementation.open(nue, wasMain);
                        handle.progress(++currentWorkDone);
                        handle.finish();
                    }
                    catch (Exception e) {
                        if (originalOK) {
                            DefaultProjectOperationsImplementation.open(project, wasMain);
                        } else {
                            if (!$assertionsDisabled && nue == null) {
                                throw new AssertionError();
                            }
                            DefaultProjectOperationsImplementation.open(nue, wasMain);
                        }
                        ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? (class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation")) : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation), (String)"ERR_Cannot_Rename", (Object[])new Object[]{e.getLocalizedMessage()}));
                        throw e;
                    }
                }
            }

            static {
                $assertionsDisabled = !(class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation == null ? (class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation = DefaultProjectOperationsImplementation.class$("org.netbeans.modules.project.uiapi.DefaultProjectOperationsImplementation")) : class$org$netbeans$modules$project$uiapi$DefaultProjectOperationsImplementation).desiredAssertionStatus();
            }
        });
    }

    static void doMoveProject(ProgressHandle handle, Project project, String nueName, FileObject newTarget, String errorKey) throws Exception {
        boolean originalOK = true;
        Project main = OpenProjects.getDefault().getMainProject();
        boolean wasMain = main != null && project.getProjectDirectory().equals(main.getProjectDirectory());
        FileObject target = null;
        try {
            FileObject toCopy;
            int totalWork = 100;
            handle.start(totalWork);
            double currentWorkDone = 0.0;
            handle.progress((int)currentWorkDone);
            ProjectOperations.notifyMoving((Project)project);
            DefaultProjectOperationsImplementation.close(project);
            currentWorkDone = (double)totalWork * 0.1;
            handle.progress((int)currentWorkDone);
            FileObject projectDirectory = project.getProjectDirectory();
            List<FileObject> toMoveList = Arrays.asList(projectDirectory.getChildren());
            double workPerFileAndOperation = (double)totalWork * 0.7000000000000001 / (double)toMoveList.size() / 2.0;
            target = newTarget.createFolder(nueName);
            Iterator<FileObject> i = toMoveList.iterator();
            while (i.hasNext()) {
                toCopy = i.next();
                DefaultProjectOperationsImplementation.doCopy(project, toCopy, target);
                int lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            originalOK = false;
            i = toMoveList.iterator();
            while (i.hasNext()) {
                toCopy = i.next();
                File toCopyFile = FileUtil.toFile((FileObject)toCopy);
                DefaultProjectOperationsImplementation.doDelete(project, toCopy);
                int lastWorkDone = (int)currentWorkDone;
                if (lastWorkDone >= (int)(currentWorkDone += workPerFileAndOperation)) continue;
                handle.progress((int)currentWorkDone);
            }
            if (projectDirectory.getChildren().length == 0) {
                projectDirectory.delete();
            }
            ProjectManager.getDefault().clearNonProjectCache();
            Project nue = ProjectManager.getDefault().findProject(target);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            if (!$assertionsDisabled && nue == null) {
                throw new AssertionError();
            }
            ProjectOperations.notifyMoved((Project)project, (Project)nue, (File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)nueName);
            handle.progress((int)(currentWorkDone += (double)totalWork * 0.1));
            ProjectManager.getDefault().saveProject(nue);
            DefaultProjectOperationsImplementation.open(nue, wasMain);
            handle.progress(totalWork);
            handle.finish();
        }
        catch (Exception e) {
            if (originalOK) {
                DefaultProjectOperationsImplementation.open(project, wasMain);
            } else {
                if (!$assertionsDisabled && target == null) {
                    throw new AssertionError();
                }
                ProjectManager.getDefault().clearNonProjectCache();
                Project nue = ProjectManager.getDefault().findProject(target);
                if (!$assertionsDisabled && nue == null) {
                    throw new AssertionError();
                }
                DefaultProjectOperationsImplementation.open(nue, wasMain);
            }
            ErrorManager.getDefault().annotate((Throwable)e, NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)errorKey, (Object[])new Object[]{e.getLocalizedMessage()}));
            throw e;
        }
    }

    private static void doCopy(Project original, FileObject from, FileObject toParent) throws IOException {
        if (!VisibilityQuery.getDefault().isVisible(from)) {
            return;
        }
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)from).getProjectDirectory())) {
            return;
        }
        if (from.isFolder()) {
            FileObject copy = toParent.createFolder(from.getNameExt());
            FileObject[] kids = from.getChildren();
            for (int i = 0; i < kids.length; ++i) {
                DefaultProjectOperationsImplementation.doCopy(original, kids[i], copy);
            }
        } else {
            if (!$assertionsDisabled && !from.isData()) {
                throw new AssertionError();
            }
            FileObject fileObject = FileUtil.copyFile((FileObject)from, (FileObject)toParent, (String)from.getName(), (String)from.getExt());
        }
    }

    private static boolean doDelete(Project original, FileObject toDelete) throws IOException {
        if (!original.getProjectDirectory().equals(FileOwnerQuery.getOwner((FileObject)toDelete).getProjectDirectory())) {
            return false;
        }
        if (toDelete.isFolder()) {
            FileObject[] kids = toDelete.getChildren();
            boolean delete = true;
            for (int i = 0; i < kids.length; ++i) {
                delete &= DefaultProjectOperationsImplementation.doDelete(original, kids[i]);
            }
            if (delete) {
                toDelete.delete();
            }
            return delete;
        }
        if (!$assertionsDisabled && !toDelete.isData()) {
            throw new AssertionError();
        }
        toDelete.delete();
        return true;
    }

    private static JComponent wrapPanel(JComponent component) {
        component.setBorder(new EmptyBorder(12, 12, 12, 12));
        return component;
    }

    private static void showConfirmationDialog(final JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, final Executor executor) {
        final JButton confirm = new JButton(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("LBL_" + confirmButton)));
        final JButton cancel = new JButton(cancelButton == null ? NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"LBL_Cancel_Button") : NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("LBL_" + cancelButton)));
        confirm.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("ACSD_" + confirmButton)));
        cancel.getAccessibleContext().setAccessibleDescription(cancelButton == null ? NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ACSD_Cancel_Button") : NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)("ACSD_" + cancelButton)));
        if (!$assertionsDisabled && !(panel instanceof InvalidablePanel)) {
            throw new AssertionError();
        }
        ((InvalidablePanel)((Object)panel)).addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid());
            }
        });
        confirm.setEnabled(((InvalidablePanel)((Object)panel)).isPanelValid());
        final Dialog[] dialog = new Dialog[1];
        DialogDescriptor dd = new DialogDescriptor((Object)(doSetMessageType ? panel : DefaultProjectOperationsImplementation.wrapPanel(panel)), caption, true, new Object[]{confirm, cancel}, (Object)(cancelButton != null ? cancel : confirm), 0, null, new ActionListener(){
            private boolean operationRunning;

            public void actionPerformed(ActionEvent e) {
                if (this.operationRunning) {
                    return;
                }
                if (dialog[0] instanceof JDialog) {
                    ((JDialog)dialog[0]).getRootPane().getInputMap(1).remove(KeyStroke.getKeyStroke(27, 0));
                    ((JDialog)dialog[0]).setDefaultCloseOperation(0);
                }
                this.operationRunning = true;
                if (e.getSource() == confirm) {
                    Container findParent;
                    confirm.setEnabled(false);
                    cancel.setEnabled(false);
                    ((InvalidablePanel)((Object)panel)).showProgress();
                    for (findParent = panel; findParent != null && !(findParent instanceof Window); findParent = findParent.getParent()) {
                    }
                    if (findParent != null) {
                        ((Window)findParent).pack();
                    }
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            Exception e = null;
                            try {
                                executor.execute();
                            }
                            catch (Exception ex) {
                                e = ex;
                            }
                            final Exception ex = e;
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    dialog[0].setVisible(false);
                                    if (ex != null) {
                                        ErrorManager.getDefault().notify(1, (Throwable)ex);
                                        ErrorManager.getDefault().notify(256, (Throwable)ex);
                                    }
                                }
                            });
                        }
                    });
                } else {
                    dialog[0].setVisible(false);
                }
            }
        });
        if (doSetMessageType) {
            dd.setMessageType(3);
        }
        dd.setClosingOptions(new Object[0]);
        dialog[0] = DialogDisplayer.getDefault().createDialog(dd);
        dialog[0].setVisible(true);
        dialog[0].dispose();
        dialog[0] = null;
    }

    static String computeError(File location, String projectNameText, boolean pureRename) {
        if (!location.exists()) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Does_Not_Exist");
        }
        if (!location.canWrite()) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Location_Read_Only");
        }
        if (projectNameText.length() == 0) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Name_Must_Entered");
        }
        File projectFolderFile = new File(location, projectNameText);
        if (projectFolderFile.exists() && !pureRename) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Project_Folder_Exists");
        }
        if (projectNameText.indexOf(47) != -1 || projectNameText.indexOf(92) != -1) {
            return NbBundle.getMessage((Class)DefaultProjectOperationsImplementation.class, (String)"ERR_Not_Valid_Filename", (Object)projectNameText);
        }
        return null;
    }

    private static void close(final Project prj) {
        Mutex.EVENT.readAccess(new Mutex.Action(){

            public Object run() {
                LifecycleManager.getDefault().saveAll();
                Action closeAction = CommonProjectActions.closeProjectAction();
                Action action = closeAction = closeAction instanceof ContextAwareAction ? ((ContextAwareAction)closeAction).createContextAwareInstance(Lookups.fixed((Object[])new Object[]{prj})) : null;
                if (closeAction != null && closeAction.isEnabled()) {
                    closeAction.actionPerformed(new ActionEvent(prj, -1, ""));
                } else {
                    OpenProjects.getDefault().close(new Project[]{prj});
                }
                return null;
            }
        });
    }

    private static void open(final Project prj, final boolean setAsMain) {
        Mutex.EVENT.readAccess(new Runnable(){

            public void run() {
                OpenProjects.getDefault().open(new Project[]{prj}, false);
                if (setAsMain) {
                    OpenProjects.getDefault().setMainProject(prj);
                }
            }
        });
    }

    static {
        $assertionsDisabled = !DefaultProjectOperationsImplementation.class.desiredAssertionStatus();
        ERR = ErrorManager.getDefault();
    }

    public static interface InvalidablePanel {
        public void addChangeListener(ChangeListener var1);

        public void removeChangeListener(ChangeListener var1);

        public boolean isPanelValid();

        public void showProgress();
    }

    static interface Executor {
        public void execute() throws Exception;
    }

    private static final class GUIUserInputHandler
    implements UserInputHandler {
        private GUIUserInputHandler() {
        }

        public void showConfirmationDialog(JComponent panel, Project project, String caption, String confirmButton, String cancelButton, boolean doSetMessageType, Executor executor) {
            DefaultProjectOperationsImplementation.showConfirmationDialog(panel, project, caption, confirmButton, cancelButton, doSetMessageType, executor);
        }
    }

    static interface UserInputHandler {
        public void showConfirmationDialog(JComponent var1, Project var2, String var3, String var4, String var5, boolean var6, Executor var7);
    }
}

