/*
 * Decompiled with CFR 0.152.
 */
package org.openide.nodes;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;

public class NodeMemberEvent
extends NodeEvent {
    static final long serialVersionUID = -3973509253579305102L;
    private boolean add;
    private Node[] delta;
    private Node[] from;
    private int[] indices;

    NodeMemberEvent(Node n, boolean add, Node[] delta, Node[] from) {
        super(n);
        this.add = add;
        this.delta = delta;
        this.from = from;
    }

    public final boolean isAddEvent() {
        return this.add;
    }

    public final Node[] getDelta() {
        return this.delta;
    }

    public synchronized int[] getDeltaIndices() {
        int i;
        if (this.indices != null) {
            return this.indices;
        }
        if (this.from == null) {
            this.from = this.getNode().getChildren().getNodes();
        }
        List<Node> list = Arrays.asList(this.delta);
        HashSet<Node> set = new HashSet<Node>(list);
        this.indices = new int[this.delta.length];
        int j = 0;
        for (i = 0; i < this.from.length && j < this.indices.length; ++i) {
            if (!set.contains(this.from[i])) continue;
            this.indices[j++] = i;
        }
        if (j != this.delta.length) {
            StringBuffer m = new StringBuffer(1000);
            m.append("Some of a set of deleted nodes are not present in the original ones.\n");
            m.append("See #15478; you may need to check that your Children.Keys keys are safely comparable.");
            m.append("\ni: " + i);
            m.append("\nj: " + j);
            m.append("\nThis: " + this);
            m.append("\nCurrent state:\n");
            m.append(Arrays.asList(this.from));
            m.append("\nDelta:\n");
            m.append(list);
            throw new IllegalStateException(m.toString());
        }
        return this.indices;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append("[node=");
        sb.append(this.getSource());
        sb.append(", add=");
        sb.append(this.isAddEvent());
        Node[] deltaNodes = this.getDelta();
        int[] deltaIndices = this.getDeltaIndices();
        for (int i = 0; i < deltaNodes.length; ++i) {
            sb.append("\n  ");
            sb.append(i);
            sb.append(" at ");
            sb.append(deltaIndices[i]);
            sb.append(" = ");
            sb.append(deltaNodes[i]);
        }
        sb.append("\n]");
        return sb.toString();
    }
}

