/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.plugins;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.CallableFeature;
import org.netbeans.jmi.javamodel.ClassDefinition;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.ElementReference;
import org.netbeans.jmi.javamodel.Feature;
import org.netbeans.jmi.javamodel.Field;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.JavaModelPackage;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.MethodInvocation;
import org.netbeans.jmi.javamodel.MultipartId;
import org.netbeans.jmi.javamodel.NamedElement;
import org.netbeans.jmi.javamodel.NewClassExpression;
import org.netbeans.jmi.javamodel.ThisExpression;
import org.netbeans.jmi.javamodel.TypeReference;
import org.netbeans.jmi.javamodel.UnresolvedClass;
import org.netbeans.jmi.javamodel.VariableAccess;
import org.netbeans.modules.javacore.JMManager;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.modules.javacore.internalapi.JavaModelUtil;
import org.netbeans.modules.javacore.jmiimpl.javamodel.MetadataElement;
import org.netbeans.modules.refactoring.ChangeModElement;
import org.netbeans.modules.refactoring.CheckUtils;
import org.netbeans.modules.refactoring.UndoWatcher;
import org.netbeans.modules.refactoring.Utilities;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.PullUpRefactoring;
import org.netbeans.modules.refactoring.plugins.JavaRefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImpl;
import org.netbeans.modules.refactoring.ui.UIUtilities;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.NbBundle;

public class PullUpRefactoringPlugin
extends JavaRefactoringPlugin {
    private final PullUpRefactoring refactoring;

    PullUpRefactoringPlugin(PullUpRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem preCheck() {
        this.fireProgressListenerStart(1, 4);
        try {
            JavaClass sourceType = this.refactoring.getSourceType();
            Problem result = PullUpRefactoringPlugin.isElementAvail((Element)sourceType);
            if (result != null) {
                Problem problem = result;
                return problem;
            }
            if (!CheckUtils.isElementInOpenProject((Element)sourceType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ProjectNotOpened"));
                return problem;
            }
            if (sourceType instanceof UnresolvedClass) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)JavaRefactoringPlugin.class, (String)"ERR_ElementNotAvailable"));
                return problem;
            }
            this.fireProgressListenerStep();
            JavaClass[] supertypes = this.refactoring.collectSupertypes();
            if (supertypes.length == 0) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoSuperTypes"));
                return problem;
            }
            this.fireProgressListenerStep();
            if (!PullUpRefactoringPlugin.hasMembers(sourceType, supertypes)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembers"));
                return problem;
            }
            this.fireProgressListenerStep();
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem fastCheckParameters() {
        PullUpRefactoring.MemberInfo[] info = this.refactoring.getMembers();
        if (info.length == 0) {
            return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoMembersSelected"));
        }
        if (info.length > 1) {
            for (int i = 0; i < info.length - 1; ++i) {
                for (int j = i + 1; j < info.length; ++j) {
                    if (!CheckUtils.membersEqual(info[i].member, info[j].member)) continue;
                    return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_CannotPullupDuplicateMembers"));
                }
            }
        }
        if (this.refactoring.getTargetType() == null) {
            return new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_NoTargetType"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Problem checkParameters() {
        HashSet<JavaClass> supers = new HashSet<JavaClass>(Arrays.asList(this.refactoring.collectSupertypes()));
        JavaClass targetType = this.refactoring.getTargetType();
        PullUpRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        this.fireProgressListenerStart(2, members.length + 1);
        try {
            if (!supers.contains(targetType)) {
                Problem problem = new Problem(true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalTargetType"));
                return problem;
            }
            this.fireProgressListenerStep();
            HashSet<Object> visitedSources = new HashSet<Object>();
            Problem problems = null;
            visitedSources.add(this.refactoring.getSourceType());
            for (int i = 0; i < members.length; ++i) {
                Object ifcName;
                RefFeatured parent;
                NamedElement member = members[i].member;
                Object cls = member instanceof Feature ? ((Feature)member).getDeclaringClass() : (!((parent = (ifcName = (MultipartId)member).refImmediateComposite()) instanceof JavaClass) ? null : (!((JavaClass)parent).getInterfaceNames().contains(ifcName) ? null : (ClassDefinition)parent));
                if (!(!visitedSources.add(cls) || cls instanceof JavaClass && supers.contains(cls) && !cls.equals(targetType) && cls.isSubTypeOf((ClassDefinition)targetType))) {
                    ifcName = PullUpRefactoringPlugin.createProblem(problems, true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_IllegalMember", (Object)member.getName()));
                    return ifcName;
                }
                boolean exists = member instanceof Field ? targetType.getField(member.getName(), false) != null : (member instanceof Method ? targetType.getMethod(member.getName(), Utilities.getFeatureParamTypes((CallableFeature)member), false) != null : (member instanceof JavaClass ? targetType.getInnerClass(member.getName(), false) != null : targetType.getInterfaces().contains(((MultipartId)member).getElement())));
                if (exists) {
                    Problem problem = PullUpRefactoringPlugin.createProblem(problems, true, NbBundle.getMessage((Class)PullUpRefactoringPlugin.class, (String)"ERR_PullUp_MemberAlreadyExists", (Object)member.getName()));
                    return problem;
                }
                this.fireProgressListenerStep();
            }
            Problem problem = null;
            return problem;
        }
        finally {
            this.fireProgressListenerStop();
        }
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        PullUpRefactoring.MemberInfo[] members = this.refactoring.getMembers();
        boolean makeTargetTypeAbstract = false;
        for (int i = 0; i < members.length; ++i) {
            int modifiers = members[i].member instanceof MultipartId ? 0 : ((Feature)members[i].member).getModifiers();
            int newmodifiers = 0;
            if (this.refactoring.getTargetType().isInterface()) {
                newmodifiers = (modifiers | 1) & 0xFFFFFFFD & 0xFFFFFFFB;
            } else if (!Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers)) {
                newmodifiers = (modifiers | 4) & 0xFFFFFFFD;
            }
            if (members[i].makeAbstract) {
                refactoringElements.add(this.refactoring, new AddAbstractMethodElement((Method)members[i].member, this.refactoring.getTargetType(), newmodifiers));
                makeTargetTypeAbstract = true;
                if (newmodifiers == 0) continue;
                refactoringElements.add(this.refactoring, new ChangeModElement((Feature)members[i].member, newmodifiers));
                continue;
            }
            refactoringElements.add(this.refactoring, new MoveMemberElement(members[i].member, this.refactoring.getTargetType(), newmodifiers));
            if (!Modifier.isAbstract(modifiers)) continue;
            makeTargetTypeAbstract = true;
        }
        if (makeTargetTypeAbstract && !Modifier.isAbstract(this.refactoring.getTargetType().getModifiers()) && !this.refactoring.getTargetType().isInterface()) {
            refactoringElements.add(this.refactoring, new ChangeModElement((Feature)this.refactoring.getTargetType(), this.refactoring.getTargetType().getModifiers() | 0x400));
        }
        UndoWatcher.watch(((JMManager)JMManager.getManager()).getDataObject(this.refactoring.getTargetType().getResource()));
        return null;
    }

    private static boolean hasMembers(JavaClass sourceType, JavaClass[] supertypes) {
        boolean result = Utilities.hasMembers(sourceType);
        for (int i = 0; i < supertypes.length - 1 && !result; ++i) {
            result = Utilities.hasMembers(supertypes[i]);
        }
        return result;
    }

    private Problem checkUsedByElement(Element element, Set allMembers, Problem problems, boolean resourceChange, boolean packageChange) {
        NamedElement referencedElement;
        if (!(element instanceof MultipartId) && (element instanceof MethodInvocation || element instanceof NewClassExpression || element instanceof VariableAccess) && (referencedElement = ((ElementReference)element).getElement()) instanceof Feature) {
            boolean isSameInstance;
            Feature referencedFeature = (Feature)referencedElement;
            int modifiers = referencedFeature.getModifiers();
            ClassDefinition declClass = referencedFeature.getDeclaringClass();
            Object parentClass = element instanceof VariableAccess ? ((VariableAccess)element).getParentClass() : (element instanceof MethodInvocation ? ((MethodInvocation)element).getParentClass() : (declClass instanceof JavaClass && !Modifier.isStatic(((JavaClass)declClass).getModifiers()) ? ((NewClassExpression)element).getEnclosingClass() : null));
            boolean bl = isSameInstance = parentClass == null || parentClass instanceof ThisExpression;
            if (Modifier.isPrivate(modifiers)) {
                if (resourceChange || isSameInstance) {
                    problems = PullUpRefactoringPlugin.createProblem(problems, false, "will not be accessible");
                }
            } else if (packageChange && !Modifier.isPublic(modifiers)) {
                if (!Modifier.isProtected(modifiers) || referencedElement instanceof Method) {
                    // empty if block
                }
                problems = PullUpRefactoringPlugin.createProblem(problems, false, "will not be accessible - is protected/package private");
            }
        }
        Iterator it = element.getChildren().iterator();
        while (it.hasNext()) {
            problems = this.checkUsedByElement((Element)it.next(), allMembers, problems, resourceChange, packageChange);
        }
        return problems;
    }

    private static class MoveMemberElement
    extends SimpleRefactoringElementImpl {
        private final NamedElement elementToMove;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        MoveMemberElement(NamedElement elementToMove, JavaClass target, int newModifiers) {
            this.elementToMove = elementToMove;
            this.target = target;
            this.newModifiers = newModifiers;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin = PullUpRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PullUpRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin), (String)"TXT_PullUp_Member", (Object)UIUtilities.getDisplayText(elementToMove));
        }

        public void performChange() {
            Element newElement;
            JavaModelPackage targetExtent = (JavaModelPackage)this.target.refImmediatePackage();
            boolean deleteElementToMove = false;
            if (this.elementToMove instanceof Feature) {
                JavaClass elementParent = (JavaClass)((Feature)this.elementToMove).getDeclaringClass();
                if (targetExtent.equals(elementParent.refImmediatePackage())) {
                    elementParent.getFeatures().remove(this.elementToMove);
                    newElement = this.elementToMove;
                } else {
                    newElement = ((MetadataElement)this.elementToMove).duplicate(targetExtent);
                    deleteElementToMove = true;
                }
                this.target.getContents().add(newElement);
                if (this.newModifiers != 0) {
                    ((Feature)newElement).setModifiers(this.newModifiers);
                }
            } else {
                JavaClass elementParent = (JavaClass)this.elementToMove.refImmediateComposite();
                if (targetExtent.equals(elementParent.refImmediatePackage())) {
                    elementParent.getInterfaceNames().remove(this.elementToMove);
                    newElement = this.elementToMove;
                } else {
                    newElement = ((MetadataElement)this.elementToMove).duplicate(targetExtent);
                    deleteElementToMove = true;
                }
                this.target.getInterfaceNames().add(newElement);
            }
            ((MetadataElement)newElement).fixImports((Element)this.target, (Element)this.elementToMove);
            if (deleteElementToMove) {
                this.elementToMove.refDelete();
            }
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.elementToMove.getResource());
        }

        public Element getJavaElement() {
            return JavaModelUtil.getDeclaringFeature((Element)this.elementToMove);
        }

        public PositionBounds getPosition() {
            return JavaMetamodel.getManager().getElementPosition((Element)this.elementToMove);
        }
    }

    private static class AddAbstractMethodElement
    extends SimpleRefactoringElementImpl {
        private final Method methodToAdd;
        private final JavaClass target;
        private final int newModifiers;
        private final String text;

        AddAbstractMethodElement(Method methodToAdd, JavaClass target, int newModifiers) {
            this.methodToAdd = methodToAdd;
            this.target = target;
            this.newModifiers = newModifiers;
            this.text = NbBundle.getMessage((Class)(class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin == null ? (class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin = PullUpRefactoringPlugin.class$("org.netbeans.modules.refactoring.plugins.PullUpRefactoringPlugin")) : class$org$netbeans$modules$refactoring$plugins$PullUpRefactoringPlugin), (String)"TXT_PullUp_AddMethod", (Object)UIUtilities.getDisplayText((NamedElement)methodToAdd));
        }

        public void performChange() {
            JavaModelPackage extent = (JavaModelPackage)this.target.refImmediatePackage();
            Method newMethod = extent.getMethod().createMethod(this.methodToAdd.getName(), Utilities.duplicateList(this.methodToAdd.getAnnotations(), extent), (this.newModifiers == 0 ? this.methodToAdd.getModifiers() : this.newModifiers) | 0x400, this.methodToAdd.getJavadocText(), null, null, null, Utilities.duplicateList(this.methodToAdd.getTypeParameters(), extent), Utilities.duplicateList(this.methodToAdd.getParameters(), extent), Utilities.duplicateList(this.methodToAdd.getExceptionNames(), extent), (TypeReference)((MetadataElement)this.methodToAdd.getTypeName()).duplicate(extent), this.methodToAdd.getDimCount());
            if (this.target.isInterface()) {
                newMethod.setModifiers(newMethod.getModifiers() & 0xFFFFFBFF & 0xFFFFFFFE & 0xFFFFFFFB & 0xFFFFFFFD);
            }
            this.target.getContents().add(newMethod);
        }

        public String getText() {
            return this.text;
        }

        public String getDisplayText() {
            return this.text;
        }

        public FileObject getParentFile() {
            return JavaMetamodel.getManager().getFileObject(this.target.getResource());
        }

        public Element getJavaElement() {
            return this.target;
        }

        public PositionBounds getPosition() {
            return null;
        }
    }
}

