/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.clazz;

import java.io.IOException;
import org.netbeans.modules.clazz.ClassDataObject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.FileEntry;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;

public final class ClassDataLoader
extends MultiFileLoader {
    private static final String SER_EXT = "ser";
    private static final String CLASS_EXT = "class";
    private static final String REPRESENTATION_CLASS_NAME = "org.netbeans.modules.clazz.ClassDataObject";
    private static final char INNER_CLASS_DIVIDER = '$';
    private static ExtensionList extensions;
    static final long serialVersionUID = 3149080169747384034L;

    public ClassDataLoader() {
        super(REPRESENTATION_CLASS_NAME);
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage((Class)ClassDataLoader.class, (String)"PROP_ClassLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/application/x-java-class/Actions/";
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (SER_EXT.equals(fo.getExt())) {
            try {
                return fo.getFileSystem() != Repository.getDefault().getDefaultFileSystem() ? fo : null;
            }
            catch (FileStateInvalidException ex) {
                return null;
            }
        }
        if (CLASS_EXT.equals(fo.getExt())) {
            return this.findPrimaryForClass(fo);
        }
        return null;
    }

    protected MultiDataObject createMultiObject(FileObject primaryFile) throws DataObjectExistsException, IOException {
        if (SER_EXT.equals(primaryFile.getExt())) {
            return ClassDataObject.createSerDataObject(primaryFile, this);
        }
        if (CLASS_EXT.equals(primaryFile.getExt())) {
            return ClassDataObject.createCompiledDataObject(primaryFile, this);
        }
        return null;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new FileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new FileEntry(obj, secondaryFile);
    }

    private FileObject findPrimaryForClass(FileObject fo) {
        FileObject outer;
        String name = fo.getName();
        int index = name.indexOf(36);
        if (index > 0 && (outer = fo.getParent().getFileObject(name.substring(0, index), CLASS_EXT)) != null) {
            return outer;
        }
        return fo;
    }

    public ExtensionList getExtensions() {
        if (extensions == null) {
            extensions = new ExtensionList();
            extensions.addExtension(CLASS_EXT);
            extensions.addExtension(SER_EXT);
        }
        return extensions;
    }
}

