/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.RootPaneContainer;
import org.netbeans.core.startup.ManifestSection;
import org.openide.ErrorManager;
import org.openide.actions.ActionManager;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.actions.SystemAction;

public class ModuleActions
extends ActionManager {
    private static SystemAction[] array;
    private static Map map;
    private static Object module;
    private Map runningActions = new HashMap();
    private static final ErrorManager err;
    private static final Map glassPaneUses;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static ModuleActions getDefaultInstance() {
        ActionManager mgr = ActionManager.getDefault();
        if (!$assertionsDisabled && !(mgr instanceof ModuleActions)) {
            throw new AssertionError((Object)("Got wrong ActionManager instance: " + mgr + " from " + Lookup.getDefault()));
        }
        return (ModuleActions)mgr;
    }

    public SystemAction[] getContextActions() {
        SystemAction[] a = array;
        if (a != null) {
            return a;
        }
        array = a = ModuleActions.createActions();
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invokeAction(Action a, final ActionEvent e) {
        try {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    ModuleActions.showWaitCursor(e);
                }
            });
            this.addRunningAction(a, e);
            a.actionPerformed(e);
            this.removeRunningAction(e);
        }
        catch (Throwable throwable) {
            this.removeRunningAction(e);
            Mutex.EVENT.readAccess(new Runnable(e){
                private final /* synthetic */ ActionEvent val$e;
                {
                    this.val$e = actionEvent;
                }

                public void run() {
                    ModuleActions.hideWaitCursor(this.val$e);
                }
            });
            throw throwable;
        }
        Mutex.EVENT.readAccess(new /* invalid duplicate definition of identical inner class */);
    }

    private void fireChange() {
        this.firePropertyChange("contextActions", null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRunningAction(Action action, ActionEvent evt) {
        Map map = this.runningActions;
        synchronized (map) {
            this.runningActions.put(evt, action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeRunningAction(ActionEvent evt) {
        Map map = this.runningActions;
        synchronized (map) {
            this.runningActions.remove(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getRunningActions() {
        Map map = this.runningActions;
        synchronized (map) {
            return new ArrayList(this.runningActions.values());
        }
    }

    public static synchronized void attachTo(Object m) {
        module = m;
    }

    public static synchronized void add(ManifestSection.ActionSection a) {
        ArrayList<ManifestSection.ActionSection> list = (ArrayList<ManifestSection.ActionSection>)map.get(module);
        if (list == null) {
            list = new ArrayList<ManifestSection.ActionSection>();
            map.put(module, list);
        }
        list.add(a);
        array = null;
        ModuleActions.getDefaultInstance().fireChange();
    }

    public static synchronized void remove(ManifestSection.ActionSection a) {
        List list = (List)map.get(module);
        if (list == null) {
            return;
        }
        list.remove(a);
        if (list.isEmpty()) {
            map.remove(module);
        }
        array = null;
        ModuleActions.getDefaultInstance().fireChange();
    }

    private static synchronized SystemAction[] createActions() {
        Iterator it = map.values().iterator();
        ArrayList<Object> arr = new ArrayList<Object>(map.size() * 5);
        while (it.hasNext()) {
            List l = (List)it.next();
            Iterator actions = l.iterator();
            while (actions.hasNext()) {
                ManifestSection.ActionSection s = (ManifestSection.ActionSection)actions.next();
                try {
                    arr.add(s.getInstance());
                }
                catch (Exception ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
            if (!it.hasNext()) continue;
            arr.add(null);
        }
        return arr.toArray(new SystemAction[arr.size()]);
    }

    private static Component activeGlassPane() {
        Window w = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        if (w instanceof RootPaneContainer) {
            return ((RootPaneContainer)((Object)w)).getGlassPane();
        }
        return null;
    }

    public static void showWaitCursor(Object key) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && glassPaneUses.containsKey(key)) {
            throw new AssertionError();
        }
        Component c = ModuleActions.activeGlassPane();
        if (c == null) {
            if (err.isLoggable(16)) {
                err.log(16, "showWaitCursor could not find a suitable glass pane; key=" + key);
            }
            return;
        }
        if (glassPaneUses.values().contains(c)) {
            if (err.isLoggable(1)) {
                err.log("wait cursor already displayed on " + c);
            }
        } else {
            if (err.isLoggable(1)) {
                err.log("wait cursor will be displayed on " + c);
            }
            c.setCursor(Utilities.createProgressCursor((Component)c));
            c.setVisible(true);
        }
        glassPaneUses.put(key, c);
    }

    public static void hideWaitCursor(Object key) {
        if (!$assertionsDisabled && !EventQueue.isDispatchThread()) {
            throw new AssertionError();
        }
        Component c = (Component)glassPaneUses.get(key);
        if (c == null) {
            return;
        }
        glassPaneUses.remove(key);
        if (glassPaneUses.values().contains(c)) {
            if (err.isLoggable(1)) {
                err.log("wait cursor still displayed on " + c);
            }
        } else {
            if (err.isLoggable(1)) {
                err.log("wait cursor will be hidden on " + c);
            }
            c.setVisible(false);
            c.setCursor(null);
        }
    }

    static {
        $assertionsDisabled = !ModuleActions.class.desiredAssertionStatus();
        map = new HashMap(7);
        module = null;
        err = ErrorManager.getDefault().getInstance("org.openide.util.actions.MouseCursorUtils");
        glassPaneUses = new HashMap();
    }
}

