/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.DragManager;
import org.netbeans.modules.apisupport.project.ui.customizer.NbPropertyPanel;
import org.netbeans.modules.apisupport.project.ui.customizer.SplashComponentPreview;
import org.netbeans.modules.apisupport.project.ui.customizer.SplashUISupport;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.openide.ErrorManager;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class SuiteCustomizerSplashBranding
extends NbPropertyPanel.Suite {
    private SplashComponentPreview splashImage;
    private JFormattedTextField fontSize;
    private JFormattedTextField runningTextBounds;
    private JFormattedTextField progressBarBounds;
    private SplashUISupport.ColorComboBox textColor;
    private SplashUISupport.ColorComboBox barColor;
    private SplashUISupport.ColorComboBox edgeColor;
    private SplashUISupport.ColorComboBox cornerColor;
    private URL splashSource;
    private JLabel barBoundsLabel;
    private JLabel barColorLabel;
    private JButton browse;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JCheckBox progressBarEnabled;
    private JLabel splashLabel;
    private JLabel splashPreview;
    private JLabel textBoundsLabel;
    private JLabel textColorLabel;
    private JLabel textFontSizeLabel;

    public SuiteCustomizerSplashBranding(SuiteProperties suiteProps) {
        super(suiteProps, SuiteCustomizerSplashBranding.class);
        BasicBrandingModel branding = this.getBrandingModel();
        branding.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                SuiteCustomizerSplashBranding.this.enableDisableComponents();
            }
        });
        this.splashImage = new SplashComponentPreview();
        this.fontSize = SplashUISupport.getIntegerField();
        this.runningTextBounds = SplashUISupport.getBoundsField();
        this.progressBarBounds = SplashUISupport.getBoundsField();
        this.textColor = SplashUISupport.getColorComboBox();
        this.barColor = SplashUISupport.getColorComboBox();
        this.edgeColor = SplashUISupport.getColorComboBox();
        this.cornerColor = SplashUISupport.getColorComboBox();
        this.splashImage.setDropHandletForProgress(new DragManager.DropHandler(){

            public void dragAccepted(Rectangle original, Rectangle afterDrag) {
                SuiteCustomizerSplashBranding.this.progressBarBounds.setValue(afterDrag);
            }
        });
        this.splashImage.setDropHandletForText(new DragManager.DropHandler(){

            public void dragAccepted(Rectangle original, Rectangle afterDrag) {
                SuiteCustomizerSplashBranding.this.runningTextBounds.setValue(afterDrag);
                double ratio = (double)afterDrag.height / (double)original.height;
                int size = (int)((double)((Number)SuiteCustomizerSplashBranding.this.fontSize.getValue()).intValue() * ratio);
                size = size > 0 ? size : 3;
                SuiteCustomizerSplashBranding.this.fontSize.setValue(new Integer(size));
            }
        });
        this.initComponents();
        this.refresh();
        PropertyChangeListener pL = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() != "color") {
                    return;
                }
                SuiteCustomizerSplashBranding.this.resetSplashPreview();
            }
        };
        this.textColor.addPropertyChangeListener(pL);
        this.barColor.addPropertyChangeListener(pL);
        this.edgeColor.addPropertyChangeListener(pL);
        this.cornerColor.addPropertyChangeListener(pL);
        this.fontSize.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (e != null || SuiteCustomizerSplashBranding.this.fontSize.isFocusOwner()) {
                    try {
                        SuiteCustomizerSplashBranding.this.fontSize.commitEdit();
                        ((Number)SuiteCustomizerSplashBranding.this.fontSize.getValue()).intValue();
                        SuiteCustomizerSplashBranding.this.setErrorMessage(null);
                        SuiteCustomizerSplashBranding.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SuiteCustomizerSplashBranding.this.setErrorMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding = SuiteCustomizerSplashBranding.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerSplashBranding")) : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding), (String)"ERR_InvalidFontSize"));
                    }
                }
            }
        });
        this.runningTextBounds.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (e != null || SuiteCustomizerSplashBranding.this.runningTextBounds.isFocusOwner()) {
                    try {
                        SuiteCustomizerSplashBranding.this.runningTextBounds.commitEdit();
                        SuiteCustomizerSplashBranding.this.setErrorMessage(null);
                        SuiteCustomizerSplashBranding.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SuiteCustomizerSplashBranding.this.setErrorMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding = SuiteCustomizerSplashBranding.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerSplashBranding")) : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding), (String)"ERR_InvalidTextBounds"));
                    }
                }
            }
        });
        this.progressBarBounds.getDocument().addDocumentListener(new UIUtil.DocumentAdapter(){

            public void insertUpdate(DocumentEvent e) {
                if (e != null || SuiteCustomizerSplashBranding.this.progressBarBounds.isFocusOwner()) {
                    try {
                        SuiteCustomizerSplashBranding.this.progressBarBounds.commitEdit();
                        SuiteCustomizerSplashBranding.this.setErrorMessage(null);
                        SuiteCustomizerSplashBranding.this.resetSplashPreview();
                    }
                    catch (ParseException ex) {
                        SuiteCustomizerSplashBranding.this.setErrorMessage(NbBundle.getMessage((Class)(class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding == null ? (class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding = SuiteCustomizerSplashBranding.class$("org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerSplashBranding")) : class$org$netbeans$modules$apisupport$project$ui$customizer$SuiteCustomizerSplashBranding), (String)"ERR_InvalidProgressBarBounds"));
                    }
                }
            }
        });
    }

    public void store() {
        BasicBrandingModel branding = this.getBrandingModel();
        branding.getSplashRunningTextFontSize().setValue(SplashUISupport.integerToString(((Number)this.fontSize.getValue()).intValue()));
        branding.getSplashRunningTextBounds().setValue(SplashUISupport.boundsToString((Rectangle)this.runningTextBounds.getValue()));
        branding.getSplashProgressBarBounds().setValue(SplashUISupport.boundsToString((Rectangle)this.progressBarBounds.getValue()));
        branding.getSplashRunningTextColor().setValue(SplashUISupport.colorToString(this.textColor.getColor()));
        branding.getSplashProgressBarColor().setValue(SplashUISupport.colorToString(this.barColor.getColor()));
        branding.getSplashShowProgressBar().setValue(Boolean.toString(this.progressBarEnabled.isSelected()));
        branding.getSplash().setBrandingSource(this.splashSource);
        branding.getSplashWidth().setValue(Integer.toString(this.splashImage.image.getWidth(null), 10));
        branding.getSplashHeight().setValue(Integer.toString(this.splashImage.image.getHeight(null), 10));
    }

    void refresh() {
        BasicBrandingModel branding = this.getBrandingModel();
        this.fontSize.setValue(new Integer(SplashUISupport.stringToInteger(branding.getSplashRunningTextFontSize().getValue())));
        this.runningTextBounds.setValue(SplashUISupport.stringToBounds(branding.getSplashRunningTextBounds().getValue()));
        this.progressBarBounds.setValue(SplashUISupport.stringToBounds(branding.getSplashProgressBarBounds().getValue()));
        this.textColor.setColor(SplashUISupport.stringToColor(branding.getSplashRunningTextColor().getValue()));
        this.barColor.setColor(SplashUISupport.stringToColor(branding.getSplashProgressBarColor().getValue()));
        this.edgeColor.setColor(SplashUISupport.stringToColor(branding.getSplashProgressBarEdgeColor().getValue()));
        this.cornerColor.setColor(SplashUISupport.stringToColor(branding.getSplashProgressBarCornerColor().getValue()));
        this.progressBarEnabled.setSelected(this.getBrandingModel().getSplashShowProgressBar().getValue().trim().toLowerCase(Locale.ENGLISH).equals("true"));
        this.splashSource = this.getBrandingModel().getSplash().getBrandingSource();
        this.resetSplashPreview();
        this.splashImage.setMaxSteps(10);
        this.splashImage.resetSteps();
        this.splashImage.setText(NbBundle.getMessage(this.getClass(), (String)"TEXT_SplashSample"));
        this.enableDisableComponents();
    }

    private void enableDisableComponents() {
        BasicBrandingModel branding = this.getBrandingModel();
        this.jLabel1.setEnabled(branding.isBrandingEnabled());
        this.jLabel2.setEnabled(branding.isBrandingEnabled());
        this.fontSize.setEnabled(branding.isBrandingEnabled());
        this.runningTextBounds.setEnabled(branding.isBrandingEnabled());
        this.progressBarBounds.setEnabled(branding.isBrandingEnabled());
        this.textColor.setEnabled(branding.isBrandingEnabled());
        this.barColor.setEnabled(branding.isBrandingEnabled());
        this.edgeColor.setEnabled(branding.isBrandingEnabled());
        this.cornerColor.setEnabled(branding.isBrandingEnabled());
        this.progressBarEnabled.setEnabled(branding.isBrandingEnabled());
        this.splashImage.setEnabled(branding.isBrandingEnabled());
        this.barBoundsLabel.setEnabled(branding.isBrandingEnabled());
        this.barColorLabel.setEnabled(branding.isBrandingEnabled());
        this.browse.setEnabled(branding.isBrandingEnabled());
        this.splashLabel.setEnabled(branding.isBrandingEnabled());
        this.splashPreview.setEnabled(branding.isBrandingEnabled());
        this.textBoundsLabel.setEnabled(branding.isBrandingEnabled());
        this.textColorLabel.setEnabled(branding.isBrandingEnabled());
        this.textFontSizeLabel.setEnabled(branding.isBrandingEnabled());
        this.splashImage.setEnabled(branding.isBrandingEnabled());
    }

    private void resetSplashPreview() throws NumberFormatException {
        this.splashImage.setSplashImageIcon(this.splashSource);
        Rectangle tRectangle = (Rectangle)this.runningTextBounds.getValue();
        Rectangle pRectangle = (Rectangle)this.progressBarBounds.getValue();
        this.splashImage.setTextColor(this.textColor.getColor());
        this.splashImage.setColorBar(this.barColor.getColor());
        this.splashImage.setColorEdge(this.edgeColor.getColor());
        this.splashImage.setColorEdge(this.cornerColor.getColor());
        this.splashImage.setFontSize(((Number)this.fontSize.getValue()).intValue());
        this.splashImage.setRunningTextBounds(tRectangle);
        this.splashImage.setProgressBarBounds(pRectangle);
        this.splashImage.setProgressBarEnabled(this.progressBarEnabled.isSelected());
        this.splashImage.resetSteps();
        this.splashImage.setText(NbBundle.getMessage(this.getClass(), (String)"TEXT_SplashSample"));
    }

    private void initComponents() {
        SplashUISupport.ColorComboBox barColor = this.barColor;
        JFormattedTextField jTextField1 = this.progressBarBounds;
        this.barColorLabel = new JLabel();
        this.barBoundsLabel = new JLabel();
        this.textColorLabel = new JLabel();
        SplashUISupport.ColorComboBox textColor = this.textColor;
        JFormattedTextField jTextField4 = this.runningTextBounds;
        JFormattedTextField fontSize = this.fontSize;
        this.progressBarEnabled = new JCheckBox();
        this.textFontSizeLabel = new JLabel();
        this.textBoundsLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.splashLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.splashPreview = this.splashImage;
        this.browse = new JButton();
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)barColor, gridBagConstraints);
        jTextField1.setInputVerifier(jTextField1.getInputVerifier());
        jTextField1.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jTextField1, gridBagConstraints);
        this.barColorLabel.setLabelFor(barColor);
        Mnemonics.setLocalizedText((JLabel)this.barColorLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_BarColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.barColorLabel, gridBagConstraints);
        this.barColorLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_BarColor"));
        this.barBoundsLabel.setLabelFor(jTextField1);
        Mnemonics.setLocalizedText((JLabel)this.barBoundsLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_BarBounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.barBoundsLabel, gridBagConstraints);
        this.barBoundsLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_BarBounds"));
        this.textColorLabel.setLabelFor(textColor);
        Mnemonics.setLocalizedText((JLabel)this.textColorLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_TextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textColorLabel, gridBagConstraints);
        this.textColorLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_TextColor"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)textColor, gridBagConstraints);
        jTextField4.setInputVerifier(jTextField1.getInputVerifier());
        jTextField4.setVerifyInputWhenFocusTarget(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)jTextField4, gridBagConstraints);
        fontSize.setInputVerifier(jTextField1.getInputVerifier());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.add((Component)fontSize, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.progressBarEnabled, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_ProgressBarEnabled"));
        this.progressBarEnabled.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.progressBarEnabled.setMargin(new Insets(0, 0, 0, 0));
        this.progressBarEnabled.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerSplashBranding.this.progressBarEnabledActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 1, 0, 12);
        this.add((Component)this.progressBarEnabled, gridBagConstraints);
        this.progressBarEnabled.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_ProgressEnabled"));
        this.textFontSizeLabel.setLabelFor(fontSize);
        Mnemonics.setLocalizedText((JLabel)this.textFontSizeLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_TextFontSize"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textFontSizeLabel, gridBagConstraints);
        this.textFontSizeLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_FontSize"));
        this.textBoundsLabel.setLabelFor(jTextField4);
        Mnemonics.setLocalizedText((JLabel)this.textBoundsLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_TextBounds"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.add((Component)this.textBoundsLabel, gridBagConstraints);
        this.textBoundsLabel.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_TextBounds"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_ProgressBar"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jLabel1, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_RunningText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.splashLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_Splash"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.splashLabel, gridBagConstraints);
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setViewportView(this.splashPreview);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 20;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 12);
        this.jPanel1.add((Component)this.jScrollPane1, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.browse, (String)ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("LBL_Browse"));
        this.browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SuiteCustomizerSplashBranding.this.browseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.jPanel1.add((Component)this.browse, gridBagConstraints);
        this.browse.getAccessibleContext().setAccessibleDescription(ResourceBundle.getBundle("org/netbeans/modules/apisupport/project/ui/customizer/Bundle").getString("ACS_SplashBrowse"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void browseActionPerformed(ActionEvent evt) {
        JFileChooser chooser = UIUtil.getIconFileChooser();
        int ret = chooser.showDialog(this, NbBundle.getMessage(this.getClass(), (String)"LBL_Select"));
        if (ret == 0) {
            File file = chooser.getSelectedFile();
            try {
                this.splashSource = file.toURI().toURL();
                Image oldImage = this.splashImage.image;
                this.splashImage.setSplashImageIcon(this.splashSource);
                Image newImage = this.splashImage.image;
                int newWidth = newImage.getWidth(null);
                int newHeight = newImage.getHeight(null);
                int oldWidth = oldImage.getWidth(null);
                int oldHeight = oldImage.getHeight(null);
                if (newWidth != oldWidth || newHeight != oldHeight) {
                    double xRatio = (double)newWidth / (double)oldWidth;
                    double yRatio = (double)newHeight / (double)oldHeight;
                    Rectangle tRectangle = (Rectangle)this.runningTextBounds.getValue();
                    Rectangle pRectangle = (Rectangle)this.progressBarBounds.getValue();
                    int x = (int)((double)tRectangle.x * xRatio);
                    int y = (int)((double)tRectangle.y * yRatio);
                    int width = (int)((double)tRectangle.width * xRatio);
                    int height = (int)((double)tRectangle.height * xRatio);
                    width = width <= 0 ? 2 : width;
                    height = height <= 0 ? 2 : height;
                    tRectangle.setBounds(x, y, width, height);
                    x = (int)((double)pRectangle.x * xRatio);
                    y = (int)((double)pRectangle.y * yRatio);
                    width = (int)((double)pRectangle.width * xRatio);
                    height = (int)((double)pRectangle.height * xRatio);
                    width = width <= 6 ? 6 : width;
                    height = height <= 6 ? 6 : height;
                    pRectangle.setBounds(x, y, width, height);
                    this.runningTextBounds.setValue(tRectangle);
                    this.progressBarBounds.setValue(pRectangle);
                    int size = (int)((double)((Number)this.fontSize.getValue()).intValue() * yRatio);
                    size = size <= 6 ? 6 : size;
                    this.fontSize.setValue(new Integer(size));
                } else {
                    this.resetSplashPreview();
                }
            }
            catch (MalformedURLException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
    }

    private void progressBarEnabledActionPerformed(ActionEvent evt) {
        this.resetSplashPreview();
    }

    private BasicBrandingModel getBrandingModel() {
        return this.getProperties().getBrandingModel();
    }
}

