/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleTypeProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public final class ProjectXMLManager {
    private static final String PROJECT_NS = "http://www.netbeans.org/ns/project/1";
    private static final String BINARY_ORIGIN = "binary-origin";
    private static final String BUILD_PREREQUISITE = "build-prerequisite";
    private static final String CLASS_PATH_BINARY_ORIGIN = "binary-origin";
    private static final String CLASS_PATH_EXTENSION = "class-path-extension";
    private static final String CLASS_PATH_RUNTIME_PATH = "runtime-relative-path";
    private static final String CODE_NAME_BASE = "code-name-base";
    private static final String COMPILE_DEPENDENCY = "compile-dependency";
    private static final String DATA = "data";
    private static final String DEPENDENCY = "dependency";
    private static final String EXTRA_COMPILATION_UNIT = "extra-compilation-unit";
    private static final String FRIEND = "friend";
    private static final String FRIEND_PACKAGES = "friend-packages";
    private static final String IMPLEMENTATION_VERSION = "implementation-version";
    private static final String MODULE_DEPENDENCIES = "module-dependencies";
    private static final String PACKAGE = "package";
    private static final String PUBLIC_PACKAGES = "public-packages";
    private static final String RELEASE_VERSION = "release-version";
    private static final String RUN_DEPENDENCY = "run-dependency";
    private static final String SPECIFICATION_VERSION = "specification-version";
    private static final String STANDALONE = "standalone";
    private static final String SUBPACKAGES = "subpackages";
    private static final String SUITE_COMPONENT = "suite-component";
    private final NbModuleProject project;
    private NbPlatform customPlaf;
    private String cnb;
    private SortedSet directDeps;
    private ManifestManager.PackageExport[] publicPackages;
    private String[] cpExtensions;
    private String[] friends;
    private Element confData;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ProjectXMLManager(NbModuleProject project) {
        this.project = project;
    }

    public static ProjectXMLManager getInstance(File projectDir) throws IOException {
        FileObject dir = FileUtil.toFileObject((File)projectDir);
        NbModuleProject p = (NbModuleProject)ProjectManager.getDefault().findProject(dir);
        return new ProjectXMLManager(p);
    }

    public void setModuleType(NbModuleTypeProvider.NbModuleType moduleType) {
        Element newModuleType;
        Element confData = this.getConfData();
        Document doc = confData.getOwnerDocument();
        Element standaloneEl = ProjectXMLManager.findElement(confData, STANDALONE);
        if (standaloneEl != null && moduleType == NbModuleTypeProvider.STANDALONE) {
            return;
        }
        Element suiteCompEl = ProjectXMLManager.findElement(confData, SUITE_COMPONENT);
        if (suiteCompEl != null && moduleType == NbModuleTypeProvider.SUITE_COMPONENT) {
            return;
        }
        if (suiteCompEl == null && standaloneEl == null && moduleType == NbModuleTypeProvider.NETBEANS_ORG) {
            return;
        }
        if (suiteCompEl != null) {
            confData.removeChild(suiteCompEl);
        }
        if (standaloneEl != null) {
            confData.removeChild(standaloneEl);
        }
        if ((newModuleType = ProjectXMLManager.createTypeElement(doc, moduleType)) != null) {
            confData.insertBefore(newModuleType, ProjectXMLManager.findModuleDependencies(confData));
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
    }

    public SortedSet getDirectDependencies() throws IOException {
        return this.getDirectDependencies(null);
    }

    public SortedSet getDirectDependencies(NbPlatform customPlaf) throws IOException {
        if (this.customPlaf == customPlaf && this.directDeps != null) {
            return this.directDeps;
        }
        this.customPlaf = customPlaf;
        TreeSet<ModuleDependency> directDeps = new TreeSet<ModuleDependency>(ModuleDependency.CNB_COMPARATOR);
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(this.getConfData());
        if (!$assertionsDisabled && moduleDependencies == null) {
            throw new AssertionError((Object)("Cannot find <module-dependencies> for: " + this.project));
        }
        List deps = Util.findSubElements(moduleDependencies);
        ModuleList ml = customPlaf != null ? this.project.getModuleList() : ModuleList.getModuleList(FileUtil.toFile((FileObject)this.project.getProjectDirectory()));
        Iterator it = deps.iterator();
        while (it.hasNext()) {
            Element impleVerEl;
            Element compDepEl;
            ModuleDependency depToAdd;
            Element depEl = (Element)it.next();
            Element cnbEl = ProjectXMLManager.findElement(depEl, CODE_NAME_BASE);
            String cnb = Util.findText(cnbEl);
            ModuleEntry me = ml.getEntry(cnb);
            if (me == null) {
                Util.err.log(16, "Detected dependency on module which cannot be found in the current module's universe (platform, suite): " + cnb + " (skipping)");
                continue;
            }
            Element runDepEl = ProjectXMLManager.findElement(depEl, RUN_DEPENDENCY);
            if (runDepEl == null) {
                if (directDeps.add(new ModuleDependency(me))) continue;
                String errMessage = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + me;
                Util.err.log(16, errMessage);
                throw new IllegalStateException(errMessage);
            }
            Element relVerEl = ProjectXMLManager.findElement(runDepEl, RELEASE_VERSION);
            String relVer = null;
            if (relVerEl != null) {
                relVer = Util.findText(relVerEl);
            }
            Element specVerEl = ProjectXMLManager.findElement(runDepEl, SPECIFICATION_VERSION);
            String specVer = null;
            if (specVerEl != null) {
                specVer = Util.findText(specVerEl);
            }
            if (directDeps.add(depToAdd = new ModuleDependency(me, relVer, specVer, (compDepEl = ProjectXMLManager.findElement(depEl, COMPILE_DEPENDENCY)) != null, (impleVerEl = ProjectXMLManager.findElement(runDepEl, IMPLEMENTATION_VERSION)) != null))) continue;
            String errMessage = "Corrupted project metadata (project.xml). Duplicate dependency entry found: " + depToAdd;
            Util.err.log(16, errMessage);
            throw new IllegalStateException(errMessage);
        }
        this.directDeps = Collections.unmodifiableSortedSet(directDeps);
        return this.directDeps;
    }

    public void removeDependency(String cnbToRemove) {
        Element confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(confData);
        List currentDeps = Util.findSubElements(moduleDependencies);
        Iterator it = currentDeps.iterator();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            Element cnbEl = ProjectXMLManager.findElement(dep, CODE_NAME_BASE);
            String cnb = Util.findText(cnbEl);
            if (!cnbToRemove.equals(cnb)) continue;
            moduleDependencies.removeChild(dep);
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
    }

    public void removeDependencies(Collection depsToDelete) {
        HashSet<String> cnbsToDelete = new HashSet<String>(depsToDelete.size());
        Iterator it = depsToDelete.iterator();
        while (it.hasNext()) {
            cnbsToDelete.add(((ModuleDependency)it.next()).getModuleEntry().getCodeNameBase());
        }
        this.removeDependenciesByCNB(cnbsToDelete);
    }

    public void removeDependenciesByCNB(Collection cnbsToDelete) {
        Element confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(confData);
        List currentDeps = Util.findSubElements(moduleDependencies);
        Iterator it = currentDeps.iterator();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            Element cnbEl = ProjectXMLManager.findElement(dep, CODE_NAME_BASE);
            String cnb = Util.findText(cnbEl);
            if (cnbsToDelete.remove(cnb)) {
                moduleDependencies.removeChild(dep);
            }
            if (cnbsToDelete.size() != 0) continue;
            break;
        }
        if (cnbsToDelete.size() != 0) {
            Util.err.log(16, "Some modules weren't deleted: " + cnbsToDelete);
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
    }

    public void editDependency(ModuleDependency origDep, ModuleDependency newDep) {
        Element confData = this.getConfData();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(confData);
        List currentDeps = Util.findSubElements(moduleDependencies);
        Iterator it = currentDeps.iterator();
        while (it.hasNext()) {
            Element dep = (Element)it.next();
            Element cnbEl = ProjectXMLManager.findElement(dep, CODE_NAME_BASE);
            String cnb = Util.findText(cnbEl);
            if (!cnb.equals(origDep.getModuleEntry().getCodeNameBase())) continue;
            moduleDependencies.removeChild(dep);
            Element nextDep = it.hasNext() ? (Element)it.next() : null;
            ProjectXMLManager.createModuleDependencyElement(moduleDependencies, newDep, nextDep);
            break;
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
    }

    public void addDependency(ModuleDependency md) throws IOException {
        this.addDependencies(Collections.singleton(md));
    }

    public void addDependencies(Set toAdd) throws IOException {
        TreeSet deps = new TreeSet(this.getDirectDependencies());
        if (deps.addAll(toAdd)) {
            this.replaceDependencies(deps);
        }
    }

    public void replaceDependencies(Set newDeps) {
        Element confData = this.getConfData();
        Document doc = confData.getOwnerDocument();
        Element moduleDependencies = ProjectXMLManager.findModuleDependencies(confData);
        confData.removeChild(moduleDependencies);
        moduleDependencies = ProjectXMLManager.createModuleElement(doc, MODULE_DEPENDENCIES);
        Element before = ProjectXMLManager.findPublicPackagesElement(confData);
        if (before == null) {
            before = ProjectXMLManager.findFriendsElement(confData);
        }
        if (!$assertionsDisabled && before == null) {
            throw new AssertionError((Object)"There must be public-packages or friend-packages element according to XSD");
        }
        confData.insertBefore(moduleDependencies, before);
        TreeSet sortedDeps = new TreeSet(newDeps);
        Iterator it = sortedDeps.iterator();
        while (it.hasNext()) {
            ModuleDependency md = (ModuleDependency)it.next();
            ProjectXMLManager.createModuleDependencyElement(moduleDependencies, md, null);
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
        this.directDeps = sortedDeps;
    }

    public void removeClassPathExtensions() {
        Element confData = this.getConfData();
        NodeList nl = confData.getElementsByTagNameNS("http://www.netbeans.org/ns/nb-module-project/2", CLASS_PATH_EXTENSION);
        for (int i = 0; i < nl.getLength(); ++i) {
            confData.removeChild(nl.item(i));
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
    }

    public void replaceClassPathExtensions(Map newValues) {
        this.removeClassPathExtensions();
        if (newValues != null && newValues.size() > 0) {
            Element confData = this.getConfData();
            Document doc = confData.getOwnerDocument();
            Iterator it = newValues.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Element cpel = ProjectXMLManager.createModuleElement(doc, CLASS_PATH_EXTENSION);
                Element runtime = ProjectXMLManager.createModuleElement(doc, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey());
                Element binary = ProjectXMLManager.createModuleElement(doc, "binary-origin", (String)entry.getValue());
                cpel.appendChild(runtime);
                cpel.appendChild(binary);
                confData.appendChild(cpel);
            }
            this.project.getHelper().putPrimaryConfigurationData(confData, true);
        }
    }

    public void replacePublicPackages(String[] newPackages) {
        this.removePublicAndFriends();
        Element confData = this.getConfData();
        Document doc = confData.getOwnerDocument();
        Element publicPackagesEl = ProjectXMLManager.createModuleElement(doc, PUBLIC_PACKAGES);
        this.insertPublicOrFriend(publicPackagesEl);
        for (int i = 0; i < newPackages.length; ++i) {
            publicPackagesEl.appendChild(ProjectXMLManager.createModuleElement(doc, PACKAGE, newPackages[i]));
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
        this.publicPackages = null;
    }

    private void insertPublicOrFriend(Element packagesEl) {
        Element beforeEl = ProjectXMLManager.findElement(this.getConfData(), CLASS_PATH_EXTENSION);
        if (beforeEl == null) {
            beforeEl = ProjectXMLManager.findElement(this.getConfData(), EXTRA_COMPILATION_UNIT);
        }
        this.getConfData().insertBefore(packagesEl, beforeEl);
    }

    public void replaceFriends(String[] friends, String[] packagesToExpose) {
        int i;
        this.removePublicAndFriends();
        Element confData = this.getConfData();
        Document doc = confData.getOwnerDocument();
        Element friendPackages = ProjectXMLManager.createModuleElement(doc, FRIEND_PACKAGES);
        this.insertPublicOrFriend(friendPackages);
        for (i = 0; i < friends.length; ++i) {
            friendPackages.appendChild(ProjectXMLManager.createModuleElement(doc, FRIEND, friends[i]));
        }
        for (i = 0; i < packagesToExpose.length; ++i) {
            friendPackages.appendChild(ProjectXMLManager.createModuleElement(doc, PACKAGE, packagesToExpose[i]));
        }
        this.project.getHelper().putPrimaryConfigurationData(confData, true);
        this.publicPackages = null;
    }

    public ManifestManager.PackageExport[] getPublicPackages() {
        if (this.publicPackages == null) {
            this.publicPackages = ProjectXMLManager.findPublicPackages(this.getConfData());
        }
        return this.publicPackages;
    }

    public String[] getFriends() {
        if (this.friends == null) {
            this.friends = ProjectXMLManager.findFriends(this.getConfData());
        }
        return this.friends;
    }

    public String[] getBinaryOrigins() {
        if (this.cpExtensions != null) {
            return this.cpExtensions;
        }
        List cpExtEls = Util.findSubElements(this.getConfData());
        TreeSet<String> binaryOrigs = new TreeSet<String>();
        Iterator it = cpExtEls.iterator();
        while (it.hasNext()) {
            Element binOrigEl;
            Element cpExtEl = (Element)it.next();
            if (!CLASS_PATH_EXTENSION.equals(cpExtEl.getTagName()) || (binOrigEl = ProjectXMLManager.findElement(cpExtEl, "binary-origin")) == null) continue;
            binaryOrigs.add(Util.findText(binOrigEl));
        }
        this.cpExtensions = binaryOrigs.toArray(new String[binaryOrigs.size()]);
        return this.cpExtensions;
    }

    public String getCodeNameBase() {
        if (this.cnb == null) {
            Element cnbEl = ProjectXMLManager.findElement(this.getConfData(), CODE_NAME_BASE);
            this.cnb = Util.findText(cnbEl);
        }
        return this.cnb;
    }

    static void createModuleDependencyElement(Element moduleDependencies, ModuleDependency md, Element nextSibling) {
        Document doc = moduleDependencies.getOwnerDocument();
        Element modDepEl = ProjectXMLManager.createModuleElement(doc, DEPENDENCY);
        moduleDependencies.insertBefore(modDepEl, nextSibling);
        modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, CODE_NAME_BASE, md.getModuleEntry().getCodeNameBase()));
        if (md.hasCompileDependency()) {
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, BUILD_PREREQUISITE));
            modDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, COMPILE_DEPENDENCY));
        }
        Element runDepEl = ProjectXMLManager.createModuleElement(doc, RUN_DEPENDENCY);
        modDepEl.appendChild(runDepEl);
        String rv = md.getReleaseVersion();
        if (rv != null && !rv.trim().equals("")) {
            runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, RELEASE_VERSION, rv));
        }
        if (md.hasImplementationDepedendency()) {
            runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, IMPLEMENTATION_VERSION));
        } else {
            String sv = md.getSpecificationVersion();
            if (sv != null && !"".equals(sv)) {
                runDepEl.appendChild(ProjectXMLManager.createModuleElement(doc, SPECIFICATION_VERSION, sv));
            }
        }
    }

    private void removePublicAndFriends() {
        Element publicPackages;
        Element friendPackages = ProjectXMLManager.findFriendsElement(this.getConfData());
        if (friendPackages != null) {
            this.getConfData().removeChild(friendPackages);
        }
        if ((publicPackages = ProjectXMLManager.findPublicPackagesElement(this.getConfData())) != null) {
            this.getConfData().removeChild(publicPackages);
        }
    }

    private static Element findElement(Element confData, String elementName) {
        return Util.findElement(confData, elementName, "http://www.netbeans.org/ns/nb-module-project/2");
    }

    static Element findModuleDependencies(Element confData) {
        return ProjectXMLManager.findElement(confData, MODULE_DEPENDENCIES);
    }

    private static Element findPublicPackagesElement(Element confData) {
        return ProjectXMLManager.findElement(confData, PUBLIC_PACKAGES);
    }

    private static Element findFriendsElement(Element confData) {
        return ProjectXMLManager.findElement(confData, FRIEND_PACKAGES);
    }

    private static Element createModuleElement(Document doc, String name) {
        return doc.createElementNS("http://www.netbeans.org/ns/nb-module-project/2", name);
    }

    private static Element createModuleElement(Document doc, String name, String innerText) {
        Element el = ProjectXMLManager.createModuleElement(doc, name);
        el.appendChild(doc.createTextNode(innerText));
        return el;
    }

    private static Element createSuiteElement(Document doc, String name) {
        return doc.createElementNS("http://www.netbeans.org/ns/nb-module-suite-project/1", name);
    }

    private static Element createSuiteElement(Document doc, String name, String innerText) {
        Element el = ProjectXMLManager.createSuiteElement(doc, name);
        el.appendChild(doc.createTextNode(innerText));
        return el;
    }

    private static Set findAllPackages(Element parent) {
        HashSet<ManifestManager.PackageExport> packages = new HashSet<ManifestManager.PackageExport>();
        List pkgEls = Util.findSubElements(parent);
        Iterator it = pkgEls.iterator();
        while (it.hasNext()) {
            Element pkgEl = (Element)it.next();
            if (PACKAGE.equals(pkgEl.getTagName())) {
                packages.add(new ManifestManager.PackageExport(Util.findText(pkgEl), false));
                continue;
            }
            if (!SUBPACKAGES.equals(pkgEl.getTagName())) continue;
            packages.add(new ManifestManager.PackageExport(Util.findText(pkgEl), true));
        }
        return packages;
    }

    public static ManifestManager.PackageExport[] findPublicPackages(Element confData) {
        Element ppEl = ProjectXMLManager.findPublicPackagesElement(confData);
        HashSet pps = new HashSet();
        if (ppEl != null) {
            pps.addAll(ProjectXMLManager.findAllPackages(ppEl));
        }
        if ((ppEl = ProjectXMLManager.findFriendsElement(confData)) != null) {
            pps.addAll(ProjectXMLManager.findAllPackages(ppEl));
        }
        return pps.isEmpty() ? ManifestManager.EMPTY_EXPORTED_PACKAGES : pps.toArray(new ManifestManager.PackageExport[pps.size()]);
    }

    public static String[] findFriends(Element confData) {
        Element friendsEl = ProjectXMLManager.findFriendsElement(confData);
        if (friendsEl != null) {
            List friendEls = Util.findSubElements(friendsEl);
            TreeSet<String> friends = new TreeSet<String>();
            Iterator it = friendEls.iterator();
            while (it.hasNext()) {
                Element friendEl = (Element)it.next();
                if (!FRIEND.equals(friendEl.getTagName())) continue;
                friends.add(Util.findText(friendEl));
            }
            String[] result = new String[friends.size()];
            return friends.toArray(result);
        }
        return null;
    }

    static void generateEmptyModuleTemplate(FileObject projectXml, String cnb, NbModuleTypeProvider.NbModuleType moduleType) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createModuleElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, CODE_NAME_BASE, cnb));
        Element moduleTypeEl = ProjectXMLManager.createTypeElement(dataDoc, moduleType);
        if (moduleTypeEl != null) {
            dataEl.appendChild(moduleTypeEl);
        }
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, MODULE_DEPENDENCIES));
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, PUBLIC_PACKAGES));
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    static void generateLibraryModuleTemplate(FileObject projectXml, String cnb, NbModuleTypeProvider.NbModuleType moduleType, Set publicPackages, Map extensions) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createModuleElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, CODE_NAME_BASE, cnb));
        Element moduleTypeEl = ProjectXMLManager.createTypeElement(dataDoc, moduleType);
        if (moduleTypeEl != null) {
            dataEl.appendChild(moduleTypeEl);
        }
        dataEl.appendChild(ProjectXMLManager.createModuleElement(dataDoc, MODULE_DEPENDENCIES));
        Element packages = ProjectXMLManager.createModuleElement(dataDoc, PUBLIC_PACKAGES);
        dataEl.appendChild(packages);
        Iterator<Object> it = publicPackages.iterator();
        while (it.hasNext()) {
            packages.appendChild(ProjectXMLManager.createModuleElement(dataDoc, PACKAGE, (String)it.next()));
        }
        it = extensions.entrySet().iterator();
        while (it.hasNext()) {
            Element cp = ProjectXMLManager.createModuleElement(dataDoc, CLASS_PATH_EXTENSION);
            dataEl.appendChild(cp);
            Map.Entry entry = (Map.Entry)it.next();
            cp.appendChild(ProjectXMLManager.createModuleElement(dataDoc, CLASS_PATH_RUNTIME_PATH, (String)entry.getKey()));
            cp.appendChild(ProjectXMLManager.createModuleElement(dataDoc, "binary-origin", (String)entry.getValue()));
        }
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    private static Element createTypeElement(Document dataDoc, NbModuleTypeProvider.NbModuleType type) {
        Element result = null;
        if (type == NbModuleTypeProvider.STANDALONE) {
            result = ProjectXMLManager.createModuleElement(dataDoc, STANDALONE);
        } else if (type == NbModuleTypeProvider.SUITE_COMPONENT) {
            result = ProjectXMLManager.createModuleElement(dataDoc, SUITE_COMPONENT);
        }
        return result;
    }

    public static void generateEmptySuiteTemplate(FileObject projectXml, String name) throws IOException {
        Document prjDoc = XMLUtil.createDocument((String)"project", (String)PROJECT_NS, null, null);
        Element typeEl = prjDoc.createElementNS(PROJECT_NS, "type");
        typeEl.appendChild(prjDoc.createTextNode("org.netbeans.modules.apisupport.project.suite"));
        prjDoc.getDocumentElement().appendChild(typeEl);
        Element confEl = prjDoc.createElementNS(PROJECT_NS, "configuration");
        prjDoc.getDocumentElement().appendChild(confEl);
        Element dataEl = ProjectXMLManager.createSuiteElement(confEl.getOwnerDocument(), DATA);
        confEl.appendChild(dataEl);
        Document dataDoc = dataEl.getOwnerDocument();
        dataEl.appendChild(ProjectXMLManager.createSuiteElement(dataDoc, "name", name));
        ProjectXMLManager.safelyWrite(projectXml, prjDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void safelyWrite(FileObject projectXml, Document prjDoc) throws IOException {
        FileLock lock = projectXml.lock();
        try {
            OutputStream os = projectXml.getOutputStream(lock);
            try {
                XMLUtil.write((Document)prjDoc, (OutputStream)os, (String)"UTF-8");
            }
            finally {
                os.close();
            }
        }
        finally {
            lock.releaseLock();
        }
    }

    private Element getConfData() {
        if (this.confData == null) {
            this.confData = this.project.getHelper().getPrimaryConfigurationData(true);
        }
        return this.confData;
    }

    static {
        $assertionsDisabled = !ProjectXMLManager.class.desiredAssertionStatus();
    }
}

