/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.editor.mimelookup.InstanceProvider;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.TopologicalSortException;
import org.openide.util.Utilities;

public class PopupActions
implements InstanceProvider {
    List ordered;
    private static final boolean debugSort = Boolean.getBoolean("netbeans.debug.editor.utils.sort.debug");
    private static List hidden = new ArrayList();
    static /* synthetic */ Class class$org$openide$cookies$InstanceCookie;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$swing$Action;
    static /* synthetic */ Class class$org$openide$util$actions$SystemAction;
    static /* synthetic */ Class class$javax$swing$JSeparator;
    static /* synthetic */ Class class$org$openide$loaders$DataFolder;

    public PopupActions() {
    }

    public PopupActions(List ordered) {
        this.ordered = ordered;
    }

    public List getPopupActions(String subFolderName) {
        ArrayList<DataFolder> folderList = new ArrayList<DataFolder>();
        for (int i = 0; i < this.ordered.size(); ++i) {
            DataFolder folder;
            DataObject dob = (DataObject)this.ordered.get(i);
            if (!(dob instanceof DataFolder) || !subFolderName.equals((folder = (DataFolder)dob).getName())) continue;
            folderList.add(folder);
        }
        return this.getPopupActionsImpl(PopupActions.mergeObjects(folderList));
    }

    public List getPopupActions() {
        List retList = this.getPopupActionsImpl(this.ordered);
        ArrayList cacheList = new ArrayList();
        for (int i = 0; i < retList.size(); ++i) {
            Object item = retList.get(i);
            if (item instanceof DataFolder) {
                DataFolder folder = (DataFolder)item;
                String name = folder.getName();
                boolean found = false;
                for (int j = 0; j < cacheList.size(); ++j) {
                    String attr;
                    DataFolder folder2;
                    String name2;
                    Object item2 = cacheList.get(j);
                    if (!(item2 instanceof DataFolder) || !name.equals(name2 = (folder2 = (DataFolder)item2).getName())) continue;
                    found = true;
                    if (folder2.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle") != null || (attr = (String)folder.getPrimaryFile().getAttribute("SystemFileSystem.localizingBundle")) == null) continue;
                    try {
                        folder2.getPrimaryFile().setAttribute("SystemFileSystem.localizingBundle", (Object)attr);
                        continue;
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace();
                    }
                }
                if (found) continue;
                cacheList.add(item);
                continue;
            }
            cacheList.add(item);
        }
        return cacheList;
    }

    private List getPopupActionsImpl(List items) {
        ArrayList<Object> retList = new ArrayList<Object>();
        for (int i = 0; i < items.size(); ++i) {
            DataObject dob = (DataObject)items.get(i);
            InstanceCookie ic = (InstanceCookie)dob.getCookie(class$org$openide$cookies$InstanceCookie == null ? PopupActions.class$("org.openide.cookies.InstanceCookie") : class$org$openide$cookies$InstanceCookie);
            if (ic != null) {
                try {
                    if (!(class$java$lang$String == null ? PopupActions.class$("java.lang.String") : class$java$lang$String).isAssignableFrom(ic.instanceClass()) && !(class$javax$swing$Action == null ? PopupActions.class$("javax.swing.Action") : class$javax$swing$Action).isAssignableFrom(ic.instanceClass()) && !(class$org$openide$util$actions$SystemAction == null ? PopupActions.class$("org.openide.util.actions.SystemAction") : class$org$openide$util$actions$SystemAction).isAssignableFrom(ic.instanceClass()) && !(class$javax$swing$JSeparator == null ? PopupActions.class$("javax.swing.JSeparator") : class$javax$swing$JSeparator).isAssignableFrom(ic.instanceClass()) && !(class$org$openide$loaders$DataFolder == null ? PopupActions.class$("org.openide.loaders.DataFolder") : class$org$openide$loaders$DataFolder).isAssignableFrom(ic.instanceClass())) continue;
                    Object instance = ic.instanceCreate();
                    retList.add(instance);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (ClassNotFoundException cnfe) {
                    cnfe.printStackTrace();
                }
                continue;
            }
            if (dob instanceof DataFolder) {
                retList.add(dob);
                continue;
            }
            retList.add(dob.getName());
        }
        return retList;
    }

    public Object createInstance(List ordered) {
        return new PopupActions(ordered);
    }

    private static List mergeObjects(List dataFoldersList) {
        DataFolder folder;
        int i;
        HashMap name2dob = new HashMap();
        HashMap edges = new HashMap();
        hidden.clear();
        for (i = 0; i < dataFoldersList.size(); ++i) {
            folder = (DataFolder)dataFoldersList.get(i);
            PopupActions.addDataObjects(name2dob, folder.getChildren());
        }
        for (i = 0; i < dataFoldersList.size(); ++i) {
            folder = (DataFolder)dataFoldersList.get(i);
            PopupActions.addEdges(edges, name2dob, folder);
        }
        try {
            return Utilities.topologicalSort(name2dob.values(), edges);
        }
        catch (TopologicalSortException ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
            return ex.partialSort();
        }
    }

    private static void addDataObjects(Map name2dob, DataObject[] addDobs) {
        int addDobsLength = addDobs.length;
        for (int i = 0; i < addDobsLength; ++i) {
            DataObject dob = addDobs[i];
            String dobName = dob.getPrimaryFile().getNameExt();
            if (dobName != null && dobName.endsWith("_hidden")) {
                String originalName = dobName.substring(0, dobName.indexOf("_hidden"));
                hidden.add(originalName);
                continue;
            }
            if (PopupActions.isHidden(dob.getPrimaryFile())) {
                hidden.add(dobName);
                continue;
            }
            if (hidden.contains(dobName)) continue;
            name2dob.put(dobName, dob);
        }
    }

    private static boolean isHidden(FileObject fo) {
        Enumeration e = fo.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            if (!"hidden".equals(name) || !((value = fo.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private static void addEdges(Map edges, Map name2dob, DataFolder folder) {
        FileObject primaryFile = folder.getPrimaryFile();
        Enumeration e = primaryFile.getAttributes();
        while (e.hasMoreElements()) {
            Object value;
            String name = (String)e.nextElement();
            int slashIndex = name.indexOf("/");
            if (slashIndex == -1 || !((value = primaryFile.getAttribute(name)) instanceof Boolean) || !((Boolean)value).booleanValue()) continue;
            String name1 = name.substring(0, slashIndex);
            String name2 = name.substring(slashIndex + 1);
            if (debugSort) {
                System.err.println("SORT-PAIR: [" + name1 + ", " + name2 + "]");
            }
            DataObject dob = (DataObject)name2dob.get(name1);
            DataObject target = (DataObject)name2dob.get(name2);
            if (dob == null || target == null) continue;
            Collection<DataObject> targetVertices = (List<DataObject>)edges.get(dob);
            if (targetVertices == null) {
                targetVertices = Collections.singletonList(target);
                edges.put(dob, targetVertices);
                continue;
            }
            if (targetVertices.size() == 1) {
                targetVertices = new HashSet<DataObject>(targetVertices);
                targetVertices.add(target);
                edges.put(dob, targetVertices);
                continue;
            }
            targetVertices.add(target);
        }
    }
}

