/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.tag;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.lib.cvsclient.CVSRoot;
import org.netbeans.lib.cvsclient.command.tag.TagCommand;
import org.netbeans.modules.versioning.system.cvss.ui.selectors.BranchSelector;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.awt.Mnemonics;

public class TagSettings
extends JPanel {
    private final File[] roots;
    private JCheckBox cbCheckModified;
    private JCheckBox cbMoveTag;
    private JButton jButton1;
    private JLabel nameLabel;
    private JTextField tfName;

    public TagSettings(File[] roots) {
        this.roots = roots;
        this.initComponents();
    }

    public void setCommand(TagCommand cmd) {
        this.cbMoveTag.setSelected(cmd.isOverrideExistingTag());
        this.cbCheckModified.setSelected(cmd.isCheckThatUnmodified());
        this.tfName.setText(cmd.getTag());
    }

    public void updateCommand(TagCommand cmd) {
        cmd.setOverrideExistingTag(this.cbMoveTag.isSelected());
        cmd.setCheckThatUnmodified(this.cbCheckModified.isSelected());
        cmd.setTag(this.tfName.getText());
    }

    private void initComponents() {
        this.cbCheckModified = new JCheckBox();
        this.cbMoveTag = new JCheckBox();
        this.nameLabel = new JLabel();
        this.tfName = new JTextField();
        this.jButton1 = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCheckModified, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_TagForm_EnsureUptodate"));
        this.cbCheckModified.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_TagForm_EnsureUptodate"));
        this.cbCheckModified.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.cbCheckModifiedActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.cbCheckModified, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.cbMoveTag, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_TagForm_MoveExisting"));
        this.cbMoveTag.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_TagForm_MoveExisting"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.cbMoveTag, gridBagConstraints);
        this.nameLabel.setLabelFor(this.tfName);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_TagForm_TagName"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.tfName.setColumns(20);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.tfName, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("CTL_BrowseTag"));
        this.jButton1.setToolTipText(ResourceBundle.getBundle("org/netbeans/modules/versioning/system/cvss/ui/actions/tag/Bundle").getString("TT_BrowseTag"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TagSettings.this.onBrowseTag(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.add((Component)this.jButton1, gridBagConstraints);
    }

    private void onBrowseTag(ActionEvent evt) {
        for (int i = 0; i < this.roots.length; ++i) {
            try {
                CVSRoot.parse((String)Utils.getCVSRootFor(this.roots[i]));
                BranchSelector selector = new BranchSelector();
                String tag = selector.selectTag(this.roots[i], null);
                if (tag != null) {
                    this.tfName.setText(tag);
                }
                return;
            }
            catch (IOException iOException) {
                continue;
            }
        }
    }

    private void cbCheckModifiedActionPerformed(ActionEvent evt) {
    }
}

