/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.windows.view.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import org.netbeans.core.windows.view.ViewElement;
import org.netbeans.core.windows.view.ui.MultiSplitCell;
import org.netbeans.core.windows.view.ui.MultiSplitDivider;

public class MultiSplitPane
extends JPanel
implements MouseMotionListener,
MouseListener {
    private MultiSplitDivider draggingDivider;
    private ArrayList dividers = new ArrayList();
    private boolean dirty = true;
    private ArrayList cells = new ArrayList();
    private int orientation;
    private int dividerSize;
    private boolean userMovedSplit = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiSplitPane() {
        this.setLayout(new MultiSplitLayout());
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.dividerSize = UIManager.getInt("SplitPane.dividerSize");
        if (0 == this.dividerSize) {
            this.dividerSize = 7;
        }
    }

    public void setChildren(int orientation, ViewElement[] childrenViews, double[] splitWeights) {
        Component c;
        if (!$assertionsDisabled && childrenViews.length != splitWeights.length) {
            throw new AssertionError();
        }
        this.orientation = orientation;
        ArrayList currentComponents = this.collectComponents();
        this.cells.clear();
        for (int i = 0; i < childrenViews.length; ++i) {
            this.cells.add(new MultiSplitCell(childrenViews[i], splitWeights[i], this.isHorizontalSplit()));
        }
        ArrayList updatedComponents = this.collectComponents();
        ArrayList removed = new ArrayList(currentComponents);
        removed.removeAll(updatedComponents);
        ArrayList added = new ArrayList(updatedComponents);
        added.removeAll(currentComponents);
        Iterator i = removed.iterator();
        while (i.hasNext()) {
            c = (Component)i.next();
            this.remove(c);
        }
        i = added.iterator();
        while (i.hasNext()) {
            c = (Component)i.next();
            this.add(c);
        }
        this.dirty = true;
    }

    int getCellCount() {
        return this.cells.size();
    }

    MultiSplitCell cellAt(int index) {
        if (!$assertionsDisabled && index < 0) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && index >= this.cells.size()) {
            throw new AssertionError();
        }
        return (MultiSplitCell)this.cells.get(index);
    }

    public void removeViewElementAt(int index) {
        if (index < 0 || index >= this.cells.size()) {
            return;
        }
        MultiSplitCell cellToRemove = (MultiSplitCell)this.cells.remove(index);
        this.remove(cellToRemove.getComponent());
        this.dirty = true;
    }

    public int getOrientation() {
        return this.orientation;
    }

    public boolean isVerticalSplit() {
        return this.orientation == 0;
    }

    public boolean isHorizontalSplit() {
        return this.orientation == 1;
    }

    private ArrayList collectComponents() {
        ArrayList<Component> res = new ArrayList<Component>(this.getCellCount());
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell cell = this.cellAt(i);
            Component c = cell.getComponent();
            if (!$assertionsDisabled && null == c) {
                throw new AssertionError();
            }
            res.add(c);
        }
        return res;
    }

    public void calculateSplitWeights(ArrayList visibleViews, ArrayList splitWeights) {
        double size;
        double d = size = this.isHorizontalSplit() ? (double)this.getSize().width : (double)this.getSize().height;
        if (size <= 0.0) {
            return;
        }
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell cell = this.cellAt(i);
            double weight = (double)cell.getSize() / size;
            splitWeights.add(new Double(weight));
            visibleViews.add(cell.getViewElement());
        }
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setDividerSize(int newDividerSize) {
        this.dirty |= newDividerSize != this.dividerSize;
        this.dividerSize = newDividerSize;
    }

    public Dimension getMinimumSize() {
        Dimension d = new Dimension();
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell cell = this.cellAt(i);
            int size = cell.getMinimumSize();
            Dimension minDim = cell.getComponent().getMinimumSize();
            if (this.isHorizontalSplit()) {
                d.width += size;
                if (minDim.height <= d.height) continue;
                d.height = minDim.height;
                continue;
            }
            d.height += size;
            if (minDim.width <= d.width) continue;
            d.width = minDim.width;
        }
        if (this.isHorizontalSplit()) {
            d.width += (this.getCellCount() - 1) * this.getDividerSize();
        } else {
            d.height += (this.getCellCount() - 1) * this.getDividerSize();
        }
        return d;
    }

    public void mouseMoved(MouseEvent e) {
        this.switchCursor(e);
        e.consume();
    }

    public void mouseDragged(MouseEvent e) {
        if (null == this.draggingDivider) {
            return;
        }
        this.draggingDivider.dragTo(e.getPoint());
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        if (null == this.draggingDivider) {
            return;
        }
        Point p = new Point(e.getPoint());
        this.draggingDivider.finishDraggingTo(p);
        this.draggingDivider = null;
        this.setCursor(Cursor.getDefaultCursor());
        e.consume();
    }

    public void mousePressed(MouseEvent e) {
        MultiSplitDivider divider = this.dividerAtPoint(e.getPoint());
        if (null == divider) {
            return;
        }
        this.draggingDivider = divider;
        divider.startDragging(e.getPoint());
        e.consume();
    }

    public void mouseExited(MouseEvent e) {
        if (null == this.draggingDivider) {
            this.setCursor(Cursor.getDefaultCursor());
        }
        e.consume();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    private void switchCursor(MouseEvent e) {
        MultiSplitDivider divider = this.dividerAtPoint(e.getPoint());
        if (null == divider) {
            this.setCursor(Cursor.getDefaultCursor());
        } else if (divider.isHorizontal()) {
            this.setCursor(Cursor.getPredefinedCursor(11));
        } else {
            this.setCursor(Cursor.getPredefinedCursor(8));
        }
    }

    private MultiSplitDivider dividerAtPoint(Point p) {
        Iterator i = this.dividers.iterator();
        while (i.hasNext()) {
            MultiSplitDivider d = (MultiSplitDivider)i.next();
            if (!d.containsPoint(p)) continue;
            return d;
        }
        return null;
    }

    public void paint(Graphics g) {
        super.paint(g);
        Iterator i = this.dividers.iterator();
        while (i.hasNext()) {
            MultiSplitDivider divider = (MultiSplitDivider)i.next();
            divider.paint(g);
        }
    }

    private void resize(int newSize) {
        int currentSize = 0;
        for (int i = 0; i < this.getCellCount(); ++i) {
            currentSize += this.cellAt(i).getRequiredSize();
        }
        int totalDividerSize = this.getDividerSize() * (this.getCellCount() - 1);
        int newNetSize = newSize - totalDividerSize;
        int delta = newNetSize - currentSize;
        if (delta > 0) {
            this.grow(delta);
        } else if (delta < 0 && (delta = this.shrink(delta)) > 0) {
            newNetSize -= delta;
        }
        int totalSize = 0;
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell cell = this.cellAt(i);
            totalSize += cell.getRequiredSize();
        }
        if (totalSize < newNetSize) {
            MultiSplitCell lastCell = this.cellAt(this.getCellCount() - 1);
            lastCell.setRequiredSize(lastCell.getRequiredSize() + (newNetSize - totalSize));
        }
    }

    private void grow(int delta) {
        ArrayList hungryCells = this.getResizeHungryCells();
        if (!hungryCells.isEmpty()) {
            this.normalizeResizeWeights(hungryCells);
            this.distributeDelta(delta, hungryCells);
        } else {
            ArrayList resizeableCells = new ArrayList(this.cells);
            this.normalizeResizeWeights(resizeableCells);
            this.distributeDelta(delta, resizeableCells);
        }
    }

    private int shrink(int negativeDelta) {
        int delta = -negativeDelta;
        ArrayList hungryCells = this.getResizeHungryCells();
        int resizeArea = this.calculateShrinkableArea(hungryCells);
        if (resizeArea >= delta) {
            resizeArea = delta;
            delta = 0;
        } else {
            delta -= resizeArea;
        }
        if (resizeArea > 0) {
            this.distributeDelta(-resizeArea, hungryCells);
        }
        if (delta > 0) {
            ArrayList resizeableCells = new ArrayList(this.cells);
            resizeArea = this.calculateShrinkableArea(resizeableCells);
            if (resizeArea >= delta) {
                resizeArea = delta;
                delta = 0;
            } else {
                delta -= resizeArea;
            }
            if (resizeArea > 0) {
                this.distributeDelta(-resizeArea, resizeableCells);
            }
        }
        return delta;
    }

    private int calculateShrinkableArea(ArrayList cells) {
        int minSize;
        int currentSize;
        MultiSplitCell c;
        int i;
        int res = 0;
        ArrayList<MultiSplitCell> nonShrinkable = new ArrayList<MultiSplitCell>(cells.size());
        for (i = 0; i < cells.size(); ++i) {
            c = (MultiSplitCell)cells.get(i);
            currentSize = c.getRequiredSize();
            if (currentSize - (minSize = c.getMinimumSize()) > 0) {
                res += currentSize - minSize;
                continue;
            }
            nonShrinkable.add(c);
        }
        cells.removeAll(nonShrinkable);
        for (i = 0; i < cells.size(); ++i) {
            c = (MultiSplitCell)cells.get(i);
            currentSize = c.getRequiredSize();
            minSize = c.getMinimumSize();
            c.setNormalizedResizeWeight(1.0 * (double)(currentSize - minSize) / (double)res);
        }
        return res;
    }

    private void distributeDelta(int delta, ArrayList cells) {
        int totalDistributed = 0;
        for (int i = 0; i < cells.size(); ++i) {
            MultiSplitCell cell = (MultiSplitCell)cells.get(i);
            int cellDelta = (int)(cell.getNormalizedResizeWeight() * (double)delta);
            totalDistributed += cellDelta;
            if (i == cells.size() - 1) {
                cellDelta += delta - totalDistributed;
            }
            cell.setRequiredSize(cell.getRequiredSize() + cellDelta);
        }
    }

    private void normalizeResizeWeights(List cells) {
        if (cells.isEmpty()) {
            return;
        }
        double totalWeight = 0.0;
        Iterator i = cells.iterator();
        while (i.hasNext()) {
            MultiSplitCell c = (MultiSplitCell)i.next();
            totalWeight += c.getResizeWeight();
        }
        double deltaWeight = (1.0 - totalWeight) / (double)cells.size();
        Iterator i2 = cells.iterator();
        while (i2.hasNext()) {
            MultiSplitCell c = (MultiSplitCell)i2.next();
            c.setNormalizedResizeWeight(c.getResizeWeight() + deltaWeight);
        }
    }

    ArrayList getResizeHungryCells() {
        ArrayList<MultiSplitCell> res = new ArrayList<MultiSplitCell>(this.cells.size());
        for (int i = 0; i < this.getCellCount(); ++i) {
            MultiSplitCell cell = this.cellAt(i);
            if (cell.getResizeWeight() <= 0.0) continue;
            res.add(cell);
        }
        return res;
    }

    void createDividers() {
        this.dividers.clear();
        for (int i = 0; i < this.getCellCount() - 1; ++i) {
            MultiSplitCell first = this.cellAt(i);
            MultiSplitCell second = this.cellAt(i + 1);
            MultiSplitDivider divider = new MultiSplitDivider(this, first, second);
            this.dividers.add(divider);
        }
    }

    void splitterMoved() {
        this.userMovedSplit = true;
        this.validate();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleMultiSplitPane();
        }
        return this.accessibleContext;
    }

    int getDividerAccessibleIndex(MultiSplitDivider divider) {
        int res = this.dividers.indexOf(divider);
        return res += this.getAccessibleContext().getAccessibleChildrenCount() - this.dividers.size();
    }

    static {
        $assertionsDisabled = !MultiSplitPane.class.desiredAssertionStatus();
    }

    protected class MultiSplitLayout
    implements LayoutManager {
        protected MultiSplitLayout() {
        }

        public void layoutContainer(Container c) {
            if (c != MultiSplitPane.this) {
                return;
            }
            int newSize = MultiSplitPane.this.isHorizontalSplit() ? MultiSplitPane.this.getSize().width : MultiSplitPane.this.getSize().height;
            for (int i = 0; i < MultiSplitPane.this.getCellCount(); ++i) {
                MultiSplitCell cell = MultiSplitPane.this.cellAt(i);
                cell.maybeResetToInitialSize(newSize);
            }
            MultiSplitPane.this.resize(newSize);
            this.layoutCells();
            if (MultiSplitPane.this.userMovedSplit) {
                MultiSplitPane.this.userMovedSplit = false;
                MultiSplitPane.this.firePropertyChange("splitPositions", null, this);
            }
            MultiSplitPane.this.createDividers();
        }

        private void layoutCells() {
            int x = 0;
            int y = 0;
            int width = MultiSplitPane.this.getWidth();
            int height = MultiSplitPane.this.getHeight();
            for (int i = 0; i < MultiSplitPane.this.getCellCount(); ++i) {
                MultiSplitCell cell = MultiSplitPane.this.cellAt(i);
                if (cell.getComponent().getParent() != MultiSplitPane.this) {
                    MultiSplitPane.this.add(cell.getComponent());
                }
                if (MultiSplitPane.this.isHorizontalSplit()) {
                    width = cell.getRequiredSize();
                } else {
                    height = cell.getRequiredSize();
                }
                cell.layout(x, y, width, height);
                if (MultiSplitPane.this.isHorizontalSplit()) {
                    x += width;
                    if (i >= MultiSplitPane.this.getCellCount()) continue;
                    x += MultiSplitPane.this.getDividerSize();
                    continue;
                }
                y += height;
                if (i >= MultiSplitPane.this.getCellCount() - 1) continue;
                y += MultiSplitPane.this.getDividerSize();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return container.getSize();
        }

        public Dimension preferredLayoutSize(Container container) {
            return container.getSize();
        }

        public void removeLayoutComponent(Component c) {
        }

        public void addLayoutComponent(String string, Component c) {
        }
    }

    protected class AccessibleMultiSplitPane
    extends JComponent.AccessibleJComponent {
        protected AccessibleMultiSplitPane() {
            super(MultiSplitPane.this);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (MultiSplitPane.this.isHorizontalSplit()) {
                states.add(AccessibleState.HORIZONTAL);
            } else {
                states.add(AccessibleState.VERTICAL);
            }
            return states;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SPLIT_PANE;
        }

        public Accessible getAccessibleAt(Point p) {
            MultiSplitDivider divider = MultiSplitPane.this.dividerAtPoint(p);
            if (null != divider) {
                return divider;
            }
            return super.getAccessibleAt(p);
        }

        public Accessible getAccessibleChild(int i) {
            int childrenCount = super.getAccessibleChildrenCount();
            if (i < childrenCount) {
                return super.getAccessibleChild(i);
            }
            if (i - childrenCount >= MultiSplitPane.this.dividers.size()) {
                return null;
            }
            MultiSplitDivider divider = (MultiSplitDivider)MultiSplitPane.this.dividers.get(i - childrenCount);
            return divider;
        }

        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount() + MultiSplitPane.this.dividers.size();
        }
    }
}

