/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaee.blueprints.components.ui.util;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Security;

public class HttpClient {
    private String proxyHost = null;
    private String proxyPort = null;
    private boolean isHttps = false;
    private boolean isProxy = false;
    private URLConnection urlConnection = null;

    public HttpClient(String url) {
        this.urlConnection = this.getURLConnection(url);
    }

    public HttpClient(String phost, String pport, String url) {
        if (phost != null && pport != null) {
            this.isProxy = true;
        }
        this.proxyHost = phost;
        this.proxyPort = pport;
        if (url.indexOf("https") >= 0) {
            this.isHttps = true;
        }
        this.urlConnection = this.getURLConnection(url);
    }

    private URLConnection getURLConnection(String str) {
        try {
            if (this.isHttps) {
                Security.addProvider((java.security.Provider)new Provider());
                System.setProperty("java.protocol.handler.pkgs", "com.sun.net.ssl.internal.www.protocol");
                if (this.isProxy) {
                    System.setProperty("https.proxyHost", this.proxyHost);
                    System.setProperty("https.proxyPort", this.proxyPort);
                }
            } else if (this.isProxy) {
                System.setProperty("http.proxyHost", this.proxyHost);
                System.setProperty("http.proxyPort", this.proxyPort);
            }
            URL url = new URL(str);
            return url.openConnection();
        }
        catch (MalformedURLException me) {
            System.out.println("Malformed URL");
            me.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream getInputStream() {
        try {
            return this.urlConnection.getInputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public OutputStream getOutputStream() {
        try {
            return this.urlConnection.getOutputStream();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public InputStream doPost(String postData) {
        this.urlConnection.setDoOutput(true);
        OutputStream os = this.getOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.print(postData);
        ps.close();
        return this.getInputStream();
    }

    public String getContentEncoding() {
        return this.urlConnection.getContentEncoding();
    }

    public int getContentLength() {
        return this.urlConnection.getContentLength();
    }

    public String getContentType() {
        return this.urlConnection.getContentType();
    }

    public long getDate() {
        return this.urlConnection.getDate();
    }

    public String getHeader(String name) {
        return this.urlConnection.getHeaderField(name);
    }

    public long getIfModifiedSince() {
        return this.urlConnection.getIfModifiedSince();
    }
}

