/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.transport.http.server;

import com.sun.net.httpserver.HttpContext;
import com.sun.xml.ws.binding.BindingImpl;
import com.sun.xml.ws.transport.http.server.HttpEndpoint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.xml.transform.Source;
import javax.xml.ws.Binding;
import javax.xml.ws.Endpoint;
import javax.xml.ws.WebServicePermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointImpl
extends Endpoint {
    private static final WebServicePermission ENDPOINT_PUBLISH_PERMISSION = new WebServicePermission("publishEndpoint");
    private Object actualEndpoint;
    private Executor executor;
    private boolean published;
    private boolean stopped;
    private final com.sun.xml.ws.spi.runtime.Binding binding;
    private final Object implementor;
    private Map<String, Object> properties;
    private List<Source> metadata;

    public EndpointImpl(String bindingId, Object impl) {
        this.implementor = impl;
        this.binding = BindingImpl.getBinding(bindingId, impl.getClass(), null, false);
    }

    @Override
    public Binding getBinding() {
        return this.binding;
    }

    @Override
    public Object getImplementor() {
        return this.implementor;
    }

    @Override
    public void publish(String address) {
        URL url;
        this.canPublish();
        try {
            url = new URL(address);
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Cannot create URL for this address " + address);
        }
        if (!url.getProtocol().equals("http")) {
            throw new IllegalArgumentException(url.getProtocol() + " protocol based address is not supported");
        }
        if (!url.getPath().startsWith("/")) {
            throw new IllegalArgumentException("Incorrect WebService address=" + address + ". The address's path should start with /");
        }
        this.checkPlatform();
        this.actualEndpoint = new HttpEndpoint(this.implementor, this.binding, this.metadata, this.properties, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(address);
        this.published = true;
    }

    @Override
    public void publish(Object serverContext) {
        this.canPublish();
        this.checkPlatform();
        if (!HttpContext.class.isAssignableFrom(serverContext.getClass())) {
            throw new IllegalArgumentException(serverContext.getClass() + " is not a supported context.");
        }
        this.actualEndpoint = new HttpEndpoint(this.implementor, this.binding, this.metadata, this.properties, this.executor);
        ((HttpEndpoint)this.actualEndpoint).publish(serverContext);
        this.published = true;
    }

    @Override
    public void stop() {
        if (this.published) {
            ((HttpEndpoint)this.actualEndpoint).stop();
            this.published = false;
            this.stopped = true;
        }
    }

    @Override
    public boolean isPublished() {
        return this.published;
    }

    private void canPublish() {
        if (this.published) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already published.");
        }
        if (this.stopped) {
            throw new IllegalStateException("Cannot publish this endpoint. Endpoint has been already stopped.");
        }
    }

    @Override
    public List<Source> getMetadata() {
        return this.metadata;
    }

    @Override
    public void setMetadata(List<Source> metadata) {
        if (this.published) {
            throw new IllegalStateException("Cannot set Metadata. Endpoint is already published");
        }
        this.metadata = metadata;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public void setExecutor(Executor executor) {
        this.executor = executor;
    }

    @Override
    public Map<String, Object> getProperties() {
        return this.properties;
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        this.properties = map;
    }

    private void checkPlatform() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(ENDPOINT_PUBLISH_PERMISSION);
        }
        try {
            Class.forName("com.sun.net.httpserver.HttpServer");
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("NOT SUPPORTED");
        }
    }
}

