/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.multiview;

import java.awt.Component;
import java.util.LinkedList;
import javax.swing.JPanel;
import org.netbeans.modules.xml.multiview.ui.BoxPanel;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodePanel;
import org.netbeans.modules.xml.multiview.ui.SectionNodeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;

public class SectionNode
extends AbstractNode {
    protected final Object key;
    private boolean expanded = false;
    private SectionNodePanel sectionPanel = null;
    private final String iconBase;
    private final SectionNodeView sectionNodeView;
    protected boolean helpProvider = false;

    protected SectionNode(SectionNodeView sectionNodeView, Children children, Object key, String title, String iconBase) {
        super(children);
        this.sectionNodeView = sectionNodeView;
        this.key = key;
        super.setDisplayName(title);
        super.setIconBase(iconBase);
        this.iconBase = iconBase;
        sectionNodeView.registerNode(this);
    }

    public SectionNodeView getSectionNodeView() {
        return this.sectionNodeView;
    }

    public Object getKey() {
        return this.key;
    }

    public void addChild(SectionNode node) {
        this.getChildren().add(new Node[]{node});
    }

    public SectionNodeInnerPanel createInnerPanel() {
        Children children = this.getChildren();
        if (children.getNodesCount() == 0) {
            return this.createNodeInnerPanel();
        }
        BoxPanel boxPanel = new BoxPanel(this.sectionNodeView);
        this.populateBoxPanel(boxPanel);
        return boxPanel;
    }

    public void populateBoxPanel() {
        SectionInnerPanel innerPanel = this.getSectionNodePanel().getInnerPanel();
        if (innerPanel instanceof BoxPanel) {
            this.populateBoxPanel((BoxPanel)innerPanel);
        }
    }

    public void populateBoxPanel(BoxPanel boxPanel) {
        LinkedList<JPanel> nodeList = new LinkedList<JPanel>();
        SectionNodeInnerPanel nodeInnerPanel = this.createNodeInnerPanel();
        if (nodeInnerPanel != null) {
            nodeList.add(nodeInnerPanel);
        }
        Node[] nodes = this.getChildren().getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            nodeList.add(((SectionNode)nodes[i]).getSectionNodePanel());
        }
        boxPanel.setComponents(nodeList.toArray(new Component[0]));
    }

    public HelpCtx getHelpCtx() {
        if (this.helpProvider) {
            return new HelpCtx(((Object)((Object)this)).getClass());
        }
        Node parentNode = this.getParentNode();
        if (parentNode instanceof SectionNode) {
            return ((SectionNode)parentNode).getHelpCtx();
        }
        return new HelpCtx(this.sectionNodeView.getClass());
    }

    public boolean canDestroy() {
        return true;
    }

    protected SectionNodeInnerPanel createNodeInnerPanel() {
        return null;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
    }

    public SectionNodePanel getSectionNodePanel() {
        if (this.sectionPanel == null) {
            this.sectionPanel = new SectionNodePanel(this);
        }
        return this.sectionPanel;
    }

    public String getIconBase() {
        return this.iconBase;
    }

    public boolean equals(Object obj) {
        return ((Object)((Object)this)).getClass() == obj.getClass() && this.key.equals(((SectionNode)((Object)obj)).key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public final void dataModelPropertyChange(Object source, String propertyName, Object oldValue, Object newValue) {
        Children children;
        SectionInnerPanel innerPanel;
        if (this.sectionPanel != null && (innerPanel = this.sectionPanel.getInnerPanel()) != null) {
            innerPanel.dataModelPropertyChange(source, propertyName, oldValue, newValue);
        }
        if ((children = this.getChildren()) != null) {
            Node[] nodes = children.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                if (!(node instanceof SectionNode)) continue;
                ((SectionNode)node).dataModelPropertyChange(source, propertyName, oldValue, newValue);
            }
        }
    }

    public void refreshSubtree() {
        Children children;
        SectionInnerPanel innerPanel;
        if (this.sectionPanel != null && (innerPanel = this.sectionPanel.getInnerPanel()) != null) {
            innerPanel.refreshView();
        }
        if ((children = this.getChildren()) != null) {
            Node[] nodes = children.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                if (!(node instanceof SectionNode)) continue;
                ((SectionNode)node).refreshSubtree();
            }
        }
    }

    public SectionNode getNodeForElement(Object element) {
        if (this.key.equals(element)) {
            return this;
        }
        Node[] nodes = this.getChildren().getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            SectionNode nodeForElement;
            Node node = nodes[i];
            if (!(node instanceof SectionNode) || (nodeForElement = ((SectionNode)node).getNodeForElement(element)) == null) continue;
            return nodeForElement;
        }
        return null;
    }
}

