/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.dev.wizard;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.dd.api.ejb.Ejb;
import org.netbeans.modules.j2ee.dd.api.ejb.EjbJar;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.api.webservices.DDProvider;
import org.netbeans.modules.j2ee.dd.api.webservices.WebserviceDescription;
import org.netbeans.modules.j2ee.dd.api.webservices.Webservices;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.websvc.api.webservices.WebServicesSupport;
import org.netbeans.modules.websvc.dev.wizard.WebServiceWizard;
import org.netbeans.modules.websvc.dev.wizard.WebServiceWizardHelper;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class WebServiceWizardDescriptor
implements WizardDescriptor.FinishablePanel {
    private WizardDescriptor wizardDescriptor;
    private WebServiceWizardPanel panel;
    private WebServiceWizardHelper helper;
    private ChangeListener listener;
    private static String previousDirectory = "";
    private JTextField nameField;
    private Project namespaceProject;
    private Map webServiceNamespace;
    private WizardDescriptor.Panel firstPanel;

    public WebServiceWizardDescriptor(WizardDescriptor wizardDescriptor, WebServiceWizardHelper helper) {
        this.wizardDescriptor = wizardDescriptor;
        this.helper = helper;
        this.nameField = null;
        this.webServiceNamespace = null;
    }

    public void setTargetChooserPanel(WizardDescriptor.Panel panel) {
        this.firstPanel = panel;
    }

    public boolean isFinishPanel() {
        return false;
    }

    public void addChangeListener(ChangeListener l) {
        this.listener = l;
    }

    public void removeChangeListener(ChangeListener l) {
        if (this.listener == l) {
            this.listener = null;
        }
    }

    public Component getComponent() {
        if (this.panel == null) {
            this.panel = new WebServiceWizardPanel(this.helper);
        }
        return this.panel;
    }

    public HelpCtx getHelp() {
        return new HelpCtx(WebServiceWizardDescriptor.class);
    }

    private String validateWebServiceName(String name, Map namespace) {
        String message = null;
        if (name == null || name.length() == 0) {
            message = NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"MSG_EnterWebServiceName");
        } else if (namespace.containsKey(name)) {
            String messageId = (String)namespace.get(name);
            String servletName = "WSServlet_" + name;
            message = NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)messageId, (Object)name, (Object)servletName);
        }
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Map getWSNameSpace(Project p) {
        J2eeModuleProvider j2eeModuleProvider;
        Object moduleType;
        long start = System.currentTimeMillis();
        HashMap<String, String> namespace = new HashMap<String, String>();
        WebServicesSupport wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)p.getProjectDirectory());
        if (wsSupport == null) return namespace;
        DDProvider wsDDProvider = DDProvider.getDefault();
        try {
            WebserviceDescription[] descriptions;
            Webservices webServices = wsDDProvider.getDDRoot(wsSupport.getWebservicesDD());
            if (webServices != null && (descriptions = webServices.getWebserviceDescription()) != null) {
                for (int i = 0; i < descriptions.length; ++i) {
                    String wsname = descriptions[i].getWebserviceDescriptionName();
                    if (wsname == null || wsname.length() <= 0) continue;
                    namespace.put(wsname, "ERR_WebServiceExists");
                }
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (J2eeModule.WAR.equals(moduleType = (j2eeModuleProvider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class)).getJ2eeModule().getModuleType())) {
            FileObject ddFO = WebModule.getWebModule((FileObject)p.getProjectDirectory()).getDeploymentDescriptor();
            if (ddFO == null) return namespace;
            try {
                WebApp webApp = org.netbeans.modules.j2ee.dd.api.web.DDProvider.getDefault().getDDRoot(ddFO);
                Servlet[] servlets = webApp.getServlet();
                if (servlets == null) return namespace;
                for (int i = 0; i < servlets.length; ++i) {
                    String wsRootName;
                    String servletName = servlets[i].getServletName();
                    if (servletName == null || servletName.length() <= 10 || !servletName.startsWith("WSServlet_") || namespace.containsKey(wsRootName = servletName.substring(10))) continue;
                    namespace.put(wsRootName, "ERR_WS_ServletExists");
                }
                return namespace;
            }
            catch (IOException ex) {
                return namespace;
            }
        }
        if (!J2eeModule.EJB.equals(moduleType)) return namespace;
        org.netbeans.modules.j2ee.api.ejbjar.EjbJar ejbjarModule = org.netbeans.modules.j2ee.api.ejbjar.EjbJar.getEjbJar((FileObject)p.getProjectDirectory());
        try {
            Ejb[] ejbs;
            EjbJar ejbJar = org.netbeans.modules.j2ee.dd.api.ejb.DDProvider.getDefault().getMergedDDRoot(ejbjarModule.getMetadataUnit());
            EnterpriseBeans eb = ejbJar.getEnterpriseBeans();
            if (eb == null || (ejbs = eb.getEjbs()) == null) return namespace;
            for (int i = 0; i < ejbs.length; ++i) {
                String ejbName = ejbs[i].getEjbName();
                if (ejbName == null || ejbName.length() <= 0 || namespace.containsKey(ejbName)) continue;
                namespace.put(ejbName, "ERR_WS_EjbExists");
            }
            return namespace;
        }
        catch (IOException ex) {
            // empty catch block
        }
        return namespace;
    }

    private static JComboBox findCombo(JComponent comp) {
        Vector allComponents = new Vector();
        Util.getAllComponents((Component[])comp.getComponents(), allComponents);
        for (Component c : allComponents) {
            JComboBox combo;
            if (!(c instanceof JComboBox) || !((combo = (JComboBox)c).getSelectedItem() instanceof SourceGroup)) continue;
            return combo;
        }
        return null;
    }

    public boolean isValid() {
        JComboBox rootFolderCombo;
        JComponent targetChooserGUI;
        Project p = Templates.getProject((WizardDescriptor)this.wizardDescriptor);
        if (!this.isWsCompileSupported(p)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"ERR_WsCompileNotSupportedByTargetServer"));
            return false;
        }
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        String j2eeVersion = j2eeModuleProvider.getJ2eeModule().getModuleVersion();
        Object moduleType = j2eeModuleProvider.getJ2eeModule().getModuleType();
        if (J2eeModule.WAR.equals(moduleType) && !"2.4".equals(j2eeVersion) || J2eeModule.EJB.equals(moduleType) && !"2.1".equals(j2eeVersion)) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"ERR_ProjectDoesNotSupportJ2EE14"));
            return false;
        }
        if (this.firstPanel != null && (targetChooserGUI = (JComponent)this.firstPanel.getComponent()) != null && (rootFolderCombo = WebServiceWizardDescriptor.findCombo(targetChooserGUI)) != null) {
            if (rootFolderCombo.isVisible()) {
                WebServicesSupport wsSupport;
                FileObject fo = ((SourceGroup)rootFolderCombo.getSelectedItem()).getRootFolder();
                if (fo != null && (wsSupport = WebServicesSupport.getWebServicesSupport((FileObject)fo)) == null) {
                    String msg = NbBundle.getMessage(WebServiceWizard.class, (String)"ERR_NoTargetFolder");
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg);
                    return false;
                }
            } else {
                String msg = NbBundle.getMessage(WebServiceWizard.class, (String)"ERR_NoTargetFolder");
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)msg);
                return false;
            }
        }
        if (this.panel != null) {
            String wsdlUrl;
            if (this.nameField != null) {
                String message;
                String wsname = this.nameField.getText().trim();
                if (this.webServiceNamespace == null || this.namespaceProject != p) {
                    this.webServiceNamespace = this.getWSNameSpace(p);
                    this.namespaceProject = p;
                }
                if ((message = this.validateWebServiceName(wsname, this.webServiceNamespace)) != null) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)message);
                    return false;
                }
            }
            if (this.panel.getFromWSDLButton().isSelected()) {
                String wsdlFilePath = this.panel.getWSDLFilePath().trim();
                if (wsdlFilePath == null || wsdlFilePath.length() == 0) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"MSG_EnterWsdlName"));
                    return false;
                }
                File f = new File(wsdlFilePath);
                String wsdlFileText = f.getAbsolutePath();
                if ((f = WebServiceWizardDescriptor.getCanonicalFile(f)) == null) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"ERR_WsdlInvalid"));
                    return false;
                }
                if (!f.exists()) {
                    this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"ERR_WsdlDoesNotExist"));
                    return false;
                }
            } else if (this.panel.getFromWSDLUrlButton().isSelected() && ((wsdlUrl = this.panel.getWSDLUrl().trim()) == null || wsdlUrl.length() == 0)) {
                this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"MSG_EnterWsdlUrl"));
                return false;
            }
        }
        return true;
    }

    private boolean isWsCompileSupported(Project p) {
        J2eePlatform j2eePlatform;
        String serverInstanceID;
        boolean result = true;
        J2eeModuleProvider provider = (J2eeModuleProvider)p.getLookup().lookup(J2eeModuleProvider.class);
        if (!(provider == null || (serverInstanceID = provider.getServerInstanceID()) == null || serverInstanceID.length() <= 0 || (j2eePlatform = Deployment.getDefault().getJ2eePlatform(serverInstanceID)) != null && j2eePlatform.isToolSupported("wscompile"))) {
            result = false;
        }
        return result;
    }

    public static File getCanonicalFile(File f) {
        File f1;
        try {
            f1 = f.getCanonicalFile();
        }
        catch (IOException e) {
            f1 = null;
        }
        return f1;
    }

    public void readSettings(Object settings) {
        if (settings instanceof WizardDescriptor) {
            this.panel.readSettings((WizardDescriptor)settings);
            Project p = Templates.getProject((WizardDescriptor)((WizardDescriptor)settings));
            if (p != null) {
                if (this.namespaceProject != p) {
                    this.webServiceNamespace = this.getWSNameSpace(p);
                    this.namespaceProject = p;
                }
            } else {
                this.webServiceNamespace = null;
                this.namespaceProject = null;
            }
        }
    }

    public void storeSettings(Object settings) {
        WebServiceWizardHelper helper = this.panel.getWizardHelper();
        if (settings instanceof WebServiceWizardHelper) {
            helper = (WebServiceWizardHelper)settings;
        }
        if (helper != null) {
            if (this.panel.isFromScratch()) {
                helper.setCreateFrom(0);
            } else if (this.panel.isFromExistingCode()) {
                helper.setCreateFrom(1);
            } else if (this.panel.isFromWSDL()) {
                helper.setCreateFrom(2);
            } else if (this.panel.isFromWSDLUrl()) {
                helper.setCreateFrom(3);
            }
        }
        if (settings instanceof WizardDescriptor) {
            this.panel.storeSettings((WizardDescriptor)settings);
        }
    }

    private static class WsdlFileFilter
    extends FileFilter {
        private WsdlFileFilter() {
        }

        public boolean accept(File f) {
            boolean result = f.isDirectory() || "wsdl".equalsIgnoreCase(FileUtil.getExtension((String)f.getName()));
            return result;
        }

        public String getDescription() {
            return NbBundle.getMessage(WebServiceWizardDescriptor.class, (String)"LBL_WsdlFilterDescription");
        }
    }

    class WebServiceWizardPanel
    extends JPanel
    implements DocumentListener {
        WebServiceWizardHelper helper;
        private final FileFilter WSDL_FILE_FILTER = new WsdlFileFilter();
        private ButtonGroup typeButtons;
        private JRadioButton fromScratchButton;
        private JRadioButton fromWSDLButton;
        private JRadioButton fromWSDLUrlButton;
        private JCheckBox fromExistingCodeButton;
        private JPanel wsdlFilePanel;
        private JTextField wsdlFileTextField;
        private JButton browseButton;
        private JPanel urlPanel;
        private JLabel urlLabel;
        private JTextField urlTextField;

        public WebServiceWizardPanel(WebServiceWizardHelper helper) {
            this.helper = helper;
            this.initComponents();
            this.addListeners();
        }

        private void initComponents() {
            this.typeButtons = new ButtonGroup();
            this.fromScratchButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromScratch"));
            this.fromScratchButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromScratch"));
            this.fromScratchButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromScratch_mnem").charAt(0));
            this.fromWSDLButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromWSDL"));
            this.fromWSDLButton.getAccessibleContext().setAccessibleDescription(this.fromWSDLButton.getText());
            this.fromWSDLButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromWSDL_mnem").charAt(0));
            this.fromWSDLUrlButton = new JRadioButton(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromWSDLUrl"));
            this.fromWSDLUrlButton.getAccessibleContext().setAccessibleDescription(this.fromWSDLUrlButton.getText());
            this.fromWSDLUrlButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromWSDLUrl_mnem").charAt(0));
            this.fromExistingCodeButton = new JCheckBox(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromExistingCode"));
            this.fromExistingCodeButton.getAccessibleContext().setAccessibleDescription(this.fromExistingCodeButton.getText());
            this.fromExistingCodeButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_FromExistingCode_mnem").charAt(0));
            this.wsdlFileTextField = new JTextField();
            this.wsdlFileTextField.getDocument().addDocumentListener(this);
            this.wsdlFileTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"A11Y_WSDL_TF"));
            this.browseButton = new JButton(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_Browse"));
            this.browseButton.getAccessibleContext().setAccessibleDescription(this.browseButton.getText());
            this.browseButton.setMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_Browse_mnem").charAt(0));
            this.urlLabel = new JLabel(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_UrlLabel"));
            this.urlLabel.setDisplayedMnemonic(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_UrlLabel_mnem").charAt(0));
            this.urlTextField = new JTextField();
            this.urlLabel.setLabelFor(this.urlTextField);
            this.urlTextField.getDocument().addDocumentListener(this);
            this.urlTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"A11Y_WSDL_URL_TF"));
            this.setLayout(new GridBagLayout());
            this.setBorder(new TitledBorder(NbBundle.getMessage(WebServiceWizardPanel.class, (String)"LBL_WebService_Type")));
            this.typeButtons.add(this.fromScratchButton);
            this.typeButtons.add(this.fromWSDLButton);
            this.typeButtons.add(this.fromWSDLUrlButton);
            this.fromScratchButton.setSelected(true);
            this.browseButton.setEnabled(false);
            this.urlTextField.setEnabled(false);
            this.wsdlFileTextField.setEnabled(false);
            this.wsdlFilePanel = new JPanel();
            this.wsdlFilePanel.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 4.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.wsdlFilePanel.add((Component)this.wsdlFileTextField, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 10, 0, 24);
            this.wsdlFilePanel.add((Component)this.browseButton, gridBagConstraints);
            this.urlPanel = new JPanel();
            this.urlPanel.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.urlPanel.add((Component)this.urlLabel, gridBagConstraints);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridx = 1;
            this.urlPanel.add((Component)this.urlTextField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.add((Component)this.fromScratchButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 2.0;
            this.add((Component)this.fromExistingCodeButton, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            this.add((Component)this.fromWSDLButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 24);
            this.add((Component)this.wsdlFilePanel, gridBagConstraints);
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            this.add((Component)this.fromWSDLUrlButton, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 50);
            this.add((Component)this.urlPanel, gridBagConstraints);
        }

        public void addNotify() {
            Container guiPanel;
            super.addNotify();
            WebServiceWizardDescriptor.this.nameField = null;
            Container holderPanel = this.getParent();
            if (holderPanel != null && (guiPanel = holderPanel.getParent()) != null) {
                WebServiceWizardDescriptor.this.nameField = this.getFirstTextField(guiPanel);
            }
        }

        private JTextField getFirstTextField(Container top) {
            JTextField result = null;
            Component[] components = top.getComponents();
            for (int i = 0; i < components.length && result == null; ++i) {
                if (components[i] instanceof JTextField) {
                    result = (JTextField)components[i];
                    continue;
                }
                if (!(components[i] instanceof Container)) continue;
                result = this.getFirstTextField((Container)components[i]);
            }
            return result;
        }

        public JRadioButton getFromWSDLButton() {
            return this.fromWSDLButton;
        }

        public JRadioButton getFromWSDLUrlButton() {
            return this.fromWSDLUrlButton;
        }

        public boolean isFromScratch() {
            return this.fromScratchButton.isSelected() && !this.fromExistingCodeButton.isSelected();
        }

        public boolean isFromWSDL() {
            return this.fromWSDLButton.isSelected();
        }

        public boolean isFromWSDLUrl() {
            return this.fromWSDLUrlButton.isSelected();
        }

        public boolean isFromExistingCode() {
            return this.fromScratchButton.isSelected() && this.fromExistingCodeButton.isSelected();
        }

        public WebServiceWizardHelper getWizardHelper() {
            return this.helper;
        }

        private void addListeners() {
            final WebServiceWizard wiz = this.helper.getWizard();
            this.fromScratchButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!WebServiceWizardPanel.this.fromExistingCodeButton.isEnabled()) {
                        WebServiceWizardPanel.this.fromExistingCodeButton.setEnabled(true);
                    }
                    if (WebServiceWizardPanel.this.browseButton.isEnabled()) {
                        WebServiceWizardPanel.this.browseButton.setEnabled(false);
                    }
                    if (WebServiceWizardPanel.this.wsdlFileTextField.isEnabled()) {
                        WebServiceWizardPanel.this.wsdlFileTextField.setEnabled(false);
                    }
                    if (WebServiceWizardPanel.this.urlTextField.isEnabled()) {
                        WebServiceWizardPanel.this.urlTextField.setEnabled(false);
                    }
                    if (!WebServiceWizardPanel.this.fromExistingCodeButton.isSelected()) {
                        wiz.setPanelsAndSteps(0);
                    } else {
                        wiz.setPanelsAndSteps(1);
                    }
                    WebServiceWizardPanel.this.fireStateChanged();
                }
            });
            this.fromExistingCodeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (WebServiceWizardPanel.this.fromExistingCodeButton.isSelected()) {
                        wiz.setPanelsAndSteps(1);
                    } else {
                        wiz.setPanelsAndSteps(0);
                    }
                    WebServiceWizardPanel.this.fireStateChanged();
                }
            });
            this.fromWSDLButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (!WebServiceWizardPanel.this.wsdlFileTextField.isEnabled()) {
                        WebServiceWizardPanel.this.wsdlFileTextField.setEnabled(true);
                    }
                    if (!WebServiceWizardPanel.this.browseButton.isEnabled()) {
                        WebServiceWizardPanel.this.browseButton.setEnabled(true);
                    }
                    if (WebServiceWizardPanel.this.urlTextField.isEnabled()) {
                        WebServiceWizardPanel.this.urlTextField.setEnabled(false);
                    }
                    WebServiceWizardPanel.this.helper.getWizard().setPanelsAndSteps(2);
                    if (WebServiceWizardPanel.this.fromExistingCodeButton.isSelected()) {
                        WebServiceWizardPanel.this.fromExistingCodeButton.setSelected(false);
                    }
                    WebServiceWizardPanel.this.fromExistingCodeButton.setEnabled(false);
                    WebServiceWizardPanel.this.fireStateChanged();
                }
            });
            this.fromWSDLUrlButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    WebServiceWizardPanel.this.helper.getWizard().setPanelsAndSteps(3);
                    if (!WebServiceWizardPanel.this.urlTextField.isEnabled()) {
                        WebServiceWizardPanel.this.urlTextField.setEnabled(true);
                    }
                    if (WebServiceWizardPanel.this.fromExistingCodeButton.isSelected()) {
                        WebServiceWizardPanel.this.fromExistingCodeButton.setSelected(false);
                    }
                    WebServiceWizardPanel.this.fromExistingCodeButton.setEnabled(false);
                    if (WebServiceWizardPanel.this.browseButton.isEnabled()) {
                        WebServiceWizardPanel.this.browseButton.setEnabled(false);
                    }
                    if (WebServiceWizardPanel.this.wsdlFileTextField.isEnabled()) {
                        WebServiceWizardPanel.this.wsdlFileTextField.setEnabled(false);
                    }
                    WebServiceWizardPanel.this.fireStateChanged();
                }
            });
            this.browseButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    JFileChooser chooser = new JFileChooser(previousDirectory);
                    chooser.setMultiSelectionEnabled(false);
                    chooser.setAcceptAllFileFilterUsed(false);
                    chooser.addChoosableFileFilter(WebServiceWizardPanel.this.WSDL_FILE_FILTER);
                    chooser.setFileFilter(WebServiceWizardPanel.this.WSDL_FILE_FILTER);
                    if (chooser.showOpenDialog(WebServiceWizardPanel.this) == 0) {
                        File wsdlFile = chooser.getSelectedFile();
                        WebServiceWizardPanel.this.wsdlFileTextField.setText(wsdlFile.getAbsolutePath());
                        previousDirectory = wsdlFile.getPath();
                    }
                }
            });
        }

        public void changedUpdate(DocumentEvent e) {
            this.fireStateChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            this.fireStateChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            this.fireStateChanged();
        }

        public String getWSDLFilePath() {
            return this.wsdlFileTextField.getText();
        }

        public String getWSDLUrl() {
            return this.urlTextField.getText();
        }

        void readSettings(WizardDescriptor wizDescriptor) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    WebServiceWizardPanel.this.fireStateChanged();
                }
            });
        }

        void storeSettings(WizardDescriptor wizDescriptor) {
            wizDescriptor.putProperty("wsdlfilepath", (Object)this.wsdlFileTextField.getText().trim());
            wizDescriptor.putProperty("wsdlfileurl", (Object)this.urlTextField.getText().trim());
        }

        private void fireStateChanged() {
            if (WebServiceWizardDescriptor.this.listener != null) {
                ChangeEvent evt = new ChangeEvent(this);
                WebServiceWizardDescriptor.this.listener.stateChanged(evt);
            }
        }
    }
}

