/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.beans;

import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import javax.jmi.reflect.JmiException;
import org.netbeans.jmi.javamodel.Method;
import org.netbeans.jmi.javamodel.Type;
import org.netbeans.modules.beans.IdxPropertyPattern;
import org.netbeans.modules.beans.IdxPropertyTypeEditor;
import org.netbeans.modules.beans.PatternNode;
import org.netbeans.modules.beans.PropertyPattern;
import org.netbeans.modules.beans.PropertyPatternNode;
import org.netbeans.modules.beans.PropertyTypeEditor;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public final class IdxPropertyPatternNode
extends PropertyPatternNode {
    public IdxPropertyPatternNode(IdxPropertyPattern pattern, boolean writeable) {
        super(pattern, writeable);
    }

    protected String resolveIconBase() {
        switch (((PropertyPattern)this.pattern).getMode()) {
            case 1: {
                return "org/netbeans/modules/beans/resources/propertyIndexedRW";
            }
            case 2: {
                return "org/netbeans/modules/beans/resources/propertyIndexedRO";
            }
            case 4: {
                return "org/netbeans/modules/beans/resources/propertyIndexedWO";
            }
        }
        return null;
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createIndexedTypeProperty(this.writeable));
        ps.put(this.createIndexGetterProperty(false));
        ps.put(this.createIndexSetterProperty(false));
        return sheet;
    }

    String getTypeForHint() {
        return PatternNode.getString("HINT_IndexedProperty");
    }

    public Node cloneNode() {
        return new IdxPropertyPatternNode((IdxPropertyPattern)this.pattern, this.writeable);
    }

    protected Node.Property createIndexedTypeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("indexedType", Type.class, canW){

            public Object getValue() {
                return ((IdxPropertyPattern)IdxPropertyPatternNode.this.pattern).getIndexedType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    IdxPropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((IdxPropertyPattern)IdxPropertyPatternNode.this.pattern).setIndexedType((Type)val);
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    IdxPropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new PropertyTypeEditor();
            }
        };
    }

    protected Node.Property createTypeProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("type", Type.class, canW){

            public Object getValue() {
                return ((PropertyPattern)IdxPropertyPatternNode.this.pattern).getType();
            }

            public void setValue(Object val) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
                super.setValue(val);
                if (!(val instanceof Type)) {
                    throw new IllegalArgumentException();
                }
                try {
                    IdxPropertyPatternNode.this.pattern.patternAnalyser.setIgnore(true);
                    ((PropertyPattern)IdxPropertyPatternNode.this.pattern).setType((Type)val);
                }
                catch (JmiException e) {
                    throw new InvocationTargetException(e);
                }
                finally {
                    IdxPropertyPatternNode.this.pattern.patternAnalyser.setIgnore(false);
                }
            }

            public PropertyEditor getPropertyEditor() {
                return new IdxPropertyTypeEditor();
            }
        };
    }

    protected Node.Property createIndexGetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("indexedGetter", String.class, canW){

            public Object getValue() {
                Method method = ((IdxPropertyPattern)IdxPropertyPatternNode.this.pattern).getIndexedGetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }

    protected Node.Property createIndexSetterProperty(boolean canW) {
        return new PatternNode.PatternPropertySupport("indexedSetter", String.class, canW){

            public Object getValue() {
                Method method = ((IdxPropertyPattern)IdxPropertyPatternNode.this.pattern).getIndexedSetterMethod();
                return PatternNode.getFormattedMethodName(method);
            }
        };
    }
}

