/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.editor.completion;

import java.awt.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.text.Document;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.NbJavaJMISyntaxSupport;
import org.netbeans.modules.websvc.editor.completion.Utils;
import org.netbeans.modules.websvc.editor.completion.WSResultItem;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FileAttributeSupport {
    private static String FILE_PROTOCOL_TEXT = "file://";

    /*
     * WARNING - void declaration
     */
    static List completionResults(int offset, NbJavaJMISyntaxSupport sup, BaseDocument doc, String valuePart, boolean requiresFileProtocolPrefix) {
        List<WSResultItem.PackageResultItem> res = new ArrayList<WSResultItem.FileProtocolResultItem>();
        boolean valueQuoted = valuePart.startsWith("\"");
        valuePart = Utils.unquote(valuePart);
        if (requiresFileProtocolPrefix) {
            if (FILE_PROTOCOL_TEXT.indexOf(valuePart) == 0 && FILE_PROTOCOL_TEXT.length() != valuePart.length() || valuePart.length() == 0) {
                WSResultItem.FileProtocolResultItem ri = new WSResultItem.FileProtocolResultItem(valueQuoted);
                res.add(0, (WSResultItem.PackageResultItem)((Object)ri));
                ri.setSubstituteOffset(offset - valuePart.length());
                return res;
            }
            if (!valuePart.startsWith(FILE_PROTOCOL_TEXT)) {
                return Collections.EMPTY_LIST;
            }
            valuePart = valuePart.substring(FILE_PROTOCOL_TEXT.length());
        } else if (!valueQuoted) {
            return Collections.EMPTY_LIST;
        }
        if (valuePart.startsWith("/")) {
            ErrorManager.getDefault().log(1, "completion of absolute paths hasn't been implemented yet!");
            return Collections.EMPTY_LIST;
        }
        String path = "";
        String fileNamePart = valuePart;
        int lastSlash = valuePart.lastIndexOf(47);
        if (lastSlash == 0) {
            path = "/";
            fileNamePart = valuePart.substring(1);
        } else if (lastSlash > 0) {
            path = valuePart.substring(0, lastSlash);
            fileNamePart = lastSlash == valuePart.length() ? "" : valuePart.substring(lastSlash + 1);
        }
        try {
            void var13_21;
            FileObject orig = NbEditorUtilities.getFileObject((Document)doc);
            if (orig == null) {
                ErrorManager.getDefault().log(1, "Cannot get FileObject from the edited document!");
                return res;
            }
            Project project = FileOwnerQuery.getOwner((FileObject)orig);
            FileObject base = project.getProjectDirectory();
            String string = FileAttributeSupport.resolveRelativeURL("/" + orig.getPath(), path);
            if (path.startsWith("/")) {
                String string2 = base.getPath() + path;
            } else {
                String string3 = string.substring(1);
            }
            FileSystem fs = orig.getFileSystem();
            FileObject folder = fs.findResource((String)var13_21);
            if (folder != null) {
                res = FileAttributeSupport.files(folder, fileNamePart, sup);
                if (!folder.equals(base) && !path.startsWith("/") && (path.length() == 0 && fileNamePart.length() == 0 || path.lastIndexOf("../") + 3 == path.length())) {
                    res.add(0, new WSResultItem.PackageResultItem("../"));
                }
            }
        }
        catch (FileStateInvalidException ex) {
        }
        catch (IllegalArgumentException ex) {
            // empty catch block
        }
        int itemOffset = offset - valuePart.length() + lastSlash + 1;
        int itemLength = fileNamePart.length();
        for (WSResultItem wSResultItem : res) {
            wSResultItem.setSubstituteOffset(itemOffset);
        }
        return res;
    }

    private static List files(FileObject folder, String prefix, NbJavaJMISyntaxSupport sup) {
        ArrayList res = new ArrayList();
        TreeMap<String, WSResultItem.PackageResultItem> resFolders = new TreeMap<String, WSResultItem.PackageResultItem>();
        TreeMap<String, WSResultItem.FileResultItem> resFiles = new TreeMap<String, WSResultItem.FileResultItem>();
        Enumeration files = folder.getChildren(false);
        while (files.hasMoreElements()) {
            FileObject file = (FileObject)files.nextElement();
            String fname = file.getNameExt();
            if (!fname.startsWith(prefix) || "cvs".equalsIgnoreCase(fname)) continue;
            if (file.isFolder()) {
                resFolders.put(file.getNameExt(), new WSResultItem.PackageResultItem(file.getNameExt() + "/"));
                continue;
            }
            Image icon = FileAttributeSupport.getIcon(file);
            resFiles.put(file.getNameExt(), new WSResultItem.FileResultItem(file.getNameExt(), icon));
        }
        res.addAll(resFolders.values());
        res.addAll(resFiles.values());
        return res;
    }

    private static Image getIcon(FileObject fo) {
        Image icon = null;
        try {
            icon = DataObject.find((FileObject)fo).getNodeDelegate().getIcon(1);
        }
        catch (DataObjectNotFoundException e) {
            e.printStackTrace(System.out);
        }
        return icon;
    }

    private static String resolveRelativeURL(String relativeTo, String url) {
        String result;
        if (url.startsWith("/")) {
            result = "/";
            url = url.substring(1);
        } else {
            if (relativeTo == null || !relativeTo.startsWith("/")) {
                throw new IllegalArgumentException();
            }
            int lastSlash = (relativeTo = FileAttributeSupport.resolveRelativeURL(null, relativeTo)).lastIndexOf(47);
            if (lastSlash == -1) {
                throw new IllegalArgumentException();
            }
            result = relativeTo.substring(0, lastSlash + 1);
        }
        StringTokenizer st = new StringTokenizer(url, "/", true);
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("/")) {
                if (result.endsWith("/")) continue;
                result = result + "/";
                continue;
            }
            if (tok.equals("") || tok.equals(".")) continue;
            if (tok.equals("..")) {
                String withoutSlash = result.substring(0, result.length() - 1);
                int ls = withoutSlash.lastIndexOf("/");
                if (ls == -1) continue;
                result = withoutSlash.substring(0, ls + 1);
                continue;
            }
            result = result + tok;
        }
        return result;
    }
}

