/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.JPDAThreadGroup;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;

public class JPDAThreadGroupImpl
implements JPDAThreadGroup {
    private ThreadGroupReference tgr;
    private JPDADebuggerImpl debugger;

    public JPDAThreadGroupImpl(ThreadGroupReference tgr, JPDADebuggerImpl debugger) {
        this.tgr = tgr;
        this.debugger = debugger;
    }

    public JPDAThreadGroup getParentThreadGroup() {
        ThreadGroupReference ptgr = this.tgr.parent();
        if (ptgr == null) {
            return null;
        }
        return this.debugger.getThreadGroup(ptgr);
    }

    public JPDAThread[] getThreads() {
        List<ThreadReference> l = this.tgr.threads();
        int k = l.size();
        JPDAThread[] ts = new JPDAThread[k];
        for (int i = 0; i < k; ++i) {
            ts[i] = this.debugger.getThread(l.get(i));
        }
        return ts;
    }

    public JPDAThreadGroup[] getThreadGroups() {
        List<ThreadGroupReference> l = this.tgr.threadGroups();
        int k = l.size();
        JPDAThreadGroup[] ts = new JPDAThreadGroup[k];
        for (int i = 0; i < k; ++i) {
            ts[i] = this.debugger.getThreadGroup(l.get(i));
        }
        return ts;
    }

    public String getName() {
        return this.tgr.name();
    }

    public void resume() {
        List<ThreadReference> threads = this.tgr.threads();
        Iterator<ThreadReference> it = threads.iterator();
        while (it.hasNext()) {
            JPDAThreadImpl thread = (JPDAThreadImpl)this.debugger.getThread(it.next());
            thread.notifyToBeRunning();
        }
        this.tgr.resume();
    }

    public void suspend() {
        this.tgr.suspend();
        List<ThreadReference> threads = this.tgr.threads();
        Iterator<ThreadReference> it = threads.iterator();
        while (it.hasNext()) {
            JPDAThreadImpl thread = (JPDAThreadImpl)this.debugger.getThread(it.next());
            thread.notifySuspended();
        }
    }
}

