/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes.actions;

import java.io.File;
import javax.enterprise.deploy.shared.ModuleType;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.UndeployModuleCookie;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class UndeployModuleCookieImpl
implements UndeployModuleCookie {
    private String fileName;
    private Lookup lookup;
    private ModuleType type;
    private final boolean isEJB3;
    private boolean isRunning;

    public UndeployModuleCookieImpl(String fileName, ModuleType type, Lookup lookup) {
        this(fileName, type, false, lookup);
    }

    public UndeployModuleCookieImpl(String fileName, Lookup lookup) {
        this(fileName, ModuleType.EJB, true, lookup);
    }

    private UndeployModuleCookieImpl(String fileName, ModuleType type, boolean isEJB3, Lookup lookup) {
        this.lookup = lookup;
        this.fileName = fileName;
        this.type = type;
        this.isEJB3 = isEJB3;
        this.isRunning = false;
    }

    public RequestProcessor.Task undeploy() {
        final JBDeploymentManager dm = (JBDeploymentManager)this.lookup.lookup(JBDeploymentManager.class);
        final String nameWoExt = this.fileName.substring(0, this.fileName.lastIndexOf(46));
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(UndeployModuleCookieImpl.class, (String)"LBL_UndeployProgress", (Object)nameWoExt));
        Runnable r = new Runnable(){

            public void run() {
                UndeployModuleCookieImpl.this.isRunning = true;
                String deployDir = dm.getInstanceProperties().getProperty("deploy-dir");
                File file = new File(deployDir, UndeployModuleCookieImpl.this.fileName);
                if (file.exists() && file.canWrite()) {
                    file.delete();
                    try {
                        ObjectName searchPattern = null;
                        if (Util.isRemoteManagementSupported(UndeployModuleCookieImpl.this.lookup) && !UndeployModuleCookieImpl.this.isEJB3) {
                            searchPattern = new ObjectName("jboss.management.local:" + (!UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR) ? "J2EEApplication=null," : "") + "j2eeType=" + Util.getModuleTypeString(UndeployModuleCookieImpl.this.type) + ",name=" + UndeployModuleCookieImpl.this.fileName + ",*");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EAR)) {
                            searchPattern = new ObjectName("jboss.j2ee:service=EARDeployment,url='" + UndeployModuleCookieImpl.this.fileName + "'");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.WAR)) {
                            searchPattern = new ObjectName("jboss.web:j2eeType=WebModule,J2EEApplication=none,name=//localhost/" + nameWoExt + ",*");
                        } else if (UndeployModuleCookieImpl.this.type.equals(ModuleType.EJB)) {
                            searchPattern = new ObjectName("jboss.j2ee:service=" + (UndeployModuleCookieImpl.this.isEJB3 ? "EJB3" : "EjbModule") + ",module=" + UndeployModuleCookieImpl.this.fileName);
                        }
                        int time = 0;
                        while (dm.refreshRMIServer() != null && Util.isObjectDeployed(dm.getRMIServer(), searchPattern) && time < 30000) {
                            try {
                                Thread.sleep(2000L);
                                time += 2000;
                            }
                            catch (InterruptedException ex) {}
                        }
                    }
                    catch (MalformedObjectNameException ex) {
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
                handle.finish();
                UndeployModuleCookieImpl.this.isRunning = false;
            }
        };
        handle.start();
        return RequestProcessor.getDefault().post(r);
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

