/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.i18n.FactoryRegistry;
import org.netbeans.modules.i18n.I18nOptions;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;
import org.openide.util.SharedClassObject;

public final class I18nUtil {
    public static final String HELP_ID_I18N = "internation.internation";
    public static final String HELP_ID_AUTOINSERT = "internation.autoinsert";
    public static final String HELP_ID_MANINSERT = "internation.maninsert";
    public static final String HELP_ID_FORMED = "internation.formed";
    public static final String HELP_ID_TESTING = "internation.testing";
    public static final String HELP_ID_WIZARD = "internation.wizard";
    public static final String HELP_ID_CUSTOM = "internation.custom";
    public static final String HELP_ID_ADDPARAMS = "internation.addparams";
    public static final String HELP_ID_REPLFORMAT = "internation.replformat";
    public static final String HELP_ID_RUNLOCALE = "internation.runlocale";
    public static final String PE_REPLACE_CODE_HELP_ID = "i18n.pe.replacestring";
    public static final String PE_I18N_REGEXP_HELP_ID = "i18n.pe.i18nregexp";
    public static final String PE_BUNDLE_CODE_HELP_ID = "i18n.pe.bundlestring";
    public static final String PE_TEST_REGEXP_HELP_ID = "i18n.pe.testregexp";
    public static final String PE_I18N_STRING_HELP_ID = "i18n.pe.i18nString";
    private static List initFormatItems;
    private static List initHelpItems;
    private static List replaceFormatItems;
    private static List replaceHelpItems;
    private static List regExpItems;
    private static List regExpHelpItems;
    private static List i18nRegExpItems;

    public static List getInitFormatItems() {
        if (initFormatItems == null) {
            initFormatItems = new ArrayList(2);
            initFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\")");
            initFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class)");
        }
        return initFormatItems;
    }

    public static List getInitHelpItems() {
        if (initHelpItems == null) {
            ResourceBundle bundle = I18nUtil.getBundle();
            initHelpItems = new ArrayList(3);
            initHelpItems.add("{bundleNameSlashes} - " + bundle.getString("TXT_PackageNameSlashes"));
            initHelpItems.add("{bundleNameDots} - " + bundle.getString("TXT_PackageNameDots"));
            initHelpItems.add("{sourceFileName} - " + bundle.getString("TXT_SourceDataObjectName"));
        }
        return initHelpItems;
    }

    public static List getReplaceFormatItems() {
        if (replaceFormatItems == null) {
            replaceFormatItems = new ArrayList(7);
            replaceFormatItems.add("{identifier}.getString(\"{key}\")");
            replaceFormatItems.add("Utilities.getString(\"{key}\")");
            replaceFormatItems.add("java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getBundle({sourceFileName}.class).getString(\"{key}\")");
            replaceFormatItems.add("java.text.MessageFormat(java.util.ResourceBundle.getBundle(\"{bundleNameSlashes}\").getString(\"{key}\"), {arguments})");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\")");
            replaceFormatItems.add("org.openide.util.NbBundle.getMessage({sourceFileName}.class, \"{key}\", {arguments})");
        }
        return replaceFormatItems;
    }

    public static List getReplaceHelpItems() {
        if (replaceHelpItems == null) {
            ResourceBundle bundle = I18nUtil.getBundle();
            replaceHelpItems = new ArrayList(6);
            replaceHelpItems.add("{identifier} - " + bundle.getString("TXT_FieldIdentifier"));
            replaceHelpItems.add("{key} - " + bundle.getString("TXT_KeyHelp"));
            replaceHelpItems.add("{bundleNameSlashes} - " + bundle.getString("TXT_PackageNameSlashes"));
            replaceHelpItems.add("{bundleNameDots} - " + bundle.getString("TXT_PackageNameDots"));
            replaceHelpItems.add("{sourceFileName} - " + bundle.getString("TXT_SourceDataObjectName"));
            replaceHelpItems.add("{arguments} - " + bundle.getString("TXT_Arguments"));
        }
        return replaceHelpItems;
    }

    public static List getRegExpItems() {
        if (regExpItems == null) {
            regExpItems = new ArrayList(4);
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}|// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*{hardString}");
            regExpItems.add("// NOI18N");
            regExpItems.add("(getString|getBundle)[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*{hardString}|// NOI18N");
        }
        return regExpItems;
    }

    public static List getI18nRegExpItems() {
        if (i18nRegExpItems == null) {
            i18nRegExpItems = new ArrayList(2);
            i18nRegExpItems.add("getString[:space:]*\\([:space:]*{hardString}");
            i18nRegExpItems.add("(getString[:space:]*\\([:space:]*|getMessage[:space:]*\\(([:alnum:]|[:punct:]|[:space:])*,[:space:]*){hardString}");
        }
        return i18nRegExpItems;
    }

    public static List getRegExpHelpItems() {
        if (regExpHelpItems == null) {
            ResourceBundle bundle = I18nUtil.getBundle();
            regExpHelpItems = new ArrayList(13);
            regExpHelpItems.add("{hardString} - " + bundle.getString("TXT_HardString"));
            regExpHelpItems.add("[:alnum:] - " + bundle.getString("TXT_Alnum"));
            regExpHelpItems.add("[:alpha:] - " + bundle.getString("TXT_Alpha"));
            regExpHelpItems.add("[:blank:] - " + bundle.getString("TXT_Blank"));
            regExpHelpItems.add("[:cntrl:] - " + bundle.getString("TXT_Cntrl"));
            regExpHelpItems.add("[:digit:] - " + bundle.getString("TXT_Digit"));
            regExpHelpItems.add("[:graph:] - " + bundle.getString("TXT_Graph"));
            regExpHelpItems.add("[:lower:] - " + bundle.getString("TXT_Lower"));
            regExpHelpItems.add("[:print:] - " + bundle.getString("TXT_Print"));
            regExpHelpItems.add("[:punct:] - " + bundle.getString("TXT_Punct"));
            regExpHelpItems.add("[:space:] - " + bundle.getString("TXT_Space"));
            regExpHelpItems.add("[:upper:] - " + bundle.getString("TXT_Upper"));
            regExpHelpItems.add("[:xdigit:] - " + bundle.getString("TXT_Xdigit"));
        }
        return regExpHelpItems;
    }

    public static boolean containsAcceptedDataObject(DataFolder folder) {
        int i;
        DataObject[] children = folder.getChildren();
        DataObject[] folders = new DataObject[children.length];
        int foldersCount = 0;
        for (i = 0; i < children.length; ++i) {
            if (children[i] instanceof DataFolder) {
                folders[foldersCount++] = children[i];
                continue;
            }
            if (!FactoryRegistry.hasFactory(children[i].getClass())) continue;
            return true;
        }
        for (i = 0; i < foldersCount; ++i) {
            if (!I18nUtil.containsAcceptedDataObject((DataFolder)children[i])) continue;
            return true;
        }
        return false;
    }

    public static List getAcceptedDataObjects(DataObject.Container folder) {
        ArrayList<DataObject> accepted = new ArrayList<DataObject>();
        VisibilityQuery visQuery = VisibilityQuery.getDefault();
        DataObject[] children = folder.getChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!visQuery.isVisible(children[i].getPrimaryFile())) continue;
            if (children[i] instanceof DataObject.Container) {
                accepted.addAll(I18nUtil.getAcceptedDataObjects((DataObject.Container)children[i]));
                continue;
            }
            if (!FactoryRegistry.hasFactory(children[i].getClass())) continue;
            accepted.add(children[i]);
        }
        return accepted;
    }

    public static ResourceBundle getBundle() {
        return NbBundle.getBundle((Class)I18nUtil.class);
    }

    public static I18nOptions getOptions() {
        return (I18nOptions)SharedClassObject.findObject((Class)I18nOptions.class, (boolean)true);
    }
}

