/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ant;

import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.StringReader;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.LifecycleManager;
import org.openide.NotifyDescriptor;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class AntProjectModule
extends ModuleInstall {
    public void restored() {
        super.restored();
        if (Boolean.getBoolean("netbeans.do.not.check.xalan")) {
            return;
        }
        long start = System.currentTimeMillis();
        boolean isBuggyXalan = this.checkForXalan();
        long end = System.currentTimeMillis();
        if (ErrorManager.getDefault().isLoggable(1)) {
            ErrorManager.getDefault().log(1, "check for buggy xalan took: " + (end - start));
        }
        if (isBuggyXalan) {
            this.showWarning();
        }
    }

    private boolean checkForXalan() {
        if (System.getProperty("java.specification.version").startsWith("1.4")) {
            return false;
        }
        try {
            Class<?> version = XMLUtil.class.getClassLoader().loadClass("org.apache.xalan.Version");
            return !this.verifyWriterCorrect();
        }
        catch (ClassNotFoundException ex) {
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return false;
    }

    private boolean verifyPlainAccess() throws Exception {
        String IDENTITY_XSLT_WITH_INDENT = "<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>";
        String data = "<root xmlns='root'/>";
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new InputSource(new StringReader(data)));
        doc.getDocumentElement().appendChild(doc.createElementNS("child", "child"));
        Transformer t = TransformerFactory.newInstance().newTransformer(new StreamSource(new StringReader("<xsl:stylesheet version='1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:xalan='http://xml.apache.org/xslt' exclude-result-prefixes='xalan'><xsl:output method='xml' indent='yes' xalan:indent-amount='4'/><xsl:template match='@*|node()'><xsl:copy><xsl:apply-templates select='@*|node()'/></xsl:copy></xsl:template></xsl:stylesheet>")));
        DOMSource source = new DOMSource(doc);
        CharArrayWriter output = new CharArrayWriter();
        StreamResult result = new StreamResult(output);
        t.transform(source, result);
        output.close();
        String text = output.toString();
        return text.indexOf("\"child\"") != -1 || text.indexOf("'child'") != -1;
    }

    private boolean verifyWriterCorrect() throws Exception {
        return this.verifyPlainAccess();
    }

    private void showWarning() {
        NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage((Class)AntProjectModule.class, (String)"LBL_Incompatible_Xalan"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Frame f = WindowManager.getDefault().getMainWindow();
                if (f == null || f.isShowing()) {
                    LifecycleManager.getDefault().exit();
                } else {
                    f.addWindowListener(new WindowAdapter(){

                        public void windowOpened(WindowEvent e) {
                            LifecycleManager.getDefault().exit();
                        }
                    });
                }
            }
        });
    }
}

