/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.FolderLookup;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public final class ProjectNodeWrapper
extends FilterNode
implements Runnable,
FileStatusListener,
ChangeListener,
PropertyChangeListener {
    private Set files;
    private Map fileSystemListeners;
    private RequestProcessor.Task task;
    private final Object privateLock = new Object();
    private boolean iconChange;
    private boolean nameChange;
    private ChangeListener sourcesListener;
    private Map groupsListeners;
    public static final Action GENERIC_PROJECTS_ACTIONS_MARKER = new AbstractAction(){

        public void actionPerformed(ActionEvent e) {
        }
    };
    static /* synthetic */ Class class$java$lang$Object;

    public ProjectNodeWrapper(Node toWrap) {
        super(toWrap);
        this.setProjectFiles();
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Action> result = new ArrayList<Action>();
        for (int cntr = 0; cntr < actions.length; ++cntr) {
            if (actions[cntr] != GENERIC_PROJECTS_ACTIONS_MARKER) {
                result.add(actions[cntr]);
                continue;
            }
            try {
                Repository repository = Repository.getDefault();
                FileSystem sfs = repository.getDefaultFileSystem();
                FileObject fo = sfs.findResource("Projects/Actions");
                if (fo == null) continue;
                DataObject dobj = DataObject.find((FileObject)fo);
                FolderLookup actionRegistry = new FolderLookup((DataObject.Container)((DataFolder)dobj));
                Lookup.Template query = new Lookup.Template(class$java$lang$Object == null ? ProjectNodeWrapper.class$("java.lang.Object") : class$java$lang$Object);
                Lookup lookup = actionRegistry.getLookup();
                Iterator it = lookup.lookup(query).allInstances().iterator();
                if (it.hasNext()) {
                    result.add(null);
                }
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next instanceof Action) {
                        result.add((Action)next);
                        continue;
                    }
                    if (!(next instanceof JSeparator)) continue;
                    result.add(null);
                }
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return result.toArray(new Action[result.size()]);
    }

    protected final void setProjectFiles() {
        Project prj = (Project)this.getLookup().lookup(Project.class);
        if (prj != null) {
            this.setProjectFiles(prj);
        } else {
            ErrorManager.getDefault().log(1, "Node: " + this.getOriginal() + " wrapped with ProjectNodeWrapper, but does not contain a Project in the lookup!");
        }
    }

    protected final void setProjectFiles(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        if (this.sourcesListener == null) {
            this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
            sources.addChangeListener(this.sourcesListener);
        }
        this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
    }

    private final void setGroups(Collection groups) {
        if (this.groupsListeners != null) {
            Iterator it = this.groupsListeners.keySet().iterator();
            while (it.hasNext()) {
                SourceGroup group = (SourceGroup)it.next();
                PropertyChangeListener pcl = (PropertyChangeListener)this.groupsListeners.get(group);
                group.removePropertyChangeListener(pcl);
            }
        }
        this.groupsListeners = new HashMap();
        HashSet<FileObject> roots = new HashSet<FileObject>();
        Iterator it = groups.iterator();
        while (it.hasNext()) {
            SourceGroup group = (SourceGroup)it.next();
            PropertyChangeListener pcl = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group);
            this.groupsListeners.put(group, pcl);
            group.addPropertyChangeListener(pcl);
            FileObject fo = group.getRootFolder();
            roots.add(fo);
        }
        this.setFiles(roots);
    }

    protected final void setFiles(Set files) {
        Iterator<Object> it;
        if (this.fileSystemListeners != null) {
            it = this.fileSystemListeners.keySet().iterator();
            while (it.hasNext()) {
                FileSystem fs = (FileSystem)it.next();
                FileStatusListener fsl = (FileStatusListener)this.fileSystemListeners.get(fs);
                fs.removeFileStatusListener(fsl);
            }
        }
        this.fileSystemListeners = new HashMap();
        this.files = files;
        if (files == null) {
            return;
        }
        it = files.iterator();
        HashSet<FileSystem> hookedFileSystems = new HashSet<FileSystem>();
        while (it.hasNext()) {
            FileObject fo = (FileObject)it.next();
            try {
                FileSystem fs = fo.getFileSystem();
                if (hookedFileSystems.contains(fs)) continue;
                hookedFileSystems.add(fs);
                FileStatusListener fsl = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fs);
                fs.addFileStatusListener(fsl);
                this.fileSystemListeners.put(fs, fsl);
            }
            catch (FileStateInvalidException e) {
                ErrorManager err = ErrorManager.getDefault();
                err.annotate((Throwable)e, "Can not get " + fo + " filesystem, ignoring...");
                err.notify(1, (Throwable)e);
            }
        }
    }

    public Image getIcon(int type) {
        Image img = super.getIcon(type);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fo = (FileObject)this.files.iterator().next();
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return img;
    }

    public Image getOpenedIcon(int type) {
        Image img = super.getOpenedIcon(type);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fo = (FileObject)this.files.iterator().next();
                img = fo.getFileSystem().getStatus().annotateIcon(img, type, this.files);
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
        return img;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean fireName;
        boolean fireIcon;
        Object object = this.privateLock;
        synchronized (object) {
            fireIcon = this.iconChange;
            fireName = this.nameChange;
            this.iconChange = false;
            this.nameChange = false;
        }
        if (fireIcon) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
        if (fireName) {
            this.fireDisplayNameChange(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationChanged(FileStatusEvent event) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        Object object = this.privateLock;
        synchronized (object) {
            if (!this.iconChange && event.isIconChange() || !this.nameChange && event.isNameChange()) {
                Iterator it = this.files.iterator();
                while (it.hasNext()) {
                    FileObject fo = (FileObject)it.next();
                    if (!event.hasChanged(fo)) continue;
                    this.iconChange |= event.isIconChange();
                    this.nameChange |= event.isNameChange();
                }
            }
        }
        this.task.schedule(50);
    }

    public void stateChanged(ChangeEvent e) {
        this.setProjectFiles();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.setProjectFiles();
    }
}

