/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.navigator;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.FolderLookup;
import org.openide.util.Lookup;

class ProviderRegistry {
    private static final String PANELS_FOLDER = "/Navigator/Panels/";
    private static final Lookup.Template NAV_PANEL_TEMPLATE = new Lookup.Template(NavigatorPanel.class);
    private static ProviderRegistry instance;
    private Map contentTypes2Providers;

    private ProviderRegistry() {
    }

    public static ProviderRegistry getInstance() {
        if (instance == null) {
            instance = new ProviderRegistry();
        }
        return instance;
    }

    public List getProviders(String contentType) {
        List result;
        if (this.contentTypes2Providers == null) {
            this.contentTypes2Providers = new HashMap(15);
        }
        if ((result = (List)this.contentTypes2Providers.get(contentType)) == null) {
            result = this.loadProviders(contentType);
            this.contentTypes2Providers.put(contentType, result);
        }
        return result;
    }

    private List loadProviders(String contentType) {
        DataObject.Container dContainer;
        FileSystem fs = Repository.getDefault().getDefaultFileSystem();
        FileObject fo = fs.findResource(PANELS_FOLDER + contentType);
        if (fo == null) {
            ErrorManager.getDefault().log(1, "No providers for content type " + contentType);
            return Collections.EMPTY_LIST;
        }
        try {
            dContainer = DataFolder.findContainer((FileObject)fo);
        }
        catch (IllegalArgumentException exc) {
            ErrorManager.getDefault().annotate((Throwable)exc, "Navigator content type " + contentType + " is probably malformed, as it doesn't point to folder.");
            ErrorManager.getDefault().notify(16, (Throwable)exc);
            return Collections.EMPTY_LIST;
        }
        FolderLookup fLookup = new FolderLookup(dContainer, "");
        Lookup.Result result = fLookup.getLookup().lookup(NAV_PANEL_TEMPLATE);
        return (List)result.allInstances();
    }
}

