/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.docscan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.tasklist.client.SuggestionPriority;
import org.netbeans.modules.tasklist.core.PriorityListCellRenderer;
import org.netbeans.modules.tasklist.core.editors.PriorityTableCellRenderer;
import org.netbeans.modules.tasklist.docscan.TaskTag;
import org.netbeans.modules.tasklist.docscan.TaskTags;
import org.netbeans.modules.tasklist.docscan.Util;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.NbBundle;

public final class TaskTagsPanel
extends JPanel
implements EnhancedCustomPropertyEditor,
ActionListener {
    private static final long serialVersionUID = 1L;
    private DefaultTableModel model = null;
    private TaskTags tags = null;
    private JButton addButton;
    private JButton changeButton;
    private JButton deleteButton;
    private JScrollPane jScrollPane1;
    private JTable patternsTable;
    private JLabel tagLabel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$org$netbeans$modules$tasklist$client$SuggestionPriority;

    public TaskTagsPanel(TaskTags tags) {
        this.initComponents();
        this.initA11y();
        this.setPreferredSize(new Dimension(400, 200));
        this.tags = tags;
        TaskTag[] tagy = tags.getTags();
        this.model = new DefaultTableModel(new Object[0][0], new String[]{Util.getString("pat-col"), Util.getString("pri-col")}){
            Class[] types;
            {
                this.types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TaskTagsPanel.class$("java.lang.String")) : class$java$lang$String, class$org$netbeans$modules$tasklist$client$SuggestionPriority == null ? (class$org$netbeans$modules$tasklist$client$SuggestionPriority = TaskTagsPanel.class$("org.netbeans.modules.tasklist.client.SuggestionPriority")) : class$org$netbeans$modules$tasklist$client$SuggestionPriority};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 1;
            }
        };
        for (int i = 0; i < tagy.length; ++i) {
            this.model.addRow(new Object[]{tagy[i].getToken(), tagy[i].getPriority()});
        }
        this.patternsTable.setModel(this.model);
        this.patternsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TaskTagsPanel.this.updateSensitivity();
            }
        });
        TableColumn sportColumn = this.patternsTable.getColumnModel().getColumn(1);
        JComboBox<SuggestionPriority> combo = new JComboBox<SuggestionPriority>();
        combo.addItem(SuggestionPriority.HIGH);
        combo.addItem(SuggestionPriority.MEDIUM_HIGH);
        combo.addItem(SuggestionPriority.MEDIUM);
        combo.addItem(SuggestionPriority.MEDIUM_LOW);
        combo.addItem(SuggestionPriority.LOW);
        combo.setRenderer((ListCellRenderer<SuggestionPriority>)new PriorityListCellRenderer());
        sportColumn.setCellEditor(new DefaultCellEditor(combo));
        sportColumn.setCellRenderer((TableCellRenderer)new PriorityTableCellRenderer());
        this.addButton.addActionListener(this);
        this.changeButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
    }

    private void initComponents() {
        this.tagLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.patternsTable = new JTable();
        this.addButton = new JButton();
        this.changeButton = new JButton();
        this.deleteButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(new EmptyBorder(new Insets(12, 12, 11, 11)));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.tagLabel, gridBagConstraints);
        this.jScrollPane1.setViewportView(this.patternsTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.addButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.changeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.deleteButton, gridBagConstraints);
    }

    private void initA11y() {
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"AddTag"));
        this.addButton.setToolTipText(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"HINT_AddTag"));
        Mnemonics.setLocalizedText((AbstractButton)this.changeButton, (String)NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"ChangeTag"));
        this.changeButton.setToolTipText(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"HINT_ChangeTag"));
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"DeleteTag"));
        this.deleteButton.setToolTipText(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"HINT_DeleteTag"));
        Mnemonics.setLocalizedText((JLabel)this.tagLabel, (String)NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"TagList"));
        this.tagLabel.setToolTipText(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"HINT_TagList"));
        this.tagLabel.setLabelFor(this.patternsTable);
        this.patternsTable.setToolTipText(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"HINT_TagList"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"ACSD_Tags"));
        this.patternsTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage((Class)TaskTagsPanel.class, (String)"ACSD_List"));
    }

    public Object getPropertyValue() throws IllegalStateException {
        return this.getEditedTags();
    }

    private TaskTags getEditedTags() {
        TaskTag[] ts = new TaskTag[this.model.getRowCount()];
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            TaskTag tag;
            String token = (String)this.model.getValueAt(i, 0);
            SuggestionPriority prio = (SuggestionPriority)this.model.getValueAt(i, 1);
            ts[i] = tag = new TaskTag(token, prio);
        }
        this.tags = new TaskTags();
        this.tags.setTags(ts);
        return this.tags;
    }

    private void updateSensitivity() {
        int[] selected = this.patternsTable.getSelectedRows();
        int count = selected != null ? selected.length : 0;
        this.deleteButton.setEnabled(count == 1);
        this.changeButton.setEnabled(count == 1);
        this.addButton.setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object source = actionEvent.getSource();
        if (source == this.addButton) {
            String text;
            NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(Util.getString("pat-col"), Util.getString("new-pat"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            if (d.getValue() == NotifyDescriptor.OK_OPTION && (text = d.getInputText()).length() > 0) {
                this.model.addRow(new Object[]{text, SuggestionPriority.MEDIUM});
            }
        } else if (source == this.changeButton) {
            String text;
            int row = this.patternsTable.getSelectedRow();
            if (row == -1) {
                if (this.patternsTable.getRowCount() > 0) {
                    this.patternsTable.getSelectionModel().setSelectionInterval(0, 0);
                    row = this.patternsTable.getSelectedRow();
                } else {
                    this.updateSensitivity();
                    return;
                }
            }
            String pattern = (String)this.model.getValueAt(row, 0);
            NotifyDescriptor.InputLine d = new NotifyDescriptor.InputLine(Util.getString("pat-col"), Util.getString("edit-pat"));
            d.setInputText(pattern);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            if (d.getValue() == NotifyDescriptor.OK_OPTION && (text = d.getInputText()).length() > 0) {
                this.model.setValueAt(text, row, 0);
            }
        } else if (source == this.deleteButton) {
            int row = this.patternsTable.getSelectedRow();
            if (row == -1) {
                this.updateSensitivity();
            } else {
                this.model.removeRow(row);
            }
        }
        this.updateSensitivity();
    }
}

