/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.DatabaseConnectionAccessor;
import org.netbeans.modules.db.explorer.DbDriverManager;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.OpenConnection;
import org.netbeans.modules.db.explorer.OpenConnectionInterface;
import org.netbeans.modules.db.explorer.actions.ConnectAction;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.netbeans.modules.db.runtime.DatabaseRuntimeManager;
import org.netbeans.spi.db.explorer.DatabaseRuntime;
import org.openide.ErrorManager;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.nodes.NodeNotFoundException;
import org.openide.nodes.NodeOp;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.windows.TopComponent;

public class DatabaseConnection
implements DBConnection {
    private static final ErrorManager LOGGER;
    private static final boolean LOG;
    static final long serialVersionUID = 4554639187416958735L;
    private Set exceptionListeners = Collections.synchronizedSet(new HashSet());
    private Connection con;
    private String drv;
    private String drvname;
    private String db;
    private String usr;
    private String schema;
    private String pwd = "";
    private Boolean rpwd = Boolean.FALSE;
    private PropertyChangeSupport propertySupport;
    private String name;
    private transient org.netbeans.api.db.explorer.DatabaseConnection dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    private static final String SUPPORT = "_schema_support";
    public static final String PROP_DRIVER = "driver";
    public static final String PROP_DATABASE = "database";
    public static final String PROP_USER = "user";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_SCHEMA = "schema";
    public static final String PROP_DRIVERNAME = "drivername";
    public static final String PROP_NAME = "name";
    private OpenConnectionInterface openConnection = null;
    private static final Lookup.Result openConnectionLookupResult;
    private static Collection openConnectionServices;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo;

    public DatabaseConnection() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public DatabaseConnection(String driver, String database, String user, String password) {
        this();
        this.drv = driver;
        this.db = database;
        this.usr = user;
        this.pwd = password;
        this.name = null;
        this.name = this.getName();
    }

    public DatabaseConnection(String driver, String driverName, String database, String theschema, String user, String password) {
        this();
        this.drv = driver;
        this.drvname = driverName;
        this.db = database;
        this.usr = user;
        this.schema = theschema;
        this.pwd = password;
        this.name = null;
        this.name = this.getName();
    }

    public JDBCDriver findJDBCDriver() {
        JDBCDriver[] drvs = JDBCDriverManager.getDefault().getDrivers(this.drv);
        if (drvs.length <= 0) {
            return null;
        }
        JDBCDriver useDriver = drvs[0];
        for (int i = 0; i < drvs.length; ++i) {
            if (!drvs[i].getName().equals(this.getDriverName())) continue;
            useDriver = drvs[i];
            break;
        }
        return useDriver;
    }

    private Collection getOpenConnections() {
        if (openConnectionServices == null) {
            openConnectionServices = openConnectionLookupResult.allInstances();
        }
        return openConnectionServices;
    }

    private OpenConnectionInterface getOpenConnection() {
        if (this.openConnection != null) {
            return this.openConnection;
        }
        this.openConnection = new OpenConnection();
        String driver = this.getDriver();
        if (driver == null) {
            return this.openConnection;
        }
        try {
            Collection c = this.getOpenConnections();
            Iterator i = c.iterator();
            while (driver != null && i.hasNext()) {
                OpenConnectionInterface oci = (OpenConnectionInterface)i.next();
                if (!oci.isFor(driver)) continue;
                this.openConnection = oci;
                break;
            }
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
        return this.openConnection;
    }

    public String getDriver() {
        return this.drv;
    }

    public void setDriver(String driver) {
        if (driver == null || driver.equals(this.drv)) {
            return;
        }
        String olddrv = this.drv;
        this.drv = driver;
        this.propertySupport.firePropertyChange(PROP_DRIVER, olddrv, this.drv);
        this.openConnection = null;
    }

    public String getDriverName() {
        return this.drvname;
    }

    public void setDriverName(String name) {
        if (name == null || name.equals(this.drvname)) {
            return;
        }
        String olddrv = this.drvname;
        this.drvname = name;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DRIVERNAME, olddrv, this.drvname);
        }
    }

    public String getDatabase() {
        if (this.db == null) {
            this.db = "";
        }
        return this.db;
    }

    public void setDatabase(String database) {
        if (database == null || database.equals(this.db)) {
            return;
        }
        String olddb = this.db;
        this.db = database;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_DATABASE, olddb, this.db);
        }
    }

    public String getUser() {
        if (this.usr == null) {
            this.usr = "";
        }
        return this.usr;
    }

    public void setUser(String user) {
        if (user == null || user.equals(this.usr)) {
            return;
        }
        String oldusr = this.usr;
        this.usr = user;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_USER, oldusr, this.usr);
        }
    }

    public String getName() {
        ResourceBundle bundle = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle");
        if (this.name == null) {
            this.name = this.getSchema() == null || this.getSchema().length() == 0 ? MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), bundle.getString("SchemaIsNotSet")) : MessageFormat.format(bundle.getString("ConnectionNodeUniqueName"), this.getDatabase(), this.getUser(), this.getSchema());
        }
        return this.name;
    }

    public void setName(String value) {
        if (this.name == null || this.name.equals(value)) {
            return;
        }
        String old = this.name;
        this.name = value;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_NAME, old, this.name);
        }
    }

    public String getSchema() {
        if (this.schema == null) {
            this.schema = "";
        }
        return this.schema;
    }

    public void setSchema(String schema_name) {
        if (schema_name == null || schema_name.equals(this.schema)) {
            return;
        }
        String oldschema = this.schema;
        this.schema = schema_name;
        this.name = null;
        this.name = this.getName();
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_SCHEMA, oldschema, this.schema);
        }
    }

    public boolean rememberPassword() {
        return this.rpwd.equals(Boolean.TRUE);
    }

    public void setRememberPassword(boolean flag) {
        this.rpwd = flag ? Boolean.TRUE : Boolean.FALSE;
    }

    public String getPassword() {
        return this.pwd;
    }

    public void setPassword(String password) {
        if (password == null || password.equals(this.pwd)) {
            return;
        }
        String oldpwd = this.pwd;
        this.pwd = password;
        if (this.propertySupport != null) {
            this.propertySupport.firePropertyChange(PROP_PASSWORD, oldpwd, this.pwd);
        }
    }

    public Connection createJDBCConnection() throws DDLException {
        if (LOG) {
            LOGGER.log(1, "createJDBCConnection()");
        }
        if (this.drv == null || this.db == null || this.usr == null || this.pwd == null) {
            throw new DDLException(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_InsufficientConnInfo"));
        }
        Properties dbprops = new Properties();
        if (this.usr != null && this.usr.length() > 0) {
            dbprops.put(PROP_USER, this.usr);
            dbprops.put(PROP_PASSWORD, this.pwd);
        }
        try {
            this.propertySupport.firePropertyChange("connecting", null, null);
            this.getOpenConnection().enable();
            this.startRuntimes();
            DerbyConectionEventListener.getDefault().beforeConnect(this);
            JDBCDriver useDriver = this.findJDBCDriver();
            if (useDriver == null) {
                Class.forName(this.drv);
            }
            Connection connection = DbDriverManager.getDefault().getConnection(this.db, dbprops, useDriver);
            this.setConnection(connection);
            this.propertySupport.firePropertyChange("connected", null, null);
            this.getOpenConnection().disable();
            return connection;
        }
        catch (SQLException e) {
            String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), this.db, this.drv, e.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            this.initSQLException(e);
            DDLException ddle = new DDLException(message);
            ddle.initCause(e);
            throw ddle;
        }
        catch (Exception exc) {
            String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), this.db, this.drv, exc.getMessage());
            this.propertySupport.firePropertyChange("failed", null, null);
            this.getOpenConnection().disable();
            DDLException ddle = new DDLException(message);
            ddle.initCause(exc);
            throw ddle;
        }
    }

    public void connect() {
        if (LOG) {
            LOGGER.log(1, "connect()");
        }
        this.createConnectTask();
    }

    public Task createConnectTask() {
        return RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                if (DatabaseConnection.this.drv == null || DatabaseConnection.this.db == null || DatabaseConnection.this.usr == null || DatabaseConnection.this.pwd == null) {
                    DatabaseConnection.this.sendException(new DDLException(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_InsufficientConnInfo")));
                }
                Properties dbprops = new Properties();
                if (DatabaseConnection.this.usr != null && DatabaseConnection.this.usr.length() > 0) {
                    dbprops.put(DatabaseConnection.PROP_USER, DatabaseConnection.this.usr);
                    dbprops.put(DatabaseConnection.PROP_PASSWORD, DatabaseConnection.this.pwd);
                }
                try {
                    DatabaseConnection.this.propertySupport.firePropertyChange("connecting", null, null);
                    DatabaseConnection.this.getOpenConnection().enable();
                    DatabaseConnection.this.getOpenConnection().enable();
                    DatabaseConnection.this.startRuntimes();
                    DerbyConectionEventListener.getDefault().beforeConnect(DatabaseConnection.this);
                    JDBCDriver useDriver = DatabaseConnection.this.findJDBCDriver();
                    if (useDriver == null) {
                        Class.forName(DatabaseConnection.this.drv);
                    }
                    DatabaseConnection.this.setConnection(DbDriverManager.getDefault().getConnection(DatabaseConnection.this.db, dbprops, useDriver));
                    DatabaseConnection.this.propertySupport.firePropertyChange("connected", null, null);
                    DatabaseConnection.this.getOpenConnection().disable();
                }
                catch (SQLException e) {
                    String message = MessageFormat.format(NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("EXC_CannotEstablishConnection"), DatabaseConnection.this.db, DatabaseConnection.this.drv, e.getMessage());
                    DatabaseConnection.this.propertySupport.firePropertyChange("failed", null, null);
                    DatabaseConnection.this.getOpenConnection().disable();
                    DatabaseConnection.this.initSQLException(e);
                    DDLException ddle = new DDLException(message);
                    ddle.initCause(e);
                    DatabaseConnection.this.sendException(ddle);
                }
                catch (Exception exc) {
                    DatabaseConnection.this.propertySupport.firePropertyChange("failed", null, null);
                    DatabaseConnection.this.getOpenConnection().disable();
                    DatabaseConnection.this.sendException(exc);
                }
            }
        }, 0);
    }

    private void initSQLException(SQLException e) {
        SQLException next = e.getNextException();
        while (next != null) {
            try {
                e.initCause(next);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            e = next;
            next = e.getNextException();
        }
    }

    private void startRuntimes() {
        DatabaseRuntime[] runtimes = DatabaseRuntimeManager.getDefault().getRuntimes(this.drv);
        for (int i = 0; i < runtimes.length; ++i) {
            DatabaseRuntime runtime = runtimes[i];
            if (runtime.isRunning() || !runtime.canStart() || !runtime.acceptsDatabaseURL(this.db)) continue;
            runtime.start();
        }
    }

    public void addExceptionListener(ExceptionListener l) {
        if (l != null) {
            this.exceptionListeners.add(l);
        }
    }

    public void removeExceptionListener(ExceptionListener l) {
        this.exceptionListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendException(Exception exc) {
        Set set = this.exceptionListeners;
        synchronized (set) {
            Iterator it = this.exceptionListeners.iterator();
            while (it.hasNext()) {
                ExceptionListener l = (ExceptionListener)it.next();
                l.exceptionOccurred(exc);
            }
        }
    }

    public void setConnection(Connection c) {
        this.con = c;
    }

    public Connection getConnection() {
        return this.con;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertySupport.removePropertyChangeListener(l);
    }

    public int hashCode() {
        return this.drv.hashCode() + this.db.hashCode() + this.usr.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DBConnection) {
            DBConnection con = (DBConnection)obj;
            return this.toString().equals(con.toString());
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.drv = (String)in.readObject();
        this.db = (String)in.readObject();
        this.usr = (String)in.readObject();
        this.schema = (String)in.readObject();
        this.rpwd = Boolean.FALSE;
        this.name = (String)in.readObject();
        try {
            this.drvname = (String)in.readObject();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.name == null || !this.name.equals(SUPPORT)) {
            this.schema = null;
        }
        this.name = null;
        this.name = this.getName();
        this.dbconn = DatabaseConnectionAccessor.DEFAULT.createDatabaseConnection(this);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.drv);
        out.writeObject(this.db);
        out.writeObject(this.usr);
        out.writeObject(this.schema);
        out.writeObject(SUPPORT);
        out.writeObject(this.drvname);
    }

    public String toString() {
        return "Driver:" + this.getDriver() + "Database:" + this.getDatabase().toLowerCase() + "User:" + this.getUser().toLowerCase() + "Schema:" + this.getSchema().toLowerCase();
    }

    public org.netbeans.api.db.explorer.DatabaseConnection getDatabaseConnection() {
        return this.dbconn;
    }

    public void selectInExplorer() {
        String nodeName = null;
        try {
            nodeName = this.findConnectionNodeInfo(this.getName()).getNode().getName();
        }
        catch (DatabaseException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        TopComponent runtimePanel = null;
        ExplorerManager runtimeExplorer = null;
        Node runtimeNode = null;
        Iterator i = TopComponent.getRegistry().getOpened().iterator();
        while (i.hasNext()) {
            ExplorerManager explorer;
            TopComponent component = (TopComponent)i.next();
            Component[] children = component.getComponents();
            if (children.length <= 0 || !"Runtime".equals((explorer = ExplorerManager.find((Component)children[0])).getRootContext().getName())) continue;
            runtimePanel = component;
            runtimeExplorer = explorer;
            runtimeNode = explorer.getRootContext();
        }
        if (runtimePanel == null) {
            return;
        }
        Node node = null;
        try {
            node = NodeOp.findPath(runtimeNode, (String[])new String[]{"Databases", nodeName});
        }
        catch (NodeNotFoundException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        try {
            runtimeExplorer.setSelectedNodes(new Node[]{node});
        }
        catch (PropertyVetoException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return;
        }
        runtimePanel.requestActive();
    }

    public void showConnectionDialog() {
        try {
            final ConnectionNodeInfo cni = this.findConnectionNodeInfo(this.getName());
            if (cni != null && cni.getConnection() == null) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        new ConnectAction.ConnectionDialogDisplayer().showDialog(cni, true);
                    }
                });
            }
        }
        catch (DatabaseException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
    }

    public Connection getJDBCConnection() {
        try {
            ConnectionNodeInfo cni = this.findConnectionNodeInfo(this.getName());
            if (cni != null && cni.getConnection() != null) {
                return cni.getConnection();
            }
        }
        catch (DatabaseException e) {
            ErrorManager.getDefault().notify((Throwable)e);
        }
        return null;
    }

    public void disconnect() throws DatabaseException {
        ConnectionNodeInfo cni = this.findConnectionNodeInfo(this.getName());
        if (cni != null && cni.getConnection() != null) {
            cni.disconnect();
        }
    }

    private ConnectionNodeInfo findConnectionNodeInfo(String connection) throws DatabaseException {
        Node[] nodes;
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        String waitNode = NbBundle.getBundle((String)"org.netbeans.modules.db.resources.Bundle").getString("WaitNode");
        while ((nodes = RootNode.getInstance().getChildren().getNodes()).length == 1 && waitNode.equals(nodes[0].getName())) {
            try {
                Thread.sleep(60L);
            }
            catch (InterruptedException e) {}
        }
        for (int i = 0; i < nodes.length; ++i) {
            ConnectionNodeInfo nfo;
            DatabaseNodeInfo info = (DatabaseNodeInfo)nodes[i].getCookie(class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo == null ? DatabaseConnection.class$("org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo") : class$org$netbeans$modules$db$explorer$infos$DatabaseNodeInfo);
            if (info == null || (nfo = (ConnectionNodeInfo)info.getParent("connection")) == null || !connection.equals(nfo.getDatabaseConnection().getName())) continue;
            return nfo;
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.propertySupport == null) {
            this.propertySupport = new PropertyChangeSupport(this);
        }
        return this;
    }

    static {
        $assertionsDisabled = !DatabaseConnection.class.desiredAssertionStatus();
        LOGGER = ErrorManager.getDefault().getInstance(DatabaseConnection.class.getName());
        LOG = LOGGER.isLoggable(1);
        openConnectionServices = null;
        openConnectionLookupResult = Lookup.getDefault().lookup(new Lookup.Template(OpenConnectionInterface.class));
        openConnectionLookupResult.addLookupListener(new LookupListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void resultChanged(LookupEvent ev) {
                Class clazz = class$org$netbeans$modules$db$explorer$DatabaseConnection == null ? (class$org$netbeans$modules$db$explorer$DatabaseConnection = DatabaseConnection.class$("org.netbeans.modules.db.explorer.DatabaseConnection")) : class$org$netbeans$modules$db$explorer$DatabaseConnection;
                synchronized (clazz) {
                    openConnectionServices = null;
                }
            }
        });
    }
}

