/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.outline;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreePath;
import org.netbeans.swing.outline.DefaultOutlineCellRenderer;
import org.netbeans.swing.outline.OutlineModel;
import org.netbeans.swing.outline.RenderDataProvider;
import org.netbeans.swing.outline.TreePathSupport;

public final class Outline
extends JTable {
    private boolean initialized = false;
    private Boolean cachedRootVisible = null;
    private RenderDataProvider renderDataProvider = null;
    private ComponentListener componentListener = null;
    private boolean needCalcRowHeight = true;

    public Outline() {
        this.init();
    }

    public Outline(OutlineModel mdl) {
        super(mdl);
        this.init();
    }

    private void init() {
        this.initialized = true;
        this.setDefaultRenderer(Object.class, new DefaultOutlineCellRenderer());
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer result = column == 0 ? this.getDefaultRenderer(Object.class) : super.getCellRenderer(row, column);
        return result;
    }

    public RenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public void setRenderDataProvider(RenderDataProvider provider) {
        if (provider != this.renderDataProvider) {
            RenderDataProvider old = this.renderDataProvider;
            this.renderDataProvider = provider;
            this.firePropertyChange("renderDataProvider", old, provider);
        }
    }

    TreePathSupport getTreePathSupport() {
        OutlineModel mdl = this.getOutlineModel();
        if (mdl != null) {
            return mdl.getTreePathSupport();
        }
        return null;
    }

    AbstractLayoutCache getLayoutCache() {
        OutlineModel mdl = this.getOutlineModel();
        if (mdl != null) {
            return mdl.getLayout();
        }
        return null;
    }

    boolean isTreeColumnIndex(int column) {
        return column == 0;
    }

    public boolean isVisible(TreePath path) {
        if (this.getTreePathSupport() != null) {
            return this.getTreePathSupport().isVisible(path);
        }
        return false;
    }

    public void setRowHeight(int val) {
        super.setRowHeight(val);
        if (this.getLayoutCache() != null) {
            this.getLayoutCache().setRowHeight(val);
        }
    }

    public void setRootVisible(boolean val) {
        if (this.getOutlineModel() == null) {
            Boolean bl = this.cachedRootVisible = val ? Boolean.TRUE : Boolean.FALSE;
        }
        if (val != this.isRootVisible()) {
            this.getLayoutCache().setRootVisible(val);
            this.firePropertyChange("rootVisible", !val, val);
        }
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible != null ? this.cachedRootVisible : true;
        }
        return this.getLayoutCache().isRootVisible();
    }

    public void setModel(TableModel mdl) {
        if (this.initialized && !(mdl instanceof OutlineModel)) {
            throw new IllegalArgumentException("Table model for an Outline must be an instance of OutlineModel");
        }
        if (mdl instanceof OutlineModel) {
            AbstractLayoutCache layout = ((OutlineModel)mdl).getLayout();
            if (this.cachedRootVisible != null) {
                layout.setRootVisible(this.cachedRootVisible);
            }
            layout.setRowHeight(this.getRowHeight());
            if (((OutlineModel)mdl).isLargeModel()) {
                this.addComponentListener(this.getComponentListener());
                layout.setNodeDimensions(new ND());
            } else if (this.componentListener != null) {
                this.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        }
        super.setModel(mdl);
    }

    public OutlineModel getOutlineModel() {
        TableModel mdl = this.getModel();
        if (mdl instanceof OutlineModel) {
            return (OutlineModel)this.getModel();
        }
        return null;
    }

    public void expandPath(TreePath path) {
        this.getTreePathSupport().expandPath(path);
    }

    public void collapsePath(TreePath path) {
        this.getTreePathSupport().collapsePath(path);
    }

    public Rectangle getPathBounds(TreePath path) {
        Insets i = this.getInsets();
        Rectangle bounds = this.getLayoutCache().getBounds(path, null);
        if (bounds != null && i != null) {
            bounds.x += i.left;
            bounds.y += i.top;
        }
        return bounds;
    }

    public TreePath getClosestPathForLocation(int x, int y) {
        Insets i = this.getInsets();
        if (i != null) {
            return this.getLayoutCache().getPathClosestTo(x - i.left, y - i.top);
        }
        return this.getLayoutCache().getPathClosestTo(x, y);
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        if (this.isTreeColumnIndex(column) && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            TreePath path = this.getLayoutCache().getPathClosestTo(me.getX(), me.getY());
            if (!this.getOutlineModel().isLeaf(path.getLastPathComponent())) {
                int handleWidth = DefaultOutlineCellRenderer.getExpansionHandleWidth();
                Insets ins = this.getInsets();
                int handleStart = ins.left + (path.getPathCount() - 1) * DefaultOutlineCellRenderer.getNestingWidth();
                int handleEnd = ins.left + handleStart + handleWidth;
                if (me.getX() > ins.left && me.getX() >= handleStart && me.getX() <= handleEnd || me.getClickCount() > 1) {
                    boolean expanded = this.getLayoutCache().isExpanded(path);
                    if (!expanded) {
                        this.getTreePathSupport().expandPath(path);
                    } else {
                        this.getTreePathSupport().collapsePath(path);
                    }
                    return false;
                }
            }
        }
        return super.editCellAt(row, column, e);
    }

    private void calcRowHeight(Graphics g) {
        int rowHeight;
        Integer i = (Integer)UIManager.get("netbeans.outline.rowHeight");
        if (i != null) {
            rowHeight = i;
        } else {
            Font f = this.getFont();
            FontMetrics fm = g.getFontMetrics(f);
            rowHeight = Math.max(fm.getHeight() + 3, DefaultOutlineCellRenderer.getExpansionHandleHeight());
        }
        this.needCalcRowHeight = false;
        this.setRowHeight(rowHeight);
    }

    public void tableChanged(TableModelEvent e) {
        super.tableChanged(e);
    }

    public void paint(Graphics g) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(g);
            return;
        }
        super.paint(g);
    }

    private ComponentListener getComponentListener() {
        if (this.componentListener == null) {
            this.componentListener = new SizeManager();
        }
        return this.componentListener;
    }

    private JScrollPane getScrollPane() {
        JScrollPane result = null;
        if (this.getParent() instanceof JViewport && ((JViewport)this.getParent()).getParent() instanceof JScrollPane) {
            result = (JScrollPane)((JViewport)this.getParent()).getParent();
        }
        return result;
    }

    private void change() {
        this.revalidate();
        this.repaint();
    }

    private class SizeManager
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer = null;
        protected JScrollBar scrollBar = null;

        private SizeManager() {
        }

        public void componentMoved(ComponentEvent e) {
            if (this.timer == null) {
                JScrollPane scrollPane = Outline.this.getScrollPane();
                if (scrollPane == null) {
                    Outline.this.change();
                } else {
                    this.scrollBar = scrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = scrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            Outline.this.change();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }

        public void actionPerformed(ActionEvent ae) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                Outline.this.change();
                this.timer = null;
                this.scrollBar = null;
            }
        }

        public void componentHidden(ComponentEvent e) {
        }

        public void componentResized(ComponentEvent e) {
        }

        public void componentShown(ComponentEvent e) {
        }
    }

    private class ND
    extends AbstractLayoutCache.NodeDimensions {
        private ND() {
        }

        public Rectangle getNodeDimensions(Object value, int row, int depth, boolean expanded, Rectangle bounds) {
            int wid = Outline.this.getColumnModel().getColumn(0).getPreferredWidth();
            bounds.setBounds(0, row * Outline.this.getRowHeight(), wid, Outline.this.getRowHeight());
            return bounds;
        }
    }
}

