/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

public class JarUtil {
    JarFile jar;
    File jarFile;

    public JarUtil(File file) {
        this.jarFile = file;
    }

    public void extract(File toDir) {
        try {
            this.jar = new JarFile(this.jarFile);
            Enumeration<JarEntry> extractEntries = this.jar.entries();
            while (extractEntries.hasMoreElements()) {
                JarEntry element = extractEntries.nextElement();
                String name = ((Object)element).toString();
                JarEntry current = this.jar.getJarEntry(name);
                if (name.endsWith("/")) {
                    File dir = new File(toDir, name);
                    dir.mkdirs();
                    continue;
                }
                InputStream in = this.jar.getInputStream(current);
                FileOutputStream fout = new FileOutputStream(toDir.getPath() + "/" + name);
                int read = in.read();
                while (read != -1) {
                    fout.write(read);
                    read = in.read();
                }
                in.close();
                fout.close();
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public void extract(String name, File toFile) {
        try {
            this.jar = new JarFile(this.jarFile);
            File parentFile = toFile.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                return;
            }
            JarEntry current = this.jar.getJarEntry(name);
            if (null == current) {
                return;
            }
            InputStream in = this.jar.getInputStream(current);
            FileOutputStream fout = new FileOutputStream(toFile.getPath());
            int read = in.read();
            while (read != -1) {
                fout.write(read);
                read = in.read();
            }
            in.close();
            fout.close();
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
    }

    public BufferedReader openFile(String name) {
        try {
            this.jar = new JarFile(this.jarFile);
            JarEntry current = this.jar.getJarEntry(name);
            if (null == current) {
                return null;
            }
            InputStream in = this.jar.getInputStream(current);
            BufferedReader buffReader = new BufferedReader(new InputStreamReader(in));
            return buffReader;
        }
        catch (IOException exc) {
            exc.printStackTrace();
            return null;
        }
    }

    public void addDirectory(File fromDir) {
        try {
            if (!this.jarFile.exists() && this.jarFile.getParentFile() != null) {
                this.jarFile.getParentFile().mkdirs();
            }
            JarOutputStream jarout = new JarOutputStream(new FileOutputStream(this.jarFile));
            File[] files = fromDir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    String name = files[i].getName() + "/";
                    JarEntry directory = new JarEntry(name);
                    jarout.putNextEntry(directory);
                    this.addDirectory(files[i], files[i].getName(), jarout);
                    continue;
                }
                this.addFile(files[i], files[i].getName(), jarout);
            }
            jarout.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addDirectory(File dir, String parentIn, JarOutputStream jarout) {
        String parent = parentIn;
        try {
            File[] files = dir.listFiles();
            for (int i = 0; i < files.length; ++i) {
                String name;
                String parentName;
                if (files[i].isDirectory()) {
                    parentName = parent;
                    if (!parentName.equals("")) {
                        name = parentName + "/" + files[i].getName() + "/";
                        parentName = parentName + "/" + files[i].getName();
                    } else {
                        name = files[i].getName() + "/";
                        parentName = files[i].getName();
                    }
                    JarEntry directory = new JarEntry(name);
                    jarout.putNextEntry(directory);
                    this.addDirectory(files[i], parentName, jarout);
                    continue;
                }
                parentName = parent;
                name = !parentName.equals("") ? parentName + "/" + files[i].getName() : files[i].getName();
                this.addFile(files[i], name, jarout);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void addFile(File file, String name, JarOutputStream jarout) {
        try {
            JarEntry entry = new JarEntry(name);
            jarout.putNextEntry(entry);
            FileInputStream fin = new FileInputStream(file);
            int read = fin.read();
            while (read != -1) {
                jarout.write(read);
                read = fin.read();
            }
            fin.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        File jarFile = new File("D:\\wsdl2java\\webservice.jar");
        if (jarFile.exists()) {
            jarFile.delete();
        }
        JarUtil jarUtil = new JarUtil(jarFile);
        jarUtil.addDirectory(new File("D:\\wsdl2java\\classes"));
        jarUtil.extract("www/xmethods/net/TemperaturePortTypeClient.java", new File("D:\\wsdl2java\\TemperaturePortTypeClient.java"));
        jarUtil.extract("www/xmethods/net/TemperaturePortType.class", new File("D:\\wsdl2java\\TemperaturePortType.class"));
        jarUtil.extract(new File("D:\\wsdl2java\\tmp"));
    }
}

