/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.model;

import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Port;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;

public class WebServiceData {
    private String websvcId;
    private String name;
    private int webServicePort;
    private String wsdlUrl;
    private String proxy;
    private String groupId;
    private String displayName;
    private String proxyJarFileName;
    private String packageName;
    private String webServiceAddress;
    private ArrayList ports = new ArrayList();
    public static final String PORT_PROPERTY_NAME = "WSPORTNAME";

    public WebServiceData() {
        this(WebServiceListModel.getInstance().getUniqueWebServiceId());
    }

    public WebServiceData(String id) {
        this.setId(id);
    }

    public void setId(String id) {
        this.websvcId = id;
    }

    public String getId() {
        return this.websvcId;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = this.name;
        }
        return this.displayName;
    }

    public void setDisplayName(String dispName) {
        this.displayName = dispName;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String id) {
        this.groupId = id;
    }

    public void setPackageName(String inPackageName) {
        this.packageName = inPackageName;
    }

    public void setWebServiceAddress(String inAddress) {
        this.webServiceAddress = inAddress;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ArrayList getMethods() {
        ArrayList<Operation> returnMethods = new ArrayList<Operation>();
        Iterator portIterator = this.ports.iterator();
        Port currentPort = null;
        while (portIterator.hasNext()) {
            currentPort = (Port)portIterator.next();
            if (null == currentPort || null == currentPort.getOperations()) continue;
            Iterator operationIterator = currentPort.getOperations();
            Operation currentOperation = null;
            while (operationIterator.hasNext()) {
                currentOperation = (Operation)operationIterator.next();
                if (null == currentOperation) continue;
                returnMethods.add(currentOperation);
            }
        }
        return returnMethods;
    }

    public int getWebServicePort() {
        return this.webServicePort;
    }

    public void setWebServicePort(int portNumber) {
        this.webServicePort = portNumber;
    }

    public String getURL() {
        return this.wsdlUrl;
    }

    public void setURL(String url) {
        this.wsdlUrl = url;
    }

    public String getProxy() {
        return this.proxy;
    }

    public void setProxy(String proxy) {
        this.proxy = proxy;
    }

    public void setProxyJarFileName(String jarName) {
        this.proxyJarFileName = jarName;
    }

    public String getProxyJarFileName() {
        if (null == this.proxyJarFileName) {
            return null;
        }
        File proxyFile = new File(this.proxyJarFileName);
        if (!proxyFile.exists()) {
            String newName;
            String fileOnlyName = this.proxyJarFileName;
            if (this.proxyJarFileName.indexOf("/") != -1) {
                fileOnlyName = this.proxyJarFileName.substring(this.proxyJarFileName.lastIndexOf("/") + 1);
            }
            if (this.proxyJarFileName.indexOf("\\") != -1) {
                fileOnlyName = this.proxyJarFileName.substring(this.proxyJarFileName.lastIndexOf("\\") + 1);
            }
            if (!(proxyFile = new File(newName = System.getProperty("netbeans.user") + File.separator + "websvc" + File.separator + fileOnlyName)).exists()) {
                return null;
            }
            this.proxyJarFileName = newName;
            this.setProxyJarFileName(this.proxyJarFileName);
        }
        return this.proxyJarFileName;
    }

    public String getWSDescription() {
        return "Web Service Information-\nName: " + this.name + "\n" + "Port number: " + this.webServicePort + "\n" + "URL: " + this.wsdlUrl + "\n" + "Address: " + this.webServiceAddress + "\n";
    }

    public String getPackageName() {
        if (null == this.packageName) {
            this.packageName = "webservice";
        }
        return this.packageName;
    }

    public String getWebServiceAddress() {
        return this.webServiceAddress;
    }

    public Port[] getPorts() {
        return this.ports.toArray(new Port[0]);
    }

    public void addPort(Port inPort) {
        this.ports.add(inPort);
    }

    public void setPorts(Port[] inPorts) {
        this.ports = new ArrayList<Port>(Arrays.asList(inPorts));
    }

    public boolean equals(Object inWSData) {
        if (!(inWSData instanceof WebServiceData)) {
            return false;
        }
        WebServiceData comparingWSdata = (WebServiceData)inWSData;
        String thisDisplayName = this.getDisplayName();
        String comparingDisplayName = comparingWSdata.getDisplayName();
        if (null == comparingDisplayName && null != thisDisplayName) {
            return false;
        }
        if (null == thisDisplayName && null != comparingDisplayName) {
            return false;
        }
        if (null == thisDisplayName && null == comparingDisplayName) {
            return true;
        }
        return thisDisplayName.equalsIgnoreCase(comparingDisplayName);
    }

    public String toString() {
        return "<html><b>Web Service Information</b><br><b>Name:</b> " + this.name + "<br><b>Port number:</b> " + this.webServicePort + "<br><b>URL:</b> " + this.wsdlUrl + "<br><b>Address:</b> " + this.webServiceAddress + "</html>";
    }
}

