/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.registry.actions;

import java.awt.Dialog;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.modules.websvc.registry.actions.AddWSGroupPanel;
import org.netbeans.modules.websvc.registry.model.WebServiceGroup;
import org.netbeans.modules.websvc.registry.model.WebServiceListModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class AddWebServiceGroupAction
extends NodeAction {
    protected boolean enable(Node[] node) {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String getName() {
        return NbBundle.getMessage(AddWebServiceGroupAction.class, (String)"ADD_GROUP");
    }

    protected void performAction(Node[] nodes) {
        WebServiceListModel wsNodeModel = WebServiceListModel.getInstance();
        AddWSGroupPanel innerPanel = new AddWSGroupPanel();
        DialogDescriptor dialogDesc = new DialogDescriptor((Object)innerPanel, NbBundle.getMessage(AddWebServiceGroupAction.class, (String)"TTL_AddWSGroup"));
        MyDocListener dl = new MyDocListener(dialogDesc, wsNodeModel);
        innerPanel.getTFDocument().addDocumentListener(dl);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDesc);
        dialogDesc.setValid(false);
        dialog.setVisible(true);
        if (NotifyDescriptor.OK_OPTION.equals(dialogDesc.getValue())) {
            WebServiceGroup wsGroup = new WebServiceGroup();
            String groupName = innerPanel.getGroupName();
            wsGroup.setName(groupName);
            wsNodeModel.addWebServiceGroup(wsGroup);
        }
        innerPanel.getTFDocument().removeDocumentListener(dl);
        dialog.dispose();
    }

    protected boolean asynchronous() {
        return false;
    }

    private class MyDocListener
    implements DocumentListener {
        private DialogDescriptor dd;
        private WebServiceListModel wsNodeModel;

        MyDocListener(DialogDescriptor dd, WebServiceListModel wsNodeModel) {
            this.dd = dd;
            this.wsNodeModel = wsNodeModel;
        }

        public void removeUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void insertUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void changedUpdate(DocumentEvent e) {
            this.update(e);
        }

        public void update(DocumentEvent e) {
            Document doc = e.getDocument();
            try {
                String text = doc.getText(0, doc.getLength()).trim();
                if (text.length() == 0 || this.wsNodeModel.findWebServiceGroup(text) != null) {
                    this.dd.setValid(false);
                    return;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            this.dd.setValid(true);
        }
    }
}

