/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.refactoring;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.jmi.javamodel.AnnotableElement;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AnnotationType;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.j2ee.common.JMIUtils;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.javacore.api.JavaModel;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceRefactoringUtil {
    private PersistenceRefactoringUtil() {
    }

    public static List<FileObject> getPersistence(JavaClass javaClass) {
        ArrayList<FileObject> result = new ArrayList<FileObject>();
        Project project = PersistenceRefactoringUtil.getProject(javaClass);
        if (project != null) {
            PersistenceScope[] persistenceScopes = PersistenceUtils.getPersistenceScopes((Project)project);
            for (int i = 0; i < persistenceScopes.length; ++i) {
                result.add(persistenceScopes[i].getPersistenceXml());
            }
        }
        return result;
    }

    public static Project getProject(JavaClass javaClass) {
        Resource res = javaClass.getResource();
        FileObject fo = JavaModel.getFileObject((Resource)res);
        return FileOwnerQuery.getOwner((FileObject)fo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<JavaClass> getEntitiesInProject(JavaClass javaClass) {
        ArrayList<JavaClass> result = new ArrayList<JavaClass>();
        Project project = PersistenceRefactoringUtil.getProject(javaClass);
        Set entities = null;
        try {
            entities = PersistenceUtils.getEntityClasses((Project)project);
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return Collections.emptyList();
        }
        JMIUtils.beginJmiTransaction();
        boolean rollback = true;
        try {
            for (Entity entity : entities) {
                JavaClass jc = (JavaClass)JavaModel.getDefaultExtent().getType().resolve(entity.getClass2());
                result.add(jc);
            }
            rollback = false;
        }
        finally {
            JMIUtils.endJmiTransaction((boolean)rollback);
        }
        return result;
    }

    public static boolean isEntity(AnnotableElement element) {
        Annotation[] annots;
        if (element == null || element.getAnnotations() == null) {
            return false;
        }
        String entityAnnotation = "javax.persistence.Entity";
        for (Annotation ann : annots = element.getAnnotations().toArray(new Annotation[0])) {
            AnnotationType atype = ann.getType();
            if (atype == null || !entityAnnotation.equals(atype.getName())) continue;
            return true;
        }
        return false;
    }
}

