/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification.persistence.rules.annotation;

import javax.jmi.reflect.RefFeatured;
import org.netbeans.jmi.javamodel.Annotation;
import org.netbeans.jmi.javamodel.AttributeValue;
import org.netbeans.jmi.javamodel.Element;
import org.netbeans.jmi.javamodel.InitialValue;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.StringLiteral;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.Entity;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.verification.AbstractRule;
import org.netbeans.modules.j2ee.verification.Problem;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;

public class EntityNameUnique
extends AbstractRule {
    String entityClassName;

    protected String getMessageKey() {
        return "MSG_EntityNameUnique";
    }

    protected Object[] getMessageParameters() {
        return new Object[]{this.entityClassName};
    }

    public void reset() {
        this.entityClassName = null;
    }

    public String getId() {
        return "EntityNameUnique";
    }

    protected boolean isApplicable(Element subject, ProblemFinderContext ctx) {
        return ctx.isIsEntityClass() && super.isApplicable(subject, ctx);
    }

    public Problem apply(Element subject, ProblemFinderContext ctx) {
        if (this.isApplicable(subject, ctx)) {
            Annotation annotation = (Annotation)Annotation.class.cast(subject);
            String entityName = EntityNameUnique.getNameOfEntity(annotation);
            int count = 0;
            EntityMappings mapping = ctx.getEntityMapping();
            if (entityName != null && mapping != null) {
                for (Entity e : mapping.getEntity()) {
                    if (entityName.equals(e.getName())) {
                        ++count;
                    }
                    if (count <= 1) continue;
                    this.entityClassName = e.getClass2();
                    return this.createProblem(ctx, subject);
                }
            }
        }
        return null;
    }

    private static String getNameOfEntity(Annotation entity) {
        RefFeatured obj = entity.refImmediateComposite();
        if (obj instanceof JavaClass) {
            for (AttributeValue attrValue : entity.getAttributeValues()) {
                InitialValue value;
                if (!"name".equals(attrValue.getName()) || !((value = attrValue.getValue()) instanceof StringLiteral)) continue;
                return ((StringLiteral)StringLiteral.class.cast(value)).getValue();
            }
            return ((JavaClass)JavaClass.class.cast(obj)).getSimpleName();
        }
        return null;
    }
}

