/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.editor.hints.spi.HintsProvider;
import org.netbeans.modules.j2ee.verification.HintsManager;
import org.netbeans.modules.j2ee.verification.JEEVerificationHint;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.openide.ErrorManager;
import org.openide.text.Line;

public class JEEVerificationHintsProvider
extends HintsProvider {
    private static JEEVerificationHintsProvider INSTANCE;

    static synchronized JEEVerificationHintsProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new JEEVerificationHintsProvider();
        }
        return INSTANCE;
    }

    private JEEVerificationHintsProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getHints(Document doc, int offset) {
        if (!(doc instanceof BaseDocument)) {
            return Collections.EMPTY_LIST;
        }
        BaseDocument baseDoc = (BaseDocument)doc;
        Collection jeeProblems = (Collection)baseDoc.getProperty((Object)"jee.problem_scaning.result");
        Line.Set origLineSet = (Line.Set)baseDoc.getProperty((Object)"jee.problem_scaning.lineset");
        if (jeeProblems == null || origLineSet == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<JEEVerificationHint> returnValue = new ArrayList<JEEVerificationHint>();
        try {
            int cursorPosLine = Utilities.getLineOffset((BaseDocument)baseDoc, (int)offset);
            Collection collection = jeeProblems;
            synchronized (collection) {
                for (JEEVerificationProblemMark error : jeeProblems) {
                    JEEVerificationHint[] problemHints;
                    int errorLineNum;
                    Line.Part linePart = (Line.Part)error.getAttachedAnnotatable();
                    int originalLineNumber = linePart.getLine().getLineNumber();
                    Line currentLine = origLineSet.getCurrent(originalLineNumber);
                    if (currentLine == null || cursorPosLine != (errorLineNum = currentLine.getLineNumber()) || (problemHints = HintsManager.getHintsForProblem(error)) == null) continue;
                    for (JEEVerificationHint hint : problemHints) {
                        if (returnValue.contains((Object)hint)) continue;
                        returnValue.add(hint);
                    }
                }
            }
        }
        catch (BadLocationException e) {
            ErrorManager.getDefault().notify(1, (Throwable)e);
        }
        return returnValue;
    }

    public void update(Document doc) {
        this.firePropertyChangeEvent("refresh", null, doc);
    }
}

