/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.verification;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.text.Document;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.mdr.events.AttributeEvent;
import org.netbeans.api.mdr.events.MDRChangeEvent;
import org.netbeans.api.mdr.events.MDRChangeListener;
import org.netbeans.api.mdr.events.MDRChangeSource;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseDocument;
import org.netbeans.jmi.javamodel.JavaClass;
import org.netbeans.jmi.javamodel.Resource;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.java.JMIUtils;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScope;
import org.netbeans.modules.j2ee.persistence.api.PersistenceScopes;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceMetadata;
import org.netbeans.modules.j2ee.persistence.dd.PersistenceUtils;
import org.netbeans.modules.j2ee.persistence.dd.orm.model_1_0.EntityMappings;
import org.netbeans.modules.j2ee.verification.JEEVerificationHintsProvider;
import org.netbeans.modules.j2ee.verification.JEEVerificationProblemMark;
import org.netbeans.modules.j2ee.verification.ProblemFinder;
import org.netbeans.modules.j2ee.verification.ProblemFinderContext;
import org.netbeans.modules.j2ee.verification.ejb.EJBApiHelper;
import org.netbeans.modules.j2ee.verification.persistence.PersistenceAPIHelper;
import org.netbeans.modules.javacore.api.JavaModel;
import org.netbeans.modules.javacore.internalapi.JavaMetamodel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.loaders.DataObject;
import org.openide.text.AnnotationProvider;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JEEVerificationAnnotationProvider
implements AnnotationProvider {
    private static Collection<ProblemFinder> problemFinders = new ArrayList<ProblemFinder>();
    static final String JEE_PROBLEM_SCANNING_RESULT = "jee.problem_scaning.result";
    static final String JEE_PROBLEM_SCANNING_LINESET = "jee.problem_scaning.lineset";

    public static void registerProblemFinderClass(String className) {
        ProblemFinder problemFinder = null;
        try {
            Class<?> classDef = Class.forName(className);
            problemFinder = (ProblemFinder)classDef.newInstance();
        }
        catch (Exception e) {
            ErrorManager.getDefault().notify(4096, (Throwable)e);
            throw new RuntimeException(e);
        }
        if (problemFinder != null) {
            problemFinders.add(problemFinder);
        }
    }

    public void annotate(Line.Set set, Lookup context) {
        final DataObject dataObj = (DataObject)context.lookup(DataObject.class);
        if (dataObj == null) {
            return;
        }
        final FileObject fileObj = dataObj.getPrimaryFile();
        final BaseDocument baseDoc = (BaseDocument)((EditorCookie)dataObj.getCookie(EditorCookie.class)).getDocument();
        if ("text/x-java".equals(fileObj.getMIMEType())) {
            Runnable firstTimeScanning = new Runnable(){

                public void run() {
                    ChangeListener changeListener = JEEVerificationAnnotationProvider.createMDRListenerOnDocument(baseDoc);
                    EntityMappings mappings = PersistenceUtils.getEntityMappings((FileObject)NbEditorUtilities.getFileObject((Document)baseDoc));
                    if (mappings != null) {
                        mappings.addPropertyChangeListener((PropertyChangeListener)changeListener);
                    }
                    EditorCookie.Observable editor = (EditorCookie.Observable)dataObj.getCookie(EditorCookie.Observable.class);
                    EditorCookieListener editorListener = new EditorCookieListener(changeListener);
                    editor.addPropertyChangeListener((PropertyChangeListener)editorListener);
                    this.setPersistenceUnitPresenceListener(fileObj, changeListener);
                }

                private void setPersistenceUnitPresenceListener(FileObject fileObj2, ChangeListener changeListener) {
                    PersistenceScopes psScopes;
                    Project project = FileOwnerQuery.getOwner((FileObject)fileObj2);
                    if (project != null && (psScopes = PersistenceScopes.getPersistenceScopes((Project)project)) != null) {
                        PersistenceScope[] scopes;
                        psScopes.addPropertyChangeListener((PropertyChangeListener)changeListener);
                        for (PersistenceScope scope : scopes = psScopes.getPersistenceScopes()) {
                            try {
                                PersistenceMetadata.getDefault().getRoot(scope.getPersistenceXml()).addPropertyChangeListener((PropertyChangeListener)changeListener);
                            }
                            catch (Exception ex) {
                                ErrorManager.getDefault().notify(1, (Throwable)ex);
                            }
                        }
                    }
                }
            };
            RequestProcessor.getDefault().post(firstTimeScanning);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection processDocument(BaseDocument baseDoc, Line.Set lineSet) {
        JEEVerificationAnnotationProvider.tmpDbg("looking for problems");
        ArrayList<JEEVerificationProblemMark> scanningResult = (ArrayList<JEEVerificationProblemMark>)baseDoc.getProperty((Object)JEE_PROBLEM_SCANNING_RESULT);
        if (scanningResult == null) {
            JEEVerificationAnnotationProvider.tmpDbg("document is being processed for the first time");
            scanningResult = new ArrayList<JEEVerificationProblemMark>();
            baseDoc.putProperty((Object)JEE_PROBLEM_SCANNING_RESULT, scanningResult);
        } else {
            JEEVerificationAnnotationProvider.tmpDbg("document is being processed subsequentially");
            ArrayList<JEEVerificationProblemMark> arrayList = scanningResult;
            synchronized (arrayList) {
                JEEVerificationAnnotationProvider.tmpDbg("removing " + scanningResult.size() + " existing problem marks");
                for (JEEVerificationProblemMark problem : scanningResult) {
                    problem.detach();
                }
                scanningResult.clear();
            }
        }
        baseDoc.putProperty((Object)JEE_PROBLEM_SCANNING_LINESET, (Object)lineSet);
        JavaMetamodel javaMdl = JavaMetamodel.getManager();
        javaMdl.waitScanFinished();
        Resource resource = null;
        JavaModel.getJavaRepository().beginTrans(false);
        try {
            JMIUtils utils = JMIUtils.get((BaseDocument)baseDoc);
            resource = utils.getResource();
            if (resource != null) {
                JavaModel.setClassPath((Resource)resource);
                for (JavaClass javaClass : JEEVerificationAnnotationProvider.getAllClassesDefinedInResource(resource)) {
                    HashSet<String> rbis;
                    HashSet<String> lbis;
                    JEEVerificationAnnotationProvider.tmpDbg("Processing class: " + javaClass.getName());
                    ProblemFinderContext ctx = new ProblemFinderContext();
                    ctx.setLineSet(lineSet);
                    ctx.setDocument(baseDoc);
                    ctx.setResource(resource);
                    ctx.setMainJavaClass(javaClass);
                    EntityMappings mappings = PersistenceUtils.getEntityMappings((FileObject)NbEditorUtilities.getFileObject((Document)baseDoc));
                    ctx.setEntityMapping(mappings);
                    if (PersistenceAPIHelper.isEmbeddable(javaClass)) {
                        ctx.setEmbeddable(true);
                    } else if (PersistenceAPIHelper.isMappedSuperclass(javaClass)) {
                        ctx.setMappedSuperclass(true);
                        ctx.setBeanAccessType(PersistenceAPIHelper.findAccessTypeOfHierarchy(javaClass));
                    } else if (PersistenceAPIHelper.isEntity(javaClass)) {
                        ctx.setIsEntityClass(true);
                        ctx.setBeanAccessType(PersistenceAPIHelper.findAccessTypeOfHierarchy(javaClass));
                    } else if (PersistenceAPIHelper.isIdClass(javaClass)) {
                        ctx.setIdClass(true);
                        ctx.setBeanAccessType(PersistenceAPIHelper.findIdClassAccessType(javaClass));
                    } else if (EJBApiHelper.isStateless(javaClass)) {
                        ctx.setSLSB(true);
                        lbis = new HashSet<String>();
                        rbis = new HashSet<String>();
                        EJBApiHelper.getBusinessInterfaces(javaClass, lbis, rbis);
                        ctx.setLBIs(lbis);
                        ctx.setRBIs(rbis);
                    } else if (EJBApiHelper.isStateful(javaClass)) {
                        ctx.setSFSB(true);
                        lbis = new HashSet();
                        rbis = new HashSet();
                        EJBApiHelper.getBusinessInterfaces(javaClass, lbis, rbis);
                        ctx.setLBIs(lbis);
                        ctx.setRBIs(rbis);
                    } else if (EJBApiHelper.isRBI(javaClass)) {
                        ctx.setRBI(true);
                    } else if (EJBApiHelper.isLBI(javaClass)) {
                        ctx.setLBI(true);
                    }
                    for (ProblemFinder problemFinder : problemFinders) {
                        problemFinder.reset();
                        problemFinder.setContext(ctx);
                        problemFinder.parseDocument();
                        ArrayList<JEEVerificationProblemMark> arrayList = scanningResult;
                        synchronized (arrayList) {
                            scanningResult.addAll(problemFinder.getProblemMarks());
                        }
                    }
                }
            } else {
                ErrorManager.getDefault().log("resource was null");
            }
        }
        catch (Exception e) {
            if (resource == null || !javaMdl.isModified(javaMdl.getFileObject(resource))) {
                throw new RuntimeException(e);
            }
        }
        finally {
            JavaModel.getJavaRepository().endTrans();
        }
        JEEVerificationAnnotationProvider.updateHintsProvider((Document)baseDoc);
        return scanningResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ChangeListener createMDRListenerOnDocument(BaseDocument baseDoc) {
        ChangeListener changeListener = new ChangeListener(baseDoc);
        JavaMetamodel javaMdl = JavaMetamodel.getManager();
        FileObject fileObj = NbEditorUtilities.getFileObject((Document)baseDoc);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObj);
        if (project != null) {
            javaMdl.waitScanFinished();
            ClassPathProvider classPathProvider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
            ClassPath classPath = classPathProvider.findClassPath(fileObj, "classpath/source");
            if (classPath != null) {
                JavaModel.getJavaRepository().beginTrans(false);
                try {
                    ArrayList<MDRChangeSource> changeSources = new ArrayList<MDRChangeSource>(1);
                    for (FileObject root : classPath.getRoots()) {
                        MDRChangeSource mdrChangeSource = (MDRChangeSource)JavaMetamodel.getManager().resolveJavaExtent(root);
                        mdrChangeSource.addListener((MDRChangeListener)changeListener);
                        changeSources.add(mdrChangeSource);
                    }
                    changeListener.setMDRChangeSources(changeSources.toArray(new MDRChangeSource[0]));
                }
                catch (Exception e) {
                    ErrorManager.getDefault().notify(4096, (Throwable)e);
                }
                finally {
                    JavaModel.getJavaRepository().endTrans(false);
                }
            }
        }
        changeListener.scheduleScanningTask();
        return changeListener;
    }

    private static List<JavaClass> getAllClassesDefinedInResource(Resource resource) {
        ArrayList<JavaClass> classes = new ArrayList<JavaClass>(resource.getClassifiers());
        for (JavaClass javaClass : resource.getClassifiers()) {
            classes.addAll(JEEVerificationAnnotationProvider.getAllSubClasses(javaClass));
        }
        return classes;
    }

    private static List<JavaClass> getAllSubClasses(JavaClass parentClass) {
        ArrayList<JavaClass> kids = new ArrayList<JavaClass>();
        for (Object o : parentClass.getFeatures()) {
            if (!(o instanceof JavaClass)) continue;
            JavaClass javaClass = (JavaClass)o;
            kids.add(javaClass);
            kids.addAll(JEEVerificationAnnotationProvider.getAllSubClasses(javaClass));
        }
        return kids;
    }

    @Deprecated
    public static void tmpDbg(String debugMsg) {
    }

    private static void updateHintsProvider(Document doc) {
        if (JEEVerificationHintsProvider.getInstance() != null) {
            JEEVerificationHintsProvider.getInstance().update(doc);
        }
    }

    private class EditorCookieListener
    implements PropertyChangeListener {
        private ChangeListener mdrListener;

        public EditorCookieListener(ChangeListener initialMDRListener) {
            this.mdrListener = initialMDRListener;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if ("document".equals(evt.getPropertyName())) {
                CloneableEditorSupport editor = (CloneableEditorSupport)evt.getSource();
                final BaseDocument baseDoc = (BaseDocument)editor.getDocument();
                if (baseDoc == null) {
                    JEEVerificationAnnotationProvider.tmpDbg("Document being closed");
                    final ChangeListener listenerCopy = this.mdrListener;
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            listenerCopy.detach();
                            if (listenerCopy.getGeneratedProblemMarks() != null) {
                                for (JEEVerificationProblemMark problem : listenerCopy.getGeneratedProblemMarks()) {
                                    problem.detach();
                                }
                            }
                        }
                    });
                    this.mdrListener = null;
                } else {
                    JEEVerificationAnnotationProvider.tmpDbg("Document being subsequentially opened");
                    RequestProcessor.getDefault().post(new Runnable(){

                        public void run() {
                            EditorCookieListener.this.mdrListener = JEEVerificationAnnotationProvider.createMDRListenerOnDocument(baseDoc);
                        }
                    });
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ChangeListener
    implements MDRChangeListener,
    PropertyChangeListener,
    FileChangeListener {
        private MDRChangeSource[] mdrChangeSources;
        private final Object mdrChangeSourcesLock = new Object();
        private Collection<JEEVerificationProblemMark> generatedProblemMarks;
        private final RequestProcessor.Task task;
        private final AtomicBoolean active = new AtomicBoolean(true);
        private static RequestProcessor requestProcessor = new RequestProcessor("Java EE Verification Request Processor", 1);

        public ChangeListener(final BaseDocument baseDoc) {
            assert (baseDoc != null);
            Runnable action = new Runnable(){

                public void run() {
                    LineCookie lcookie = (LineCookie)NbEditorUtilities.getDataObject((Document)baseDoc).getCookie(LineCookie.class);
                    Line.Set lineSet = lcookie.getLineSet();
                    ChangeListener.this.setGeneratedProblemMarks(JEEVerificationAnnotationProvider.processDocument(baseDoc, lineSet));
                }
            };
            this.task = requestProcessor.create(action, true);
        }

        public void change(MDRChangeEvent mdrEvent) {
            if (this.active.get() && ChangeListener.isMeaningfulMDREvent(mdrEvent)) {
                JEEVerificationAnnotationProvider.tmpDbg("a change in the java model detected");
                this.scheduleScanningTask();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void detach() {
            this.active.set(false);
            this.task.cancel();
            this.task.waitFinished();
            Object object = this.mdrChangeSourcesLock;
            synchronized (object) {
                if (this.mdrChangeSources != null) {
                    for (MDRChangeSource mcs : this.mdrChangeSources) {
                        mcs.removeListener((MDRChangeListener)this);
                    }
                    this.mdrChangeSources = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setMDRChangeSources(MDRChangeSource[] mdrChangeSources) {
            Object object = this.mdrChangeSourcesLock;
            synchronized (object) {
                this.mdrChangeSources = mdrChangeSources;
            }
        }

        public synchronized Collection<JEEVerificationProblemMark> getGeneratedProblemMarks() {
            return this.generatedProblemMarks;
        }

        public synchronized void setGeneratedProblemMarks(Collection generatedProblemMarks) {
            this.generatedProblemMarks = generatedProblemMarks;
        }

        private static boolean isMeaningfulMDREvent(MDRChangeEvent mdrEvent) {
            if (mdrEvent instanceof AttributeEvent) {
                AttributeEvent attrEvent = (AttributeEvent)mdrEvent;
                String attrName = attrEvent.getAttributeName();
                JEEVerificationAnnotationProvider.tmpDbg("mdr event: " + attrName);
                if (!"timestamp".equals(attrName)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JEEVerificationAnnotationProvider.tmpDbg("model update");
            this.scheduleScanningTask();
        }

        public void scheduleScanningTask() {
            this.task.schedule(500);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
        }

        public void fileDataCreated(FileEvent fileEvent) {
            if (this.isPersistentXMLFile(fileEvent.getFile())) {
                this.scheduleScanningTask();
            }
        }

        public void fileChanged(FileEvent fileEvent) {
        }

        public void fileDeleted(FileEvent fileEvent) {
            if (this.isPersistentXMLFile(fileEvent.getFile())) {
                this.scheduleScanningTask();
            }
        }

        public void fileRenamed(FileRenameEvent fileEvent) {
        }

        public void fileAttributeChanged(FileAttributeEvent fileEvent) {
        }

        private boolean isPersistentXMLFile(FileObject fileObj) {
            return fileObj.getNameExt().equals("persistence.xml");
        }
    }
}

