/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.tasklist.core.filter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.netbeans.modules.tasklist.core.filter.Filter;

public final class FilterRepository
implements List {
    public static final String PROP_FILTERS = "propFilters";
    public static final String PROP_ACTIVE_FILTER = "propActiveFilter";
    private PropertyChangeSupport pcs = null;
    private LinkedList filters = new LinkedList();
    private int active = -1;
    private PropertyChangeListener filterChangeListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent evt) {
            FilterRepository.this.fireFiltersChanged();
        }
    };

    public void assign(FilterRepository rhs) {
        if (rhs != this) {
            this.filters.clear();
            Iterator it = rhs.filters.iterator();
            while (it.hasNext()) {
                this.filters.add(((Filter)it.next()).clone());
            }
            this.active = rhs.active;
            this.fireFiltersChanged();
        }
    }

    public Object clone() {
        FilterRepository ret = new FilterRepository();
        ret.assign(this);
        return ret;
    }

    public boolean add(Object f) {
        if (this.filters.add(f)) {
            ((Filter)f).addPropertyChangeListener(this.filterChangeListener);
            this.fireFiltersChanged();
            return true;
        }
        return false;
    }

    public boolean addAll(Collection c) {
        boolean ret = this.filters.addAll(c);
        if (ret) {
            this.hookCollection(c);
            this.fireFiltersChanged();
        }
        return ret;
    }

    public void add(int param, Object obj) {
        this.filters.add(param, obj);
        ((Filter)obj).addPropertyChangeListener(this.filterChangeListener);
        this.fireFiltersChanged();
    }

    public boolean addAll(int param, Collection collection) {
        if (this.filters.addAll(param, collection)) {
            this.hookCollection(collection);
            this.fireFiltersChanged();
            return true;
        }
        return false;
    }

    public void clear() {
        if (!this.filters.isEmpty()) {
            this.setActive(null);
            this.unhookCollection(this.filters);
            this.filters.clear();
            this.fireFiltersChanged();
        }
    }

    public boolean contains(Object f) {
        return this.filters.contains(f);
    }

    public boolean remove(Object filter) {
        if (filter == this.getActive()) {
            this.setActive(null);
        }
        if (this.filters.remove(filter)) {
            ((Filter)filter).removePropertyChangeListener(this.filterChangeListener);
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.filters.isEmpty();
    }

    public Iterator iterator() {
        return this.filters.iterator();
    }

    public boolean removeAll(Collection collection) {
        if (collection.contains(this.getActive())) {
            this.setActive(null);
        }
        this.unhookCollection(collection);
        boolean ret = this.filters.removeAll(collection);
        if (ret) {
            this.fireFiltersChanged();
        }
        return ret;
    }

    public Object[] toArray() {
        return this.filters.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.filters.toArray(objectArray);
    }

    public boolean containsAll(Collection collection) {
        return this.filters.containsAll(collection);
    }

    public boolean retainAll(Collection collection) {
        if (this.getActive() != null && !collection.contains(this.getActive())) {
            this.setActive(null);
        }
        this.unhookCollection(this.filters);
        boolean ret = this.filters.retainAll(collection);
        this.hookCollection(this.filters);
        if (ret) {
            this.fireFiltersChanged();
        }
        return ret;
    }

    public int size() {
        return this.filters.size();
    }

    public boolean equals(Object o) {
        if (o instanceof FilterRepository && o != null) {
            FilterRepository fr = (FilterRepository)o;
            return this.filters.equals(fr.filters) && this.active == fr.active;
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.filters.hashCode() + (this.active == -1 ? 0 : this.getActive().hashCode());
    }

    private PropertyChangeSupport getPCS() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getPCS().addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    private final void fireActiveChanged(Filter old, Filter nnew) {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(PROP_ACTIVE_FILTER, old, nnew);
        }
    }

    private final void fireFiltersChanged() {
        if (this.pcs != null) {
            this.getPCS().firePropertyChange(PROP_FILTERS, null, null);
        }
    }

    public Filter getFilterByName(String name) {
        Iterator it = this.filters.iterator();
        while (it.hasNext()) {
            Filter f = (Filter)it.next();
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public Filter getActive() {
        return this.active == -1 ? null : (Filter)this.filters.get(this.active);
    }

    public void setActive(Filter newactive) {
        if (newactive == null) {
            if (this.active != -1) {
                Filter oldactive = this.getActive();
                this.active = -1;
                this.fireActiveChanged(oldactive, null);
            }
        } else {
            int i = this.filters.indexOf(newactive);
            if (i != -1) {
                Filter oldactive = this.getActive();
                this.active = i;
                this.fireActiveChanged(oldactive, newactive);
            } else {
                throw new IllegalArgumentException("newactive not in collection");
            }
        }
    }

    public Object get(int param) {
        return this.filters.get(param);
    }

    public int indexOf(Object obj) {
        return this.filters.indexOf(obj);
    }

    public int lastIndexOf(Object obj) {
        return this.filters.lastIndexOf(obj);
    }

    public ListIterator listIterator() {
        return this.filters.listIterator();
    }

    public ListIterator listIterator(int param) {
        return this.filters.listIterator(param);
    }

    public Object remove(int param) {
        Object o = this.filters.remove(param);
        if (o != null) {
            ((Filter)o).removePropertyChangeListener(this.filterChangeListener);
            this.fireFiltersChanged();
        }
        return o;
    }

    public Object set(int param, Object obj) {
        Object o = this.filters.set(param, obj);
        ((Filter)o).removePropertyChangeListener(this.filterChangeListener);
        ((Filter)obj).addPropertyChangeListener(this.filterChangeListener);
        this.fireFiltersChanged();
        return o;
    }

    public List subList(int param, int param1) {
        return this.filters.subList(param, param1);
    }

    private void unhookCollection(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ((Filter)it.next()).removePropertyChangeListener(this.filterChangeListener);
        }
    }

    private void hookCollection(Collection c) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            ((Filter)it.next()).addPropertyChangeListener(this.filterChangeListener);
        }
    }
}

